/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Looper;
import android.view.SurfaceView;
import android.view.View;
import com.unity3d.player.UnityPlayer;
import com.unity3d.player.c;
import com.unity3d.player.d;
import com.unity3d.player.k;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class GoogleVrProxy {
    private k a = null;
    private boolean b = false;
    private boolean c = false;
    private Context d = null;
    private c e = null;
    private String f = "";
    private Runnable g = null;
    private a h = new a();

    public GoogleVrProxy(c c2) {
        this.initVrJni();
        this.e = c2;
    }

    private void a(boolean bl) {
        this.h.d = bl;
    }

    private boolean d() {
        return this.h.d;
    }

    public final boolean a() {
        return this.h.a;
    }

    public final void a(Intent intent) {
        if (intent != null && intent.getBooleanExtra("android.intent.extra.VR_LAUNCH", false)) {
            this.c = true;
        }
    }

    public final void b() {
        Activity activity = (Activity)this.d;
        if (this.c && !this.h.f && activity != null) {
            this.h.f = true;
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.HOME");
            intent.setFlags(0x10000000);
            activity.startActivity(intent);
        }
    }

    protected void pauseGvrLayout() {
        if (!this.h.a()) {
            return;
        }
        if (!this.h.e) {
            if (this.a != null) {
                this.a.a("pause", new Object[0]);
            }
            this.h.e = true;
        }
    }

    public final void c() {
        this.resumeGvrLayout();
    }

    protected void resumeGvrLayout() {
        if (!this.h.a()) {
            return;
        }
        if (this.h.e) {
            if (this.a != null) {
                this.a.a("resume", new Object[0]);
            }
            this.h.e = false;
        }
    }

    private void a(Runnable runnable) {
        if (this.d instanceof Activity) {
            ((Activity)this.d).runOnUiThread(runnable);
            return;
        }
        com.unity3d.player.d.Log(5, "Not running Google VR from an Activity; Ignoring execution request...");
    }

    private boolean b(final Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
            return true;
        }
        boolean bl = true;
        final Semaphore semaphore = new Semaphore(0);
        this.a(new Runnable(){

            @Override
            public final void run() {
                try {
                    runnable.run();
                    return;
                }
                catch (Exception exception) {
                    GoogleVrProxy.this.a("Exception unloading Google VR on UI Thread. " + exception.getLocalizedMessage());
                    return;
                }
                finally {
                    semaphore.release();
                }
            }
        });
        try {
            if (!semaphore.tryAcquire(4L, TimeUnit.SECONDS)) {
                bl = false;
                this.a("Timeout waiting for vr state change!");
            }
        }
        catch (InterruptedException interruptedException) {
            bl = false;
            this.a("Interrupted while trying to acquire sync lock. " + interruptedException.getLocalizedMessage());
        }
        return bl;
    }

    public final boolean a(Activity activity, Context context, SurfaceView surfaceView, Runnable object) {
        boolean bl;
        if (activity == null || context == null || surfaceView == null || object == null) {
            this.a("Invalid parameters passed to Google VR initiialization.");
            return false;
        }
        this.h.b();
        this.d = context;
        this.g = object;
        if (!GoogleVrProxy.a(19)) {
            this.a("Google VR requires a device that supports an api version of 19 (KitKat) or better.");
            return false;
        }
        if (this.c && !GoogleVrProxy.a(24)) {
            this.a("Daydream requires a device that supports an api version of 24 (Nougat) or better.");
            return false;
        }
        object = UnityPlayer.class.getClassLoader();
        if (!this.a((ClassLoader)object)) {
            return false;
        }
        try {
            bl = (Boolean)this.a.a("initialize", activity, context, surfaceView, this.c);
        }
        catch (Exception exception) {
            bl = false;
            this.a("Exception while trying to intialize Unity Google VR Library. " + exception.getLocalizedMessage());
        }
        if (!bl) {
            this.a("Unable to initialize GoogleVR library.");
            return false;
        }
        this.h.a = true;
        this.f = "";
        return true;
    }

    protected long loadGoogleVr(final boolean bl, final boolean bl2, final boolean bl3) {
        if (!this.h.a) {
            return 0L;
        }
        final AtomicLong atomicLong = new AtomicLong(0L);
        String string = this.f = bl || bl2 ? "Daydream" : "Cardboard";
        if (!this.b(new Runnable(){

            @Override
            public final void run() {
                try {
                    atomicLong.set((Long)GoogleVrProxy.this.a.a("load", bl, bl2, bl3, GoogleVrProxy.this.g));
                    ((GoogleVrProxy)GoogleVrProxy.this).h.b = true;
                    return;
                }
                catch (Exception exception) {
                    GoogleVrProxy.this.a("Exception caught while loading GoogleVR. " + exception.getLocalizedMessage());
                    atomicLong.set(0L);
                    return;
                }
            }
        }) || atomicLong.longValue() == 0L) {
            this.a("Google VR had a fatal issue while loading. VR will not be available.");
        }
        return atomicLong.longValue();
    }

    protected void setGoogleVrModeEnabled(final boolean bl) {
        if (!this.h.a()) {
            return;
        }
        if (this.e == null || this.d == null) {
            return;
        }
        this.a(new Runnable(){

            @Override
            public final void run() {
                if (bl == GoogleVrProxy.this.d()) {
                    return;
                }
                try {
                    if (bl && !GoogleVrProxy.this.d()) {
                        if (GoogleVrProxy.this.a != null && GoogleVrProxy.this.e != null && !GoogleVrProxy.this.e.addViewToPlayer((View)GoogleVrProxy.this.a.a("getGvrLayout", new Object[0]), true)) {
                            GoogleVrProxy.this.a("Unable to add Google VR to view hierarchy.");
                            return;
                        }
                        if (((GoogleVrProxy)GoogleVrProxy.this).h.e) {
                            GoogleVrProxy.this.resumeGvrLayout();
                        }
                        if (GoogleVrProxy.this.a != null) {
                            GoogleVrProxy.this.a.a("enable", true);
                        }
                        GoogleVrProxy.this.a(true);
                        return;
                    }
                    if (!bl && GoogleVrProxy.this.d()) {
                        GoogleVrProxy.this.a(false);
                        if (GoogleVrProxy.this.a != null) {
                            GoogleVrProxy.this.a.a("enable", false);
                        }
                        if (!((GoogleVrProxy)GoogleVrProxy.this).h.e) {
                            GoogleVrProxy.this.pauseGvrLayout();
                        }
                        if (GoogleVrProxy.this.a != null && GoogleVrProxy.this.e != null) {
                            GoogleVrProxy.this.e.removeViewFromPlayer((View)GoogleVrProxy.this.a.a("getGvrLayout", new Object[0]));
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    GoogleVrProxy.this.a("Exception enabling Google VR on UI Thread. " + exception.getLocalizedMessage());
                    return;
                }
            }
        });
    }

    protected void unloadGoogleVr() {
        if (this.h.d) {
            this.setGoogleVrModeEnabled(false);
        }
        if (this.h.c) {
            this.h.c = false;
        }
        this.a(new Runnable(){

            @Override
            public final void run() {
                try {
                    if (GoogleVrProxy.this.a != null) {
                        GoogleVrProxy.this.a.a("unload", new Object[0]);
                        GoogleVrProxy.this.a.a("deinitialize", new Object[0]);
                        GoogleVrProxy.f(GoogleVrProxy.this);
                    }
                    GoogleVrProxy.this.h.b();
                    return;
                }
                catch (Exception exception) {
                    GoogleVrProxy.this.a("Exception unloading Google VR on UI Thread. " + exception.getLocalizedMessage());
                    return;
                }
            }
        });
    }

    private boolean a(ClassLoader object) {
        try {
            object = ((ClassLoader)object).loadClass("com.unity3d.unitygvr.GoogleVR");
            Object obj = ((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
            object = new k((Class)object, obj);
            ((k)object).a("initialize", new Class[]{Activity.class, Context.class, SurfaceView.class, Boolean.TYPE});
            ((k)object).a("deinitialize", new Class[0]);
            ((k)object).a("load", new Class[]{Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Runnable.class});
            ((k)object).a("enable", new Class[]{Boolean.TYPE});
            ((k)object).a("unload", new Class[0]);
            ((k)object).a("pause", new Class[0]);
            ((k)object).a("resume", new Class[0]);
            ((k)object).a("getGvrLayout", new Class[0]);
            this.a = object;
            return true;
        }
        catch (Exception exception) {
            this.a("Exception initializing GoogleVR from Unity library. " + exception.getLocalizedMessage());
            return false;
        }
    }

    private void a(String string) {
        if (this.e != null) {
            this.e.reportError("Google VR Error [" + this.f + "]", string);
            return;
        }
        com.unity3d.player.d.Log(6, "Google VR Error [" + this.f + "]: " + string);
    }

    private static boolean a(int n) {
        return Build.VERSION.SDK_INT >= n;
    }

    private final native void initVrJni();

    static /* synthetic */ k f(GoogleVrProxy googleVrProxy) {
        googleVrProxy.a = null;
        return null;
    }

    final class a {
        public boolean a = false;
        public boolean b = false;
        public boolean c = false;
        public boolean d = false;
        public boolean e = true;
        public boolean f = false;

        a() {
        }

        public final boolean a() {
            return this.a && this.b;
        }

        public final void b() {
            this.a = false;
            this.b = false;
            this.d = false;
            this.e = true;
            this.f = false;
        }
    }
}

