/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.video360;

import android.content.Context;
import android.opengl.GLES20;
import com.loopme.R;
import com.loopme.video360.common.GLUtil;

public class MD360Program {
    private int mMVPMatrixHandle;
    private int mMVMatrixHandle;
    private int mTextureUniformHandle;
    private int mPositionHandle;
    private int mTextureCoordinateHandle;
    private int mProgramHandle;
    private int mContentType;

    public MD360Program(int type) {
        this.mContentType = type;
    }

    public void build(Context context) {
        String vertexShader = this.getVertexShader(context);
        String fragmentShader = this.getFragmentShader(context);
        int vertexShaderHandle = GLUtil.compileShader(35633, vertexShader);
        int fragmentShaderHandle = GLUtil.compileShader(35632, fragmentShader);
        this.mProgramHandle = GLUtil.createAndLinkProgram(vertexShaderHandle, fragmentShaderHandle, new String[]{"a_Position", "a_TexCoordinate"});
        this.mMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"u_MVPMatrix");
        this.mMVMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"u_MVMatrix");
        this.mTextureUniformHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"u_Texture");
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"a_Position");
        this.mTextureCoordinateHandle = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"a_TexCoordinate");
    }

    protected String getVertexShader(Context context) {
        return GLUtil.readTextFileFromRaw(context, R.raw.per_pixel_vertex_shader);
    }

    protected String getFragmentShader(Context context) {
        return FragmentShaderFactory.fs(context, this.mContentType);
    }

    public void use() {
        GLES20.glUseProgram((int)this.mProgramHandle);
    }

    public int getMVPMatrixHandle() {
        return this.mMVPMatrixHandle;
    }

    public int getMVMatrixHandle() {
        return this.mMVMatrixHandle;
    }

    public int getTextureUniformHandle() {
        return this.mTextureUniformHandle;
    }

    public int getPositionHandle() {
        return this.mPositionHandle;
    }

    public int getTextureCoordinateHandle() {
        return this.mTextureCoordinateHandle;
    }

    private static class FragmentShaderFactory {
        private FragmentShaderFactory() {
        }

        static String fs(Context context, int type) {
            switch (type) {
                default: 
            }
            int resId = R.raw.per_pixel_fragment_shader;
            return GLUtil.readTextFileFromRaw(context, resId);
        }
    }
}

