/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.tasks;

import com.loopme.common.AdParams;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.ResponseParser;
import com.loopme.common.Utils;
import com.loopme.debugging.ErrorLog;
import com.loopme.request.AdRequestParametersProvider;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;

public class AdFetcher
implements Runnable {
    private static final String LOG_TAG = AdFetcher.class.getSimpleName();
    private static final int RESPONSE_CODE_SUCCESS = 200;
    private static final int RESPONSE_CODE_UNKNOWN = 0;
    private final String mRequestUrl;
    private Listener mListener;
    private int mFormat;
    private String mAppKey;
    private LoopMeError mLoopMeError;
    private HttpURLConnection mUrlConnection;
    private static final String USER_AGENT = "User-Agent";

    public AdFetcher(String requestUrl, Listener listener, int format, String appKey) {
        this.mRequestUrl = requestUrl;
        this.mListener = listener;
        this.mFormat = format;
        this.mAppKey = appKey;
    }

    @Override
    public void run() {
        Logging.out(LOG_TAG, "Start making http request to server...");
        String result = this.getResponse(this.mRequestUrl);
        this.compete(result);
        Logging.out(LOG_TAG, "Response received.");
    }

    private void compete(String result) {
        if (result == null) {
            this.complete(null, this.mLoopMeError);
        } else {
            ResponseParser parser = new ResponseParser(new ResponseParser.Listener(){

                @Override
                public void onParseError(LoopMeError error) {
                    AdFetcher.this.complete(null, error);
                }
            }, this.mFormat);
            AdParams adParams = parser.getAdParams(result);
            if (adParams != null) {
                this.complete(adParams, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponse(String url) {
        int responseCode = 0;
        try {
            URL request = new URL(url);
            this.mUrlConnection = (HttpURLConnection)request.openConnection();
            this.mUrlConnection.setRequestProperty(USER_AGENT, this.getUserAgent());
            this.mUrlConnection.setReadTimeout(20000);
            this.mUrlConnection.setConnectTimeout(20000);
            responseCode = this.mUrlConnection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException();
            }
            BufferedInputStream in = new BufferedInputStream(this.mUrlConnection.getInputStream());
            String string = Utils.getStringFromStream(in);
            return string;
        }
        catch (SocketTimeoutException e2) {
            Logging.out(LOG_TAG + "timeout ad_request", "server");
            this.mLoopMeError = new LoopMeError("Request timeout");
            ErrorLog.post("Request timeout", "server", this.mAppKey);
        }
        catch (IOException e3) {
            Logging.out(LOG_TAG, e3.getMessage());
            if (responseCode != 0) {
                this.mLoopMeError = new LoopMeError("Server code: " + responseCode);
                ErrorLog.post("Bad servers response code " + responseCode, "server", this.mAppKey);
            }
        }
        finally {
            if (this.mUrlConnection != null) {
                this.mUrlConnection.disconnect();
            }
        }
        return null;
    }

    private String getUserAgent() {
        AdRequestParametersProvider provider = AdRequestParametersProvider.getInstance();
        return provider.getUserAgent();
    }

    private void complete(AdParams params, LoopMeError error) {
        if (this.mListener != null) {
            this.mListener.onComplete(params, error);
        }
    }

    public static interface Listener {
        public void onComplete(AdParams var1, LoopMeError var2);
    }
}

