/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.app.Activity;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.loopme.AdController;
import com.loopme.AdReceiver;
import com.loopme.BaseAd;
import com.loopme.LoopMeAdHolder;
import com.loopme.LoopMeInterstitialGeneral;
import com.loopme.MraidAdCloseButtonReceiver;
import com.loopme.common.Logging;
import com.loopme.mraid.MraidView;
import com.loopme.ui.view.CloseButton;

public class MraidActivity
extends Activity
implements AdReceiver.Listener,
MraidAdCloseButtonReceiver.MraidAdCloseButtonListener {
    private static final String LOG_TAG = MraidActivity.class.getSimpleName();
    private boolean mHasOwnCloseButton;
    private BaseAd mBaseAd;
    private int mFormat;
    private AdController mAdController;
    private RelativeLayout mLayout;
    private MraidView mMraidView;
    private AdReceiver mReceiver;
    private MraidAdCloseButtonReceiver mCloseButtonReceiver;
    private boolean mReceivedDestroyBroadcast;
    private CloseButton mCloseButton;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().setFlags(0x1000000, 0x1000000);
        this.mHasOwnCloseButton = this.getIntent().getBooleanExtra("customClose", false);
        this.mFormat = this.getIntent().getIntExtra("format", 0);
        this.mBaseAd = LoopMeAdHolder.getAd(this.getIntent(), this.mFormat);
        if (this.mBaseAd == null) {
            this.finish();
        }
        if (this.mBaseAd != null) {
            this.mAdController = this.mBaseAd.getAdController();
        }
        this.mLayout = this.buildLayout();
        if (this.mLayout == null) {
            return;
        }
        this.setContentView((View)this.mLayout);
        this.initCloseButton();
        this.initDestroyReceiver();
        this.initMraidAdCloseButtonReceiver();
        this.onInterstitialShowCallback();
    }

    private void onInterstitialShowCallback() {
        if (this.mBaseAd instanceof LoopMeInterstitialGeneral) {
            LoopMeInterstitialGeneral interstitial = (LoopMeInterstitialGeneral)this.mBaseAd;
            interstitial.onLoopMeInterstitialShow(interstitial);
        }
    }

    private void initMraidAdCloseButtonReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.loopme.MRAID_NEED_CLOSE_BUTTON");
        this.mCloseButtonReceiver = new MraidAdCloseButtonReceiver(this);
        this.registerReceiver(this.mCloseButtonReceiver, intentFilter);
    }

    private void initDestroyReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.loopme.DESTROY_INTENT");
        this.mReceiver = new AdReceiver(this);
        this.registerReceiver(this.mReceiver, filter);
    }

    private RelativeLayout buildLayout() {
        this.mLayout = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        if (this.mAdController != null) {
            this.mMraidView = this.mAdController.getMraidView();
        } else {
            Logging.out(LOG_TAG, "mAdController is null");
        }
        if (this.mMraidView != null) {
            if (this.mMraidView.getParent() != null) {
                ((ViewGroup)this.mMraidView.getParent()).removeView((View)this.mMraidView);
            } else {
                this.mLayout.addView((View)this.mMraidView, (ViewGroup.LayoutParams)params);
            }
            return this.mLayout;
        }
        return null;
    }

    private void initCloseButton() {
        this.mCloseButton = new CloseButton((Context)this);
        this.mCloseButton.addInLayout(this.mLayout);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v2) {
                MraidActivity.this.mAdController.getMraidController().close();
                MraidActivity.this.finish();
            }
        });
        if (this.mHasOwnCloseButton) {
            this.mCloseButton.setVisibility(8);
        }
    }

    protected void onDestroy() {
        Logging.out(LOG_TAG, "onDestroy");
        if (this.mAdController != null) {
            this.mAdController.setMraidWebViewState(3);
        }
        if (this.mReceiver != null) {
            this.unregisterReceiver(this.mReceiver);
        }
        if (this.mCloseButtonReceiver != null) {
            this.unregisterReceiver(this.mCloseButtonReceiver);
        }
        if (this.mLayout != null) {
            this.mLayout.removeAllViews();
        }
        if (this.mFormat == 1001) {
            ((LoopMeInterstitialGeneral)this.mBaseAd).onLoopMeInterstitialHide((LoopMeInterstitialGeneral)this.mBaseAd);
        }
        super.onDestroy();
    }

    protected void onResume() {
        super.onResume();
        this.mMraidView.notifySizeChangeEvent(400, 600);
        this.mMraidView.setIsViewable(true);
        if (this.mFormat == 1000) {
            this.mMraidView.setState("expanded");
        }
        if (this.mAdController != null) {
            this.mAdController.setMraidWebViewState(1);
        }
    }

    protected void onPause() {
        super.onPause();
        this.mMraidView.setIsViewable(false);
        if (!this.mReceivedDestroyBroadcast && this.mAdController != null) {
            this.mAdController.setMraidWebViewState(2);
        }
    }

    @Override
    public void onDestroyBroadcast(int adIdToClose) {
        if (this.mBaseAd.getAdId() != adIdToClose) {
            return;
        }
        Logging.out(LOG_TAG, "onDestroyBroadcast");
        this.mReceivedDestroyBroadcast = true;
        if (this.mReceiver != null) {
            this.unregisterReceiver(this.mReceiver);
            this.mReceiver = null;
        }
        this.finish();
    }

    @Override
    public void onClickBroadcast() {
        Logging.out(LOG_TAG, "onClickBroadcast() in Mraid Activity is not implemented");
    }

    @Override
    public void onCloseButtonVisibilityChanged(boolean customCloseButton) {
        if (customCloseButton) {
            this.mCloseButton.setVisibility(8);
        } else {
            this.mCloseButton.setVisibility(0);
        }
    }
}

