/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.video360.texture;

public abstract class MD360Texture {
    private static final int TEXTURE_EMPTY = 0;
    private static final String TAG = "MD360Texture";
    private int mWidth;
    private int mHeight;
    private ThreadLocal<Integer> mLocalGLTexture = new ThreadLocal();

    public void resize(int width, int height) {
        boolean changed = false;
        if (this.mWidth == width && this.mHeight == height) {
            changed = true;
        }
        this.mWidth = width;
        this.mHeight = height;
        if (changed) {
            this.onResize(this.mWidth, this.mHeight);
        }
    }

    public void create() {
        int glTexture = this.createTextureId();
        if (glTexture != 0) {
            this.mLocalGLTexture.set(glTexture);
        }
    }

    public void release() {
    }

    protected int getCurrentTextureId() {
        Integer value = this.mLocalGLTexture.get();
        return value != null ? value : 0;
    }

    protected final boolean isEmpty(int textureId) {
        return textureId == 0;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    protected abstract void onResize(int var1, int var2);

    protected abstract int createTextureId();

    public abstract void syncDrawInContext(ISyncDrawCallback var1);

    public static interface ISyncDrawCallback {
        public void onDrawOpenGL();
    }
}

