/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.app.Activity;
import android.content.Context;
import android.os.CountDownTimer;
import com.loopme.BaseAd;
import com.loopme.IntegrationType;
import com.loopme.LoopMeInterstitialGeneral;
import com.loopme.Settings;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.ResponseParser;

public class LoopMeInterstitial
extends Settings {
    public static final String TEST_PORT_INTERSTITIAL = "test_interstitial_p";
    public static final String TEST_LAND_INTERSTITIAL = "test_interstitial_l";
    private static final String LOG_TAG = LoopMeInterstitial.class.getSimpleName();
    private int mFailCounter;
    private String mAppKey;
    private Activity mActivity;
    private Listener mMainAdListener;
    private CountDownTimer mSleepLoadTimer;
    private LoopMeInterstitialGeneral mFirstInterstitial;
    private LoopMeInterstitialGeneral mSecondInterstitial;

    LoopMeInterstitial(Activity activity, String appKey) {
        this.mActivity = activity;
        this.mAppKey = appKey;
        this.mFirstInterstitial = LoopMeInterstitialGeneral.getInstance(appKey, activity);
        this.mSecondInterstitial = LoopMeInterstitialGeneral.getInstance(appKey, activity);
    }

    public static LoopMeInterstitial getInstance(String appKey, Activity activity) {
        return new LoopMeInterstitial(activity, appKey);
    }

    public void show() {
        if (!this.isShowing()) {
            if (this.isReady(this.mFirstInterstitial)) {
                this.show(this.mFirstInterstitial);
            } else if (this.isReady(this.mSecondInterstitial)) {
                this.show(this.mSecondInterstitial);
            }
        } else {
            Logging.out(LOG_TAG, "Interstitial is already presented on the screen");
        }
    }

    public void load(IntegrationType integrationType) {
        if (this.mFirstInterstitial != null && this.mSecondInterstitial != null) {
            this.mFirstInterstitial.setIntegrationType(integrationType);
            this.mSecondInterstitial.setIntegrationType(integrationType);
        }
        this.load();
    }

    public void load() {
        this.stopSleepLoadTimer();
        this.load(this.mFirstInterstitial);
        if (!ResponseParser.isApi19() && this.isAutoLoadingEnabled()) {
            this.load(this.mSecondInterstitial);
        }
    }

    public boolean isReady() {
        return this.isReady(this.mFirstInterstitial) || this.isReady(this.mSecondInterstitial);
    }

    public boolean isShowing() {
        return this.isShowing(this.mFirstInterstitial) || this.isShowing(this.mSecondInterstitial);
    }

    public boolean isLoading() {
        return this.isLoading(this.mFirstInterstitial) || this.isLoading(this.mSecondInterstitial);
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public Context getContext() {
        return this.mActivity;
    }

    public void dismiss() {
        this.dismiss(this.mFirstInterstitial);
        this.dismiss(this.mSecondInterstitial);
    }

    public int getAdFormat() {
        return 1001;
    }

    public void destroy() {
        this.destroyFirst();
        this.destroySecond();
        this.stopSleepLoadTimer();
    }

    public void setListener(Listener listener) {
        this.mMainAdListener = listener;
        this.setListener(this.initInternalListener(), this.mFirstInterstitial);
        this.setListener(this.initInternalListener(), this.mSecondInterstitial);
    }

    private LoopMeInterstitialGeneral.Listener initInternalListener() {
        return new LoopMeInterstitialGeneral.Listener(){

            @Override
            public void onLoopMeInterstitialLoadSuccess(LoopMeInterstitialGeneral interstitial) {
                if (LoopMeInterstitial.this.mMainAdListener != null) {
                    LoopMeInterstitial.this.mMainAdListener.onLoopMeInterstitialLoadSuccess(LoopMeInterstitial.this);
                }
                LoopMeInterstitial.this.mFailCounter = 0;
            }

            @Override
            public void onLoopMeInterstitialLoadFail(LoopMeInterstitialGeneral interstitial, LoopMeError error) {
                if (LoopMeInterstitial.this.mMainAdListener != null) {
                    LoopMeInterstitial.this.mMainAdListener.onLoopMeInterstitialLoadFail(LoopMeInterstitial.this, error);
                }
                LoopMeInterstitial.this.increaseFailCounter(interstitial);
            }

            @Override
            public void onLoopMeInterstitialShow(LoopMeInterstitialGeneral interstitial) {
                if (LoopMeInterstitial.this.mMainAdListener != null) {
                    LoopMeInterstitial.this.mMainAdListener.onLoopMeInterstitialShow(LoopMeInterstitial.this);
                }
            }

            @Override
            public void onLoopMeInterstitialHide(LoopMeInterstitialGeneral interstitial) {
                if (LoopMeInterstitial.this.mMainAdListener != null) {
                    LoopMeInterstitial.this.mMainAdListener.onLoopMeInterstitialHide(LoopMeInterstitial.this);
                }
                LoopMeInterstitial.this.reload(interstitial);
            }

            @Override
            public void onLoopMeInterstitialClicked(LoopMeInterstitialGeneral interstitial) {
                if (LoopMeInterstitial.this.mMainAdListener != null) {
                    LoopMeInterstitial.this.mMainAdListener.onLoopMeInterstitialClicked(LoopMeInterstitial.this);
                }
            }

            @Override
            public void onLoopMeInterstitialLeaveApp(LoopMeInterstitialGeneral interstitial) {
                if (LoopMeInterstitial.this.mMainAdListener != null) {
                    LoopMeInterstitial.this.mMainAdListener.onLoopMeInterstitialLeaveApp(LoopMeInterstitial.this);
                }
            }

            @Override
            public void onLoopMeInterstitialExpired(LoopMeInterstitialGeneral interstitial) {
                if (LoopMeInterstitial.this.mMainAdListener != null) {
                    LoopMeInterstitial.this.mMainAdListener.onLoopMeInterstitialExpired(LoopMeInterstitial.this);
                }
            }

            @Override
            public void onLoopMeInterstitialVideoDidReachEnd(LoopMeInterstitialGeneral interstitial) {
                if (LoopMeInterstitial.this.mMainAdListener != null) {
                    LoopMeInterstitial.this.mMainAdListener.onLoopMeInterstitialVideoDidReachEnd(LoopMeInterstitial.this);
                }
            }
        };
    }

    private void destroySecond() {
        if (this.mSecondInterstitial != null) {
            this.mSecondInterstitial.removeListener();
            this.mSecondInterstitial.destroy();
            this.mSecondInterstitial = null;
        }
    }

    private void destroyFirst() {
        if (this.mFirstInterstitial != null) {
            this.mFirstInterstitial.removeListener();
            this.mFirstInterstitial.destroy();
            this.mFirstInterstitial = null;
        }
    }

    private void increaseFailCounter(LoopMeInterstitialGeneral interstitial) {
        if (this.isAutoLoadingEnabled()) {
            if (this.mFailCounter > 4) {
                this.sleep(interstitial);
            } else {
                ++this.mFailCounter;
                Logging.out(LOG_TAG, "Attempt #" + this.mFailCounter);
                this.reload(interstitial);
            }
        }
    }

    private void sleep(LoopMeInterstitialGeneral interstitial) {
        if (this.mSleepLoadTimer == null) {
            this.mSleepLoadTimer = this.initSleepLoadTimer(interstitial);
            float sleepTimeout = 15.0f;
            Logging.out(LOG_TAG, "Sleep timeout: " + sleepTimeout + " minutes");
            this.mSleepLoadTimer.start();
        }
    }

    private CountDownTimer initSleepLoadTimer(LoopMeInterstitialGeneral interstitial) {
        return new CountDownTimer(900000L, 60000L){

            public void onTick(long millisUntilFinished) {
                Logging.out(LOG_TAG, "Till next attempt: " + millisUntilFinished / 60000L + " min.");
            }

            public void onFinish() {
                LoopMeInterstitial.this.mFailCounter = 0;
                LoopMeInterstitial.this.load();
            }
        };
    }

    protected void stopSleepLoadTimer() {
        if (this.mSleepLoadTimer != null) {
            Logging.out(LOG_TAG, "Stop sleep timer");
            this.mSleepLoadTimer.cancel();
            this.mSleepLoadTimer = null;
        }
        this.mFailCounter = 0;
    }

    private void reload(LoopMeInterstitialGeneral interstitial) {
        if (!ResponseParser.isApi19() && this.isAutoLoadingEnabled() && interstitial != null) {
            if (!this.isReady(this.mFirstInterstitial)) {
                this.load(this.mFirstInterstitial);
            }
            if (!this.isReady(this.mSecondInterstitial)) {
                this.load(this.mSecondInterstitial);
            }
        }
    }

    private void setListener(LoopMeInterstitialGeneral.Listener listener, LoopMeInterstitialGeneral interstitial) {
        if (interstitial != null) {
            interstitial.setListener(listener);
        }
    }

    public Listener getListener() {
        return this.mMainAdListener;
    }

    public void removeListener() {
        this.mMainAdListener = null;
        this.removeListener(this.mFirstInterstitial);
        this.removeListener(this.mSecondInterstitial);
    }

    public void clearCache() {
        this.clearCache(this.mFirstInterstitial);
        this.clearCache(this.mSecondInterstitial);
    }

    private void removeListener(LoopMeInterstitialGeneral interstitial) {
        if (interstitial != null) {
            interstitial.removeListener();
        }
    }

    private void clearCache(LoopMeInterstitialGeneral interstitial) {
        if (interstitial != null) {
            interstitial.clearCache();
        }
    }

    private void load(BaseAd baseAd) {
        if (baseAd != null) {
            baseAd.load();
        }
    }

    private void show(LoopMeInterstitialGeneral interstitial) {
        if (interstitial != null) {
            interstitial.show();
        }
    }

    private void dismiss(BaseAd baseAd) {
        if (baseAd != null) {
            baseAd.dismiss();
        }
    }

    private boolean isReady(BaseAd baseAd) {
        return baseAd != null && baseAd.isReady();
    }

    private boolean isShowing(BaseAd baseAd) {
        return baseAd != null && baseAd.isShowing();
    }

    private boolean isLoading(BaseAd baseAd) {
        return baseAd != null && baseAd.isLoading();
    }

    public void setKeywords(String keywords) {
        this.setKeywords(keywords, this.mFirstInterstitial);
        this.setKeywords(keywords, this.mSecondInterstitial);
    }

    public void setGender(String gender) {
        this.setGender(gender, this.mFirstInterstitial);
        this.setGender(gender, this.mSecondInterstitial);
    }

    public void setYearOfBirth(int year) {
        this.setYearOfBirth(year, this.mFirstInterstitial);
        this.setYearOfBirth(year, this.mSecondInterstitial);
    }

    private void setYearOfBirth(int year, BaseAd baseAd) {
        if (baseAd != null) {
            baseAd.setYearOfBirth(year);
        }
    }

    private void setKeywords(String keywords, BaseAd baseAd) {
        if (baseAd != null) {
            baseAd.setKeywords(keywords);
        }
    }

    private void setGender(String gender, BaseAd baseAd) {
        if (baseAd != null) {
            baseAd.setGender(gender);
        }
    }

    public static interface Listener {
        public void onLoopMeInterstitialLoadSuccess(LoopMeInterstitial var1);

        public void onLoopMeInterstitialLoadFail(LoopMeInterstitial var1, LoopMeError var2);

        public void onLoopMeInterstitialShow(LoopMeInterstitial var1);

        public void onLoopMeInterstitialHide(LoopMeInterstitial var1);

        public void onLoopMeInterstitialClicked(LoopMeInterstitial var1);

        public void onLoopMeInterstitialLeaveApp(LoopMeInterstitial var1);

        public void onLoopMeInterstitialExpired(LoopMeInterstitial var1);

        public void onLoopMeInterstitialVideoDidReachEnd(LoopMeInterstitial var1);
    }
}

