/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.app.Activity;
import android.content.Context;
import android.os.CountDownTimer;
import android.text.TextUtils;
import com.loopme.AdController;
import com.loopme.BaseAd;
import com.loopme.IntegrationType;
import com.loopme.LoopMeBannerGeneral;
import com.loopme.LoopMeBannerView;
import com.loopme.Settings;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.MinimizedMode;
import com.loopme.common.ResponseParser;

public class LoopMeBanner
extends Settings {
    public static final String TEST_MPU_BANNER = "test_mpu";
    private static final String FIRST_BANNER = "FIRST_BANNER";
    private static final String SECOND_BANNER = "SECOND_BANNER";
    private static final String LOG_TAG = LoopMeBanner.class.getSimpleName();
    private int mFailCounter;
    private String mAppKey;
    private Activity mActivity;
    private Listener mMainAdListener;
    private CountDownTimer mSleepLoadTimer;
    private LoopMeBannerGeneral mFirstBanner;
    private LoopMeBannerGeneral mSecondBanner;
    private volatile LoopMeBannerView mBannerView;
    private String mCurrentAd = "FIRST_BANNER";

    LoopMeBanner(Activity activity, String appKey) {
        this.mActivity = activity;
        this.mAppKey = appKey;
        this.mFirstBanner = LoopMeBannerGeneral.getInstance(appKey, activity);
        this.mSecondBanner = LoopMeBannerGeneral.getInstance(appKey, activity);
    }

    public static LoopMeBanner getInstance(String appKey, Activity activity) {
        return new LoopMeBanner(activity, appKey);
    }

    public void bindView(LoopMeBannerView viewGroup) {
        this.mBannerView = viewGroup;
    }

    private void bindView(LoopMeBannerView viewGroup, LoopMeBannerGeneral banner) {
        if (banner != null) {
            banner.bindView(viewGroup);
        }
    }

    public void setMinimizedMode(MinimizedMode mode) {
        this.setMinimizedMode(mode, this.mFirstBanner);
        this.setMinimizedMode(mode, this.mSecondBanner);
    }

    private void setMinimizedMode(MinimizedMode mode, LoopMeBannerGeneral banner) {
        if (banner != null) {
            banner.setMinimizedMode(mode);
        }
    }

    public LoopMeBannerView getBannerView() {
        return this.mBannerView;
    }

    public boolean isViewBinded() {
        return this.mBannerView != null;
    }

    public void pause() {
        this.pause(this.mFirstBanner);
        this.pause(this.mSecondBanner);
    }

    private void pause(LoopMeBannerGeneral banner) {
        if (banner != null) {
            banner.pause();
        }
    }

    public void show() {
        if (!this.isShowing()) {
            if (this.isReady(this.mFirstBanner)) {
                this.bindView(this.mBannerView, this.mFirstBanner);
                this.show(this.mFirstBanner);
                this.mCurrentAd = FIRST_BANNER;
            } else if (this.isReady(this.mSecondBanner)) {
                this.bindView(this.mBannerView, this.mSecondBanner);
                this.show(this.mSecondBanner);
                this.mCurrentAd = SECOND_BANNER;
            }
        } else {
            Logging.out(LOG_TAG, "Interstitial is already presented on the screen");
        }
    }

    public void showNativeVideo() {
        if (this.isReady(this.mFirstBanner)) {
            this.showNativeVideo(this.mFirstBanner);
        } else if (this.isReady(this.mSecondBanner)) {
            this.showNativeVideo(this.mSecondBanner);
        }
    }

    private void showNativeVideo(LoopMeBannerGeneral banner) {
        if (banner != null) {
            banner.showNativeVideo();
        }
    }

    public void resume() {
        this.resume(this.mFirstBanner);
        this.resume(this.mSecondBanner);
    }

    private void resume(LoopMeBannerGeneral banner) {
        if (banner != null && banner.isShowing()) {
            banner.resume();
        }
    }

    public void switchToMinimizedMode() {
        this.switchToMinimizedMode(this.mFirstBanner);
        this.switchToMinimizedMode(this.mSecondBanner);
    }

    public void switchToMinimizedMode(LoopMeBannerGeneral banner) {
        if (banner != null) {
            banner.switchToMinimizedMode();
        }
    }

    public void switchToNormalMode() {
        this.switchToNormalMode(this.mFirstBanner);
        this.switchToNormalMode(this.mSecondBanner);
    }

    private void switchToNormalMode(LoopMeBannerGeneral banner) {
        if (banner != null) {
            banner.switchToNormalMode();
        }
    }

    public AdController getAdController() {
        if (this.isReady(this.mFirstBanner)) {
            return this.mFirstBanner.getAdController();
        }
        if (this.isReady(this.mSecondBanner)) {
            return this.mSecondBanner.getAdController();
        }
        return null;
    }

    public void load(IntegrationType integrationType) {
        if (this.mFirstBanner != null && this.mSecondBanner != null) {
            this.mFirstBanner.setIntegrationType(integrationType);
            this.mSecondBanner.setIntegrationType(integrationType);
        }
        this.load();
    }

    public void load() {
        this.stopSleepLoadTimer();
        this.load(this.mFirstBanner);
        if (!ResponseParser.isApi19() && this.isAutoLoadingEnabled()) {
            this.load(this.mSecondBanner);
        }
    }

    public boolean isReady() {
        return this.isReady(this.mFirstBanner) || this.isReady(this.mSecondBanner);
    }

    public boolean isShowing() {
        return this.isShowing(this.mFirstBanner) || this.isShowing(this.mSecondBanner);
    }

    public boolean isLoading() {
        return this.isLoading(this.mFirstBanner) || this.isLoading(this.mSecondBanner);
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public Context getContext() {
        return this.mActivity;
    }

    public void dismiss() {
        this.dismiss(this.mFirstBanner);
        this.dismiss(this.mSecondBanner);
        this.loadCurrentBanner();
    }

    private void loadCurrentBanner() {
        if (TextUtils.equals((CharSequence)this.mCurrentAd, (CharSequence)FIRST_BANNER)) {
            this.reload(this.mFirstBanner);
        } else {
            this.reload(this.mSecondBanner);
        }
    }

    public int getAdFormat() {
        return 1000;
    }

    public void destroy() {
        this.destroyFirst();
        this.destroySecond();
        this.stopSleepLoadTimer();
        this.destroyBannersView();
    }

    private void destroyBannersView() {
        if (this.mFirstBanner != null) {
            this.mFirstBanner.destroyBannerView();
        }
        if (this.mSecondBanner != null) {
            this.mSecondBanner.destroyBannerView();
        }
    }

    public void setListener(Listener listener) {
        this.mMainAdListener = listener;
        this.setListener(this.initInternalListener(), this.mFirstBanner);
        this.setListener(this.initInternalListener(), this.mSecondBanner);
    }

    private LoopMeBannerGeneral.Listener initInternalListener() {
        return new LoopMeBannerGeneral.Listener(){

            @Override
            public void onLoopMeBannerLoadSuccess(LoopMeBannerGeneral banner) {
                if (LoopMeBanner.this.mMainAdListener != null) {
                    LoopMeBanner.this.mMainAdListener.onLoopMeBannerLoadSuccess(LoopMeBanner.this);
                }
                LoopMeBanner.this.mFailCounter = 0;
            }

            @Override
            public void onLoopMeBannerLoadFail(LoopMeBannerGeneral banner, LoopMeError error) {
                if (LoopMeBanner.this.mMainAdListener != null) {
                    LoopMeBanner.this.mMainAdListener.onLoopMeBannerLoadFail(LoopMeBanner.this, error);
                }
                LoopMeBanner.this.increaseFailCounter(banner);
            }

            @Override
            public void onLoopMeBannerShow(LoopMeBannerGeneral banner) {
                if (LoopMeBanner.this.mMainAdListener != null) {
                    LoopMeBanner.this.mMainAdListener.onLoopMeBannerShow(LoopMeBanner.this);
                }
            }

            @Override
            public void onLoopMeBannerHide(LoopMeBannerGeneral banner) {
                if (LoopMeBanner.this.mMainAdListener != null) {
                    LoopMeBanner.this.mMainAdListener.onLoopMeBannerHide(LoopMeBanner.this);
                }
            }

            @Override
            public void onLoopMeBannerClicked(LoopMeBannerGeneral banner) {
                if (LoopMeBanner.this.mMainAdListener != null) {
                    LoopMeBanner.this.mMainAdListener.onLoopMeBannerClicked(LoopMeBanner.this);
                }
            }

            @Override
            public void onLoopMeBannerLeaveApp(LoopMeBannerGeneral banner) {
                if (LoopMeBanner.this.mMainAdListener != null) {
                    LoopMeBanner.this.mMainAdListener.onLoopMeBannerLeaveApp(LoopMeBanner.this);
                }
            }

            @Override
            public void onLoopMeBannerVideoDidReachEnd(LoopMeBannerGeneral banner) {
                if (LoopMeBanner.this.mMainAdListener != null) {
                    LoopMeBanner.this.mMainAdListener.onLoopMeBannerVideoDidReachEnd(LoopMeBanner.this);
                }
            }

            @Override
            public void onLoopMeBannerExpired(LoopMeBannerGeneral banner) {
                if (LoopMeBanner.this.mMainAdListener != null) {
                    LoopMeBanner.this.mMainAdListener.onLoopMeBannerExpired(LoopMeBanner.this);
                }
            }
        };
    }

    private void destroySecond() {
        if (this.mSecondBanner != null) {
            this.mSecondBanner.removeListener();
            this.mSecondBanner.destroy();
            this.mSecondBanner = null;
        }
    }

    private void destroyFirst() {
        if (this.mFirstBanner != null) {
            this.mFirstBanner.removeListener();
            this.mFirstBanner.destroy();
            this.mFirstBanner = null;
        }
    }

    private void increaseFailCounter(LoopMeBannerGeneral banner) {
        if (this.isAutoLoadingEnabled()) {
            if (this.mFailCounter > 4) {
                this.sleep(banner);
            } else {
                ++this.mFailCounter;
                Logging.out(LOG_TAG, "Attempt #" + this.mFailCounter);
                this.reload(banner);
            }
        }
    }

    private void sleep(LoopMeBannerGeneral banner) {
        if (this.mSleepLoadTimer == null) {
            this.mSleepLoadTimer = this.initSleepLoadTimer(banner);
            float sleepTimeout = 15.0f;
            Logging.out(LOG_TAG, "Sleep timeout: " + sleepTimeout + " minutes");
            this.mSleepLoadTimer.start();
        }
    }

    private CountDownTimer initSleepLoadTimer(LoopMeBannerGeneral banner) {
        return new CountDownTimer(900000L, 60000L){

            public void onTick(long millisUntilFinished) {
                Logging.out(LOG_TAG, "Till next attempt: " + millisUntilFinished / 60000L + " min.");
            }

            public void onFinish() {
                LoopMeBanner.this.stopSleepLoadTimer();
                LoopMeBanner.this.load();
            }
        };
    }

    protected void stopSleepLoadTimer() {
        if (this.mSleepLoadTimer != null) {
            Logging.out(LOG_TAG, "Stop sleep timer");
            this.mSleepLoadTimer.cancel();
            this.mSleepLoadTimer = null;
        }
        this.mFailCounter = 0;
    }

    private void reload(LoopMeBannerGeneral banner) {
        if (!ResponseParser.isApi19() && this.isAutoLoadingEnabled() && banner != null) {
            if (!this.isReady(this.mFirstBanner)) {
                this.load(this.mFirstBanner);
            }
            if (!this.isReady(this.mSecondBanner)) {
                this.load(this.mSecondBanner);
            }
        }
    }

    private void setListener(LoopMeBannerGeneral.Listener listener, LoopMeBannerGeneral banner) {
        if (banner != null) {
            banner.setListener(listener);
        }
    }

    public Listener getListener() {
        return this.mMainAdListener;
    }

    public void removeListener() {
        this.mMainAdListener = null;
        this.removeListener(this.mFirstBanner);
        this.removeListener(this.mSecondBanner);
    }

    public void clearCache() {
        this.clearCache(this.mFirstBanner);
        this.clearCache(this.mSecondBanner);
    }

    private void removeListener(LoopMeBannerGeneral banner) {
        if (banner != null) {
            banner.removeListener();
        }
    }

    private void clearCache(LoopMeBannerGeneral banner) {
        if (banner != null) {
            banner.clearCache();
        }
    }

    private void load(BaseAd baseAd) {
        if (baseAd != null) {
            baseAd.load();
        }
    }

    private boolean isReady(BaseAd baseAd) {
        return baseAd != null && baseAd.isReady();
    }

    private boolean isShowing(BaseAd baseAd) {
        return baseAd != null && baseAd.isShowing();
    }

    private boolean isLoading(BaseAd baseAd) {
        return baseAd != null && baseAd.isLoading();
    }

    private void show(LoopMeBannerGeneral banner) {
        if (banner != null) {
            banner.show();
        }
    }

    private void dismiss(BaseAd baseAd) {
        if (baseAd != null) {
            baseAd.dismiss();
        }
    }

    public void setKeywords(String keywords) {
        this.setKeywords(keywords, this.mFirstBanner);
        this.setKeywords(keywords, this.mSecondBanner);
    }

    public void setGender(String gender) {
        this.setGender(gender, this.mFirstBanner);
        this.setGender(gender, this.mSecondBanner);
    }

    public void setYearOfBirth(int year) {
        this.setYearOfBirth(year, this.mFirstBanner);
        this.setYearOfBirth(year, this.mSecondBanner);
    }

    private void setYearOfBirth(int year, BaseAd baseAd) {
        if (baseAd != null) {
            baseAd.setYearOfBirth(year);
        }
    }

    private void setKeywords(String keywords, BaseAd baseAd) {
        if (baseAd != null) {
            baseAd.setKeywords(keywords);
        }
    }

    private void setGender(String gender, BaseAd baseAd) {
        if (baseAd != null) {
            baseAd.setGender(gender);
        }
    }

    public static interface Listener {
        public void onLoopMeBannerLoadSuccess(LoopMeBanner var1);

        public void onLoopMeBannerLoadFail(LoopMeBanner var1, LoopMeError var2);

        public void onLoopMeBannerShow(LoopMeBanner var1);

        public void onLoopMeBannerHide(LoopMeBanner var1);

        public void onLoopMeBannerClicked(LoopMeBanner var1);

        public void onLoopMeBannerLeaveApp(LoopMeBanner var1);

        public void onLoopMeBannerVideoDidReachEnd(LoopMeBanner var1);

        public void onLoopMeBannerExpired(LoopMeBanner var1);
    }
}

