/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.ui.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v4.content.res.ResourcesCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.loopme.R;
import com.loopme.common.Utils;

public class CloseButton
extends View {
    private static final int EDGING_DP = 2;
    private static final int THICKNESS_DP = 4;
    private static final int OFFSET_DP = 14;
    private static final int CUSTOM_VIEW_SIZE_DP = 16;
    private static final int CLICKABLE_VIEW_SIZE_DP = 48;
    private Paint mPaint = new Paint();

    public CloseButton(Context context) {
        super(context);
    }

    public CloseButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CloseButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        int offsetPx = Utils.convertDpToPixel(14.0f);
        int viewSize = Utils.convertDpToPixel(30.0f);
        this.drawEdging(canvas, offsetPx, viewSize);
        this.drawWitheCross(canvas, offsetPx, viewSize);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int sizePx = Utils.convertDpToPixel(48.0f);
        this.setMeasuredDimension(sizePx, sizePx);
    }

    private void drawEdging(Canvas canvas, int offsetDp, int viewSize) {
        float thickness = Utils.convertDpToPixel(6.0f);
        this.mPaint.setStrokeWidth(thickness);
        this.mPaint.setColor(ResourcesCompat.getColor((Resources)this.getResources(), (int)R.color.black, null));
        this.drawCross(canvas, offsetDp, viewSize, thickness, this.mPaint);
    }

    private void drawWitheCross(Canvas canvas, int offsetDp, int viewSize) {
        int thickness = Utils.convertDpToPixel(4.0f);
        this.mPaint.setStrokeWidth((float)thickness);
        this.mPaint.setColor(ResourcesCompat.getColor((Resources)this.getResources(), (int)R.color.white, null));
        this.drawCross(canvas, offsetDp, viewSize, thickness, this.mPaint);
    }

    private void drawCross(Canvas canvas, int offsetDp, int viewSize, float thickness, Paint mPaint) {
        canvas.drawLine((float)offsetDp, (float)offsetDp, (float)viewSize, (float)viewSize, mPaint);
        canvas.drawLine((float)offsetDp, (float)viewSize, (float)viewSize, (float)offsetDp, mPaint);
        canvas.drawCircle((float)offsetDp, (float)offsetDp, thickness / 2.0f, mPaint);
        canvas.drawCircle((float)viewSize, (float)viewSize, thickness / 2.0f, mPaint);
        canvas.drawCircle((float)offsetDp, (float)viewSize, thickness / 2.0f, mPaint);
        canvas.drawCircle((float)viewSize, (float)offsetDp, thickness / 2.0f, mPaint);
    }

    public void addInLayout(RelativeLayout parentLayout) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(11);
        parentLayout.addView((View)this, (ViewGroup.LayoutParams)layoutParams);
    }
}

