/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.tasks;

import android.os.CountDownTimer;
import com.loopme.common.Logging;

public class RequestTimer
extends CountDownTimer {
    private static final String LOG_TAG = RequestTimer.class.getSimpleName();
    private static final long TICK_INTERVAL_IN_MILLIS = 1000L;
    private Listener mListener;

    public RequestTimer(long millisInFuture, Listener requestTimerListener) {
        super(millisInFuture, 1000L);
        this.mListener = requestTimerListener;
    }

    public void startTimer() {
        Logging.out(LOG_TAG, "start request timer");
        this.start();
    }

    public void stopTimer() {
        Logging.out(LOG_TAG, "stop request timer");
        this.cancel();
    }

    public void onTick(long millisUntilFinished) {
    }

    public void onFinish() {
        if (this.mListener != null) {
            this.mListener.onTimeout();
        }
    }

    public static interface Listener {
        public void onTimeout();
    }
}

