/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.request;

import android.text.TextUtils;
import com.loopme.common.Logging;
import com.loopme.request.CustomRequestParameter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class AdTargetingData {
    private static final String LOG_TAG = AdTargetingData.class.getSimpleName();
    private String mKeywords;
    private int mYearOfBirth;
    private String mGender;
    private List<CustomRequestParameter> mCustomParams = new ArrayList<CustomRequestParameter>();

    public void clear() {
        this.mKeywords = null;
        this.mYearOfBirth = 0;
        this.mGender = null;
        this.mCustomParams.clear();
    }

    public void setKeywords(String keywords) {
        this.mKeywords = keywords;
    }

    public String getKeywords() {
        return this.mKeywords;
    }

    public void setYob(int yob) {
        int currentYear = Calendar.getInstance().get(1);
        if (yob >= 1900 && yob <= currentYear) {
            this.mYearOfBirth = yob;
        }
    }

    public int getYob() {
        return this.mYearOfBirth;
    }

    public List<CustomRequestParameter> getCustomParameters() {
        return this.mCustomParams;
    }

    public void setCustomParameters(String paramName, String paramValue) {
        if (!TextUtils.isEmpty((CharSequence)paramValue) && !TextUtils.isEmpty((CharSequence)paramName)) {
            this.mCustomParams.add(new CustomRequestParameter(paramName, paramValue));
        }
    }

    public void setGender(String gender) {
        if (gender == null) {
            return;
        }
        if (gender.equalsIgnoreCase("f") || gender.equalsIgnoreCase("m") || gender.equalsIgnoreCase("female") || gender.equalsIgnoreCase("male")) {
            this.mGender = gender;
        } else {
            Logging.out(LOG_TAG, "Wrong gender value");
        }
    }

    public String getGender() {
        return this.mGender;
    }
}

