/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.mraid;

import android.content.Context;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.loopme.MraidController;
import com.loopme.adview.AdViewChromeClient;
import com.loopme.adview.BridgeCommandBuilder;
import com.loopme.common.Logging;
import com.loopme.constants.WebviewState;
import com.loopme.mraid.MraidBridge;

public class MraidView
extends WebView {
    private int mViewState = 3;
    private static final String LOG_TAG = MraidView.class.getSimpleName();
    public static final String JAVASCRIPT = "javascript:";

    public MraidView(Context context, MraidController mraidController) {
        super(context);
        this.init(mraidController);
    }

    private void init(MraidController mraidController) {
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setPluginState(WebSettings.PluginState.ON);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        webSettings.setSupportZoom(false);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setDomStorageEnabled(true);
        Logging.out(LOG_TAG, "Encoding: " + webSettings.getDefaultTextEncodingName());
        this.setWebChromeClient(new AdViewChromeClient());
        mraidController.setMraidView(this);
        this.setWebViewClient(new MraidBridge(mraidController));
    }

    public void setIsViewable(boolean isViewable) {
        String command = "mraidbridge.setIsViewable(" + isViewable + ")";
        Logging.out(LOG_TAG, "setIsViewable " + isViewable);
        this.loadUrl(JAVASCRIPT + command);
    }

    public void notifyReady() {
        String command = "mraidbridge.notifyReadyEvent();";
        Logging.out(LOG_TAG, "notifyReady");
        this.loadUrl(JAVASCRIPT + command);
    }

    public void notifyError() {
        String command = "mraidbridge.notifyErrorEvent();";
        Logging.out(LOG_TAG, "notifyError");
        this.loadUrl(JAVASCRIPT + command);
    }

    public void notifyStateChange() {
        String command = "mraidbridge.notifyStateChangeEvent();";
        Logging.out(LOG_TAG, "state changed");
        this.loadUrl(JAVASCRIPT + command);
    }

    public void setState(String state) {
        String command = "mraidbridge.setState('" + state + "');";
        Logging.out(LOG_TAG, "setState " + state);
        this.loadUrl(JAVASCRIPT + command);
    }

    public void notifySizeChangeEvent(int w2, int h2) {
        String command = "mraidbridge.notifySizeChangeEvent(" + w2 + "," + h2 + ");";
        Logging.out(LOG_TAG, "notifySizeChangeEvent");
        this.loadUrl(JAVASCRIPT + command);
    }

    public void resize() {
        String command = "mraidbridge.resize();";
        Logging.out(LOG_TAG, "resize " + command);
        this.loadUrl(JAVASCRIPT + command);
    }

    public void setWebViewState(int state) {
        if (this.mViewState != state) {
            this.mViewState = state;
            Logging.out(LOG_TAG, "MRAID WEBVIEW : " + WebviewState.toString(state));
            String command = new BridgeCommandBuilder().webviewState(this.mViewState);
            this.loadUrl(command);
        }
    }
}

