/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.adview;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Vibrator;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.loopme.adview.AdView;
import com.loopme.common.Logging;
import com.loopme.debugging.ErrorLog;
import java.net.URI;
import java.net.URISyntaxException;

public class Bridge
extends WebViewClient {
    private static final String LOG_TAG = Bridge.class.getSimpleName();
    private static final String LOOPME = "loopme";
    private static final String WEBVIEW = "webview";
    private static final String VIDEO = "video";
    private static final String WEBVIEW_CLOSE = "/close";
    private static final String WEBVIEW_FAIL = "/fail";
    private static final String WEBVIEW_SUCCESS = "/success";
    private static final String WEBVIEW_VIBRATE = "/vibrate";
    private static final String WEBVIEW_FULLSCREEN = "/fullscreenMode";
    private static final String VIDEO_LOAD = "/load";
    private static final String VIDEO_MUTE = "/mute";
    private static final String VIDEO_PLAY = "/play";
    private static final String VIDEO_PAUSE = "/pause";
    private static final String VIDEO_ENABLE_STRETCH = "/enableStretching";
    private static final String VIDEO_DISABLE_STRETCH = "/disableStretching";
    private static final String QUERY_PARAM_SRC = "src";
    private static final String QUERY_PARAM_CURRENT_TIME = "currentTime";
    private static final String QUERY_PARAM_MUTE = "mute";
    private static final String QUERY_PARAM_FULLSCREEN_MODE = "mode";
    private static final int VIBRATE_MILLISECONDS = 500;
    private Listener mListener;
    private Context mContext;

    public Bridge(Listener listener, Context context) {
        if (listener != null && context != null) {
            this.mListener = listener;
            this.mContext = context;
        } else {
            Logging.out(LOG_TAG, "VideoBridgeListener should not be null");
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Logging.out(LOG_TAG, "shouldOverrideUrlLoading " + url);
        if (TextUtils.isEmpty((CharSequence)url)) {
            ErrorLog.post("Broken redirect in bridge: " + url, "js");
            return false;
        }
        Context context = view.getContext();
        URI redirect = null;
        try {
            redirect = new URI(url);
        }
        catch (URISyntaxException e2) {
            Logging.out(LOG_TAG, e2.getMessage());
            e2.printStackTrace();
            ErrorLog.post("Broken redirect in bridge: " + url, "js");
            this.handleExtraUrl(url);
            return true;
        }
        String protocol = redirect.getScheme();
        if (TextUtils.isEmpty((CharSequence)protocol)) {
            return false;
        }
        if (protocol.equalsIgnoreCase(LOOPME)) {
            ((AdView)view).sendNativeCallFinished();
            String host = redirect.getHost();
            String path = redirect.getPath();
            if (TextUtils.isEmpty((CharSequence)host) || TextUtils.isEmpty((CharSequence)path)) {
                return false;
            }
            if (host.equalsIgnoreCase(WEBVIEW)) {
                this.handleWebviewCommands(path, url, context);
            } else if (host.equalsIgnoreCase(VIDEO)) {
                this.handleVideoCommands(path, url);
            }
        } else if (this.mListener != null) {
            this.mListener.onNonLoopMe(url);
        }
        return true;
    }

    private void handleExtraUrl(String url) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        intent.addFlags(0x10000000);
        if (this.startActivity(intent)) {
            this.onLeaveApp();
        }
    }

    private void onLeaveApp() {
        if (this.mListener != null) {
            this.mListener.onLeaveApp();
        }
    }

    private boolean startActivity(Intent intent) {
        try {
            if (this.mContext != null) {
                this.mContext.startActivity(intent);
                return true;
            }
        }
        catch (ActivityNotFoundException e2) {
            e2.printStackTrace();
        }
        return false;
    }

    private void handleWebviewCommands(String command, String url, Context context) {
        if (command == null || this.mListener == null) {
            return;
        }
        switch (command) {
            case "/close": {
                this.mListener.onJsClose();
                break;
            }
            case "/vibrate": {
                this.handleVibrate(context);
                break;
            }
            case "/fail": {
                this.mListener.onJsLoadFail("Ad received specific URL loopme://webview/fail");
                break;
            }
            case "/fullscreenMode": {
                this.handleFullscreenMode(url);
                break;
            }
            case "/success": {
                this.mListener.onJsLoadSuccess();
                this.onCreateMoatWebAdTracker();
                break;
            }
        }
    }

    private void handleFullscreenMode(String url) {
        try {
            Uri uri = Uri.parse((String)url);
            String modeStr = this.detectQueryParameter(uri, QUERY_PARAM_FULLSCREEN_MODE);
            if (!this.isValidBooleanParameter(modeStr)) {
                ErrorLog.post("Empty parameter in js command: fullscreen mode", "js");
            } else {
                this.mListener.onJsFullscreenMode(Boolean.parseBoolean(modeStr));
            }
        }
        catch (NullPointerException | UnsupportedOperationException e2) {
            e2.printStackTrace();
        }
    }

    private boolean isValidBooleanParameter(String modeStr) {
        return !TextUtils.isEmpty((CharSequence)modeStr) && (modeStr.equalsIgnoreCase(Boolean.TRUE.toString()) || modeStr.equalsIgnoreCase(Boolean.FALSE.toString()));
    }

    private void handleVibrate(Context context) {
        try {
            Vibrator vibrator = (Vibrator)context.getSystemService("vibrator");
            if (vibrator != null) {
                vibrator.vibrate(500L);
            }
        }
        catch (Exception e2) {
            Logging.out(LOG_TAG, "Missing permission for vibrate");
        }
    }

    private void handleVideoCommands(String command, String url) {
        Uri uri;
        if (command == null || this.mListener == null) {
            return;
        }
        try {
            uri = Uri.parse((String)url);
        }
        catch (NullPointerException e2) {
            e2.printStackTrace();
            return;
        }
        switch (command) {
            case "/load": {
                this.onCreateMoatNativeTracker();
                String videoUrl = this.detectQueryParameter(uri, QUERY_PARAM_SRC);
                if (!TextUtils.isEmpty((CharSequence)videoUrl)) {
                    this.mListener.onJsVideoLoad(videoUrl);
                    break;
                }
                ErrorLog.post("Empty parameter in js command: src", "js");
                break;
            }
            case "/mute": {
                String muteStr = this.detectQueryParameter(uri, QUERY_PARAM_MUTE);
                if (this.isValidBooleanParameter(muteStr)) {
                    this.mListener.onJsVideoMute(Boolean.parseBoolean(muteStr));
                    break;
                }
                ErrorLog.post("Empty parameter in js command: mute", "js");
                break;
            }
            case "/play": {
                String playStr = this.detectQueryParameter(uri, QUERY_PARAM_CURRENT_TIME);
                int time = 0;
                if (playStr != null) {
                    time = Integer.parseInt(playStr);
                }
                this.mListener.onJsVideoPlay(time);
                break;
            }
            case "/pause": {
                String pauseStr = this.detectQueryParameter(uri, QUERY_PARAM_CURRENT_TIME);
                int pause_time = 0;
                if (pauseStr != null) {
                    pause_time = Integer.parseInt(pauseStr);
                }
                this.mListener.onJsVideoPause(pause_time);
                break;
            }
            case "/enableStretching": {
                this.mListener.onJsVideoStretch(true);
                break;
            }
            case "/disableStretching": {
                this.mListener.onJsVideoStretch(false);
                break;
            }
        }
    }

    private String detectQueryParameter(Uri uri, String parameter) {
        String result = null;
        try {
            result = uri.getQueryParameter(parameter);
        }
        catch (NullPointerException | UnsupportedOperationException e2) {
            e2.printStackTrace();
        }
        return result;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        if (this.mListener != null) {
            this.mListener.onJsLoadFail("onReceivedError " + description);
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        Logging.out(LOG_TAG, "onPageStarted");
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView webView, String url) {
        Logging.out(LOG_TAG, "onPageFinished");
        super.onPageFinished(webView, url);
    }

    private void onCreateMoatNativeTracker() {
        if (this.mListener != null) {
            this.mListener.onCreateMoatNativeTracker();
        }
    }

    private void onCreateMoatWebAdTracker() {
        if (this.mListener != null) {
            this.mListener.onCreateMoatWebAdTracker();
        }
    }

    public static interface Listener {
        public void onJsClose();

        public void onJsLoadSuccess();

        public void onJsLoadFail(String var1);

        public void onJsFullscreenMode(boolean var1);

        public void onJsVideoLoad(String var1);

        public void onJsVideoMute(boolean var1);

        public void onJsVideoPlay(int var1);

        public void onJsVideoPause(int var1);

        public void onJsVideoStretch(boolean var1);

        public void onNonLoopMe(String var1);

        public void onCreateMoatNativeTracker();

        public void onCreateMoatWebAdTracker();

        public void onLeaveApp();
    }
}

