/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.json.JSONException;
import org.json.JSONObject;

public class HtmlParser {
    private static final String ADID = "ADID";
    private static final String CAMP_NAME = "CAMP_NAME";
    private static final String LI_NAME = "LI_NAME";
    private static final String CREATIVEID = "CREATIVEID";
    private static final String APP_NAME = "APP_NAME";
    private static final String ADVERTISER = "ADVERTISER";
    private static final String MACROS = "macros";
    private static final String EMPTY_STRING = "";
    private String mHtml;
    private String mJsonScript;

    public HtmlParser() {
    }

    public HtmlParser(String html) {
        this.mHtml = html;
        this.mJsonScript = this.mHtml.substring(this.mHtml.indexOf("{"), this.mHtml.lastIndexOf("}"));
    }

    public String getObject(String name) {
        try {
            JSONObject jsonObject = new JSONObject(this.mJsonScript);
            String param = jsonObject.getJSONObject(MACROS).getString(name);
            String decodedParam = HtmlParser.decode(param);
            return decodedParam;
        }
        catch (JSONException e2) {
            e2.printStackTrace();
            return EMPTY_STRING;
        }
    }

    @Deprecated
    public static String decode(String source) {
        try {
            return URLDecoder.decode(source, "UTF-8");
        }
        catch (UnsupportedEncodingException var2) {
            return URLDecoder.decode(source);
        }
    }

    public String getAdvertiserId() {
        return this.getObject(ADVERTISER);
    }

    public String getCampaignId() {
        return this.getObject(CAMP_NAME);
    }

    public String getLineItemId() {
        return this.getObject(LI_NAME);
    }

    public String getCreativeId() {
        return this.getObject(CREATIVEID);
    }

    public String getAppId() {
        return this.getObject(APP_NAME);
    }

    public String getPlacementId() {
        return EMPTY_STRING;
    }
}

