/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.video360.texture;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.view.Surface;
import com.loopme.common.Logging;
import com.loopme.video360.MDVRLibrary;
import com.loopme.video360.common.GLUtil;
import com.loopme.video360.texture.MD360Texture;

public class MD360VideoTexture
extends MD360Texture {
    private static final String LOG_TAG = MD360VideoTexture.class.getSimpleName();
    private Surface mSurface;
    private SurfaceTexture mSurfaceTexture;
    private MDVRLibrary.IOnSurfaceReadyCallback mOnSurfaceReadyListener;

    public MD360VideoTexture(MDVRLibrary.IOnSurfaceReadyCallback onSurfaceReadyListener) {
        this.mOnSurfaceReadyListener = onSurfaceReadyListener;
    }

    @Override
    public void release() {
        super.release();
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
        }
        this.mSurfaceTexture = null;
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        this.mSurface = null;
    }

    @Override
    public void create() {
        super.create();
        int glSurfaceTexture = this.getCurrentTextureId();
        if (this.isEmpty(glSurfaceTexture)) {
            return;
        }
        this.onCreateSurface(glSurfaceTexture);
    }

    @TargetApi(value=16)
    private void onCreateSurface(int glSurfaceTextureId) {
        if (this.mSurfaceTexture == null) {
            this.mSurfaceTexture = new SurfaceTexture(glSurfaceTextureId);
            this.mSurfaceTexture.detachFromGLContext();
            this.mSurfaceTexture.setDefaultBufferSize(this.getWidth(), this.getHeight());
            this.mSurface = new Surface(this.mSurfaceTexture);
            if (this.mOnSurfaceReadyListener != null) {
                this.mOnSurfaceReadyListener.onSurfaceReady(this.mSurface);
            }
        }
    }

    @Override
    protected void onResize(int width, int height) {
        if (this.mSurfaceTexture != null && Build.VERSION.SDK_INT >= 15) {
            this.mSurfaceTexture.setDefaultBufferSize(width, height);
        }
    }

    @Override
    @TargetApi(value=16)
    public synchronized void syncDrawInContext(MD360Texture.ISyncDrawCallback callback) {
        int glSurfaceTexture = this.getCurrentTextureId();
        if (this.isEmpty(glSurfaceTexture)) {
            return;
        }
        if (this.mSurfaceTexture == null) {
            Logging.out(LOG_TAG, "mSurfaceTexture == null");
            this.create();
            return;
        }
        this.mSurfaceTexture.attachToGLContext(glSurfaceTexture);
        this.mSurfaceTexture.updateTexImage();
        callback.onDrawOpenGL();
        this.mSurfaceTexture.detachFromGLContext();
    }

    @Override
    protected int createTextureId() {
        int[] textures = new int[1];
        GLES20.glActiveTexture((int)33984);
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLUtil.glCheck("Texture generate");
        GLES20.glBindTexture((int)36197, (int)textures[0]);
        GLUtil.glCheck("Texture bind");
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        return textures[0];
    }
}

