/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.video360;

import android.util.SparseBooleanArray;

class MDStatusManager {
    public static final int STATUS_INIT = 0;
    public static final int STATUS_READY = 1;
    private int mStatus = 0;
    private SparseBooleanArray mReadyList = new SparseBooleanArray();
    private int mVisibleSize;

    MDStatusManager() {
    }

    public void reset(int visibleSize) {
        this.mVisibleSize = visibleSize;
        this.mStatus = 0;
        for (int i2 = 0; i2 < this.mReadyList.size(); ++i2) {
            this.mReadyList.put(i2, false);
        }
    }

    public boolean isReady() {
        if (this.mVisibleSize == 1) {
            return true;
        }
        return this.mStatus == 1;
    }

    public synchronized void setChildReady(int index) {
        if (this.mReadyList.get(index)) {
            return;
        }
        this.mReadyList.put(index, true);
        boolean ready = true;
        for (int i2 = 0; i2 < this.mReadyList.size(); ++i2) {
            ready &= this.mReadyList.valueAt(i2);
        }
        this.mStatus = ready ? 1 : 0;
    }

    public Status newChild() {
        int index = this.mReadyList.size();
        this.mReadyList.put(index, false);
        return new StatusImpl(index, this);
    }

    static abstract class Status {
        protected int mId;

        public abstract boolean isAllReady();

        public abstract void ready();

        public Status(int id) {
            this.mId = id;
        }
    }

    private static class StatusImpl
    extends Status {
        private MDStatusManager manager;

        private StatusImpl(int id, MDStatusManager manager) {
            super(id);
            this.manager = manager;
        }

        @Override
        public boolean isAllReady() {
            return this.manager.isReady();
        }

        @Override
        public void ready() {
            this.manager.setChildReady(this.mId);
        }
    }
}

