/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.video360;

import android.content.res.Resources;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.view.MotionEvent;
import com.loopme.View360Controller;
import com.loopme.video360.MD360Program;
import java.util.ArrayList;
import java.util.List;

public class MD360Director {
    private static final String LOG_TAG = MD360Director.class.getSimpleName();
    private static final float sDensity = Resources.getSystem().getDisplayMetrics().density;
    private static final float sDamping = 0.2f;
    private float[] mModelMatrix = new float[16];
    private float[] mViewMatrix = new float[16];
    private float[] mProjectionMatrix = new float[16];
    private float[] mMVMatrix = new float[16];
    private float[] mMVPMatrix = new float[16];
    private float mEyeZ = 0.0f;
    private float mEyeX = 0.0f;
    private float mAngle = 0.0f;
    private float mRatio = 0.0f;
    private float mNear = 0.0f;
    private float mLookX = 0.0f;
    private float[] mCurrentRotation = new float[16];
    private float[] mAccumulatedRotation = new float[16];
    private float[] mTemporaryMatrix = new float[16];
    private float mPreviousX;
    private float mPreviousY;
    private float mDeltaX;
    private float mDeltaY;
    private float mDeltaSensorX;
    private float mDeltaSensorY;
    private float mDeltaSensorZ;
    private boolean mWasSwipe;
    private boolean mHandledMotion;
    private int mCurrentViewQuarter = 0;
    private boolean mGyroSupported;
    private boolean mAccelSupported;
    private View360Controller.Callback mCallback;
    private List<String> mHandledEvents = new ArrayList<String>();

    private MD360Director(Builder builder) {
        this.mEyeZ = builder.mEyeZ;
        this.mRatio = builder.mRatio;
        this.mNear = builder.mNear;
        this.mAngle = builder.mAngle;
        this.mEyeX = builder.mEyeX;
        this.mLookX = builder.mLookX;
        this.initCamera();
        this.initModel();
    }

    void setEventCallback(View360Controller.Callback callback) {
        this.mCallback = callback;
    }

    public boolean handleTouchEvent(MotionEvent event) {
        if (event != null) {
            float x2 = event.getX();
            float y = event.getY();
            if (event.getAction() == 2) {
                float deltaX = (x2 - this.mPreviousX) / sDensity * 0.2f;
                float deltaY = (y - this.mPreviousY) / sDensity * 0.2f;
                this.mDeltaX += deltaX;
                this.mDeltaY += deltaY;
                this.mWasSwipe = true;
            } else if (event.getAction() == 1) {
                if (this.mWasSwipe) {
                    this.mWasSwipe = false;
                    this.handleEvent("SWIPE");
                }
                this.mHandledMotion = false;
            }
            this.mPreviousX = x2;
            this.mPreviousY = y;
            return true;
        }
        return false;
    }

    private void updateCurentViewQuarter(int vq) {
        if (this.mCurrentViewQuarter != vq) {
            this.mCurrentViewQuarter = vq;
            String event = null;
            switch (vq) {
                case 1: {
                    event = "FRONT";
                    break;
                }
                case 2: {
                    event = "LEFT";
                    break;
                }
                case 3: {
                    event = "RIGHT";
                    break;
                }
                case 4: {
                    event = "BACK";
                }
            }
            this.handleEvent(event);
        }
    }

    private void detectViewQuarter(float y) {
        if (y > 45.0f && y < 135.0f) {
            this.updateCurentViewQuarter(3);
        } else if (Math.abs(y) > 135.0f) {
            this.updateCurentViewQuarter(4);
        } else if (Math.abs(y) < 45.0f) {
            this.updateCurentViewQuarter(1);
        } else {
            this.updateCurentViewQuarter(2);
        }
    }

    private void initCamera() {
        this.updateViewMatrix();
    }

    private void initModel() {
        Matrix.setIdentityM((float[])this.mAccumulatedRotation, (int)0);
        this.updateModelRotate(this.mAngle);
    }

    public void shot(MD360Program program) {
        Matrix.setIdentityM((float[])this.mModelMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mCurrentRotation, (int)0);
        Matrix.rotateM((float[])this.mCurrentRotation, (int)0, (float)(-this.mDeltaY + this.mDeltaSensorZ), (float)1.0f, (float)0.0f, (float)0.0f);
        Matrix.rotateM((float[])this.mCurrentRotation, (int)0, (float)(-this.mDeltaX + this.mDeltaSensorY), (float)0.0f, (float)1.0f, (float)0.0f);
        System.arraycopy(this.mCurrentRotation, 0, this.mAccumulatedRotation, 0, 16);
        Matrix.multiplyMM((float[])this.mTemporaryMatrix, (int)0, (float[])this.mModelMatrix, (int)0, (float[])this.mAccumulatedRotation, (int)0);
        System.arraycopy(this.mTemporaryMatrix, 0, this.mModelMatrix, 0, 16);
        Matrix.multiplyMM((float[])this.mMVMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mModelMatrix, (int)0);
        Matrix.multiplyMM((float[])this.mMVPMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mMVMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)program.getMVMatrixHandle(), (int)1, (boolean)false, (float[])this.mMVMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)program.getMVPMatrixHandle(), (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
    }

    public void updateProjection(int width, int height) {
        this.mRatio = (float)width * 1.0f / (float)height;
        this.updateProjectionNear(this.mNear);
    }

    private void updateViewMatrix() {
        float eyeX = this.mEyeX;
        float eyeY = 0.0f;
        float eyeZ = this.mEyeZ;
        float lookX = this.mLookX;
        float lookY = 0.0f;
        float lookZ = -1.0f;
        float upX = 0.0f;
        float upY = 1.0f;
        float upZ = 0.0f;
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        Matrix.setLookAtM((float[])this.mViewMatrix, (int)0, (float)eyeX, (float)0.0f, (float)eyeZ, (float)lookX, (float)0.0f, (float)-1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected void updateModelRotate(float a2) {
        this.mAngle = a2;
    }

    private void updateProjectionNear(float near) {
        this.mNear = near;
        float left = -this.mRatio / 2.0f;
        float right = this.mRatio / 2.0f;
        float bottom = -0.5f;
        float top = 0.5f;
        float far = 500.0f;
        Matrix.frustumM((float[])this.mProjectionMatrix, (int)0, (float)left, (float)right, (float)-0.5f, (float)0.5f, (float)this.mNear, (float)500.0f);
    }

    private void handleEvent(String event) {
        if (this.mCallback != null && !this.mHandledEvents.contains(event)) {
            this.mCallback.onEvent(event);
            this.mHandledEvents.add(event);
        }
    }

    public void updateSensorInfo(float[] vector) {
        this.mDeltaSensorX = (float)Math.toDegrees(vector[2]);
        this.mDeltaSensorY = (float)Math.toDegrees(vector[0]);
        this.mDeltaSensorZ = (float)Math.toDegrees(vector[1]);
        if (!this.mHandledMotion) {
            if (this.mAccelSupported) {
                this.handleEvent("ACCEL");
            }
            if (this.mGyroSupported) {
                this.handleEvent("GYRO");
            }
            this.mHandledMotion = true;
        }
        this.detectViewQuarter(this.mDeltaSensorY);
    }

    public void setGyroSupported(boolean b2) {
        this.mGyroSupported = b2;
    }

    public void setAccelSupported(boolean b2) {
        this.mAccelSupported = b2;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private float mEyeZ = 0.0f;
        private float mAngle = 0.0f;
        private float mRatio = 1.5f;
        private float mNear = 0.4f;
        private float mEyeX = 0.0f;
        private float mLookX = 0.0f;

        public MD360Director build() {
            return new MD360Director(this);
        }
    }
}

