/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.mraid;

import android.app.Activity;
import android.content.Context;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import com.loopme.ui.view.CloseButton;

public class MraidVideoActivity
extends Activity {
    private static final String LOG_TAG = MraidVideoActivity.class.getSimpleName();
    private static final String EXTRAS_VIDEO_URL = "videoUrl";
    private RelativeLayout mRelativeLayout;
    private VideoView mVideoView;
    private CloseButton mCloseButton;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mRelativeLayout = new RelativeLayout((Context)this);
        this.mVideoView = new VideoView((Context)this);
        this.mVideoView.setVideoPath(this.getIntent().getStringExtra(EXTRAS_VIDEO_URL));
        this.mVideoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                mp.start();
            }
        });
        this.mVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                MraidVideoActivity.this.mCloseButton.setVisibility(0);
            }
        });
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        this.mRelativeLayout.addView((View)this.mVideoView, (ViewGroup.LayoutParams)lp);
        this.setContentView((View)this.mRelativeLayout);
        this.initCloseButton();
    }

    private void initCloseButton() {
        this.mCloseButton = new CloseButton((Context)this);
        this.mCloseButton.addInLayout(this.mRelativeLayout);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v2) {
                MraidVideoActivity.this.finish();
            }
        });
    }

    protected void onResume() {
        super.onResume();
        if (!this.mVideoView.isPlaying()) {
            this.mVideoView.resume();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mVideoView.isPlaying()) {
            this.mVideoView.pause();
        }
    }
}

