/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.loopme.LoopMeBanner;
import com.loopme.NativeVideoBinder;
import com.loopme.NativeVideoController;
import com.loopme.common.AdChecker;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.MinimizedMode;
import com.loopme.common.Utils;

public class NativeVideoRecyclerAdapter
extends RecyclerView.Adapter
implements AdChecker,
NativeVideoController.DataChangeListener {
    private static final String LOG_TAG = NativeVideoRecyclerAdapter.class.getSimpleName();
    static final int TYPE_AD = 1000;
    private RecyclerView.Adapter mOriginAdapter;
    private NativeVideoController mNativeVideoController;
    private Activity mActivity;
    private LayoutInflater mInflater;
    private RecyclerView mRecyclerView;

    public NativeVideoRecyclerAdapter(RecyclerView.Adapter originAdapter, Activity activity, RecyclerView recyclerView) {
        if (originAdapter == null || activity == null || recyclerView == null) {
            throw new IllegalArgumentException("Some of parameters is null");
        }
        this.mActivity = activity;
        this.mOriginAdapter = originAdapter;
        this.mRecyclerView = recyclerView;
        this.mInflater = (LayoutInflater)this.mActivity.getSystemService("layout_inflater");
        this.mNativeVideoController = new NativeVideoController(this.mActivity);
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                NativeVideoRecyclerAdapter.this.mNativeVideoController.onScroll(recyclerView, (AdChecker)NativeVideoRecyclerAdapter.this);
            }
        });
        this.mRecyclerView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v2, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                Logging.out(LOG_TAG, "onLayoutChange!!!!!");
                NativeVideoRecyclerAdapter.this.mNativeVideoController.onScroll(NativeVideoRecyclerAdapter.this.mRecyclerView, (AdChecker)NativeVideoRecyclerAdapter.this);
            }
        });
        this.mOriginAdapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                NativeVideoRecyclerAdapter.this.triggerUpdateProcessor();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                NativeVideoRecyclerAdapter.this.triggerUpdateProcessor();
            }

            public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
                NativeVideoRecyclerAdapter.this.triggerUpdateProcessor();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                NativeVideoRecyclerAdapter.this.triggerUpdateProcessor();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                NativeVideoRecyclerAdapter.this.triggerUpdateProcessor();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                NativeVideoRecyclerAdapter.this.triggerUpdateProcessor();
            }
        });
    }

    private void triggerUpdateProcessor() {
        this.notifyDataSetChanged();
        this.mNativeVideoController.refreshAdPlacement(this.mOriginAdapter.getItemCount());
    }

    public void destroy() {
        this.mNativeVideoController.destroy();
    }

    public void onPause() {
        Logging.out(LOG_TAG, "onPause");
        this.mNativeVideoController.onPause();
    }

    public void onResume() {
        Logging.out(LOG_TAG, "onResume");
        this.mNativeVideoController.onResume(this.mRecyclerView, (AdChecker)this);
    }

    public void setMinimizedMode(MinimizedMode mode) {
        if (mode != null) {
            Logging.out(LOG_TAG, "Set minimized mode");
            this.mNativeVideoController.setMinimizedMode(mode);
        }
    }

    public void putAdWithAppKeyToPosition(String appKey, int position) {
        if (position < this.mOriginAdapter.getItemCount()) {
            this.mNativeVideoController.putAdWithAppKeyToPosition(appKey, position);
        } else {
            this.mNativeVideoController.putAdWithAppKeyToPosition(appKey, this.mOriginAdapter.getItemCount());
        }
    }

    public void loadAds() {
        if (Build.VERSION.SDK_INT < 14) {
            LoopMeError error = new LoopMeError("Not supported Android version. Expected Android 4.0+");
            this.mNativeVideoController.onLoadFail(error);
            return;
        }
        if (Utils.isOnline((Context)this.mActivity)) {
            this.mNativeVideoController.loadAds(this.mOriginAdapter.getItemCount(), this);
        } else {
            LoopMeError error = new LoopMeError("No connection");
            this.mNativeVideoController.onLoadFail(error);
        }
    }

    public void setViewBinder(NativeVideoBinder binder) {
        if (this.mNativeVideoController != null) {
            this.mNativeVideoController.setViewBinder(binder);
        }
    }

    public void setListener(LoopMeBanner.Listener listener) {
        this.mNativeVideoController.setListener(listener);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        if (viewType == 1000) {
            RelativeLayout v2 = new RelativeLayout(viewGroup.getContext());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
            v2.setLayoutParams((ViewGroup.LayoutParams)params);
            return new NativeVideoVH((View)v2);
        }
        return this.mOriginAdapter.onCreateViewHolder(viewGroup, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        if (this.isAd(position)) {
            Logging.out(LOG_TAG, "onBindViewHolder");
            LoopMeBanner banner = this.mNativeVideoController.getNativeVideoAd(position);
            View row = this.mNativeVideoController.getAdView(this.mInflater, null, banner, position);
            ((NativeVideoVH)viewHolder).adView.removeAllViews();
            if (row.getParent() != null) {
                ((ViewGroup)row.getParent()).removeView(row);
            }
            ((NativeVideoVH)viewHolder).adView.addView(row);
            RelativeLayout.LayoutParams p2 = (RelativeLayout.LayoutParams)row.getLayoutParams();
            p2.width = -1;
            row.setLayoutParams((ViewGroup.LayoutParams)p2);
        } else {
            int initPosition = this.mNativeVideoController.getInitialPosition(position);
            this.mOriginAdapter.onBindViewHolder(viewHolder, initPosition);
        }
    }

    @Override
    public boolean isAd(int i2) {
        return this.mNativeVideoController.getNativeVideoAd(i2) != null;
    }

    public int getItemViewType(int position) {
        int initPosition = this.mNativeVideoController.getInitialPosition(position);
        return this.isAd(position) ? 1000 : this.mOriginAdapter.getItemViewType(initPosition);
    }

    public void setHasStableIds(boolean hasStableIds) {
        this.mOriginAdapter.setHasStableIds(hasStableIds);
    }

    public long getItemId(int position) {
        if (this.isAd(position)) {
            return -System.identityHashCode(this.mNativeVideoController.getNativeVideoAd(position));
        }
        int initPosition = this.mNativeVideoController.getInitialPosition(position);
        return this.mOriginAdapter.getItemId(initPosition);
    }

    public int getItemCount() {
        return this.mOriginAdapter.getItemCount() + this.mNativeVideoController.getAdsCount();
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        this.mOriginAdapter.onViewRecycled(holder);
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        return this.mOriginAdapter.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        this.mOriginAdapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        this.mOriginAdapter.onViewDetachedFromWindow(holder);
    }

    public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
        this.mOriginAdapter.registerAdapterDataObserver(observer);
    }

    public void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
        this.mOriginAdapter.unregisterAdapterDataObserver(observer);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.mOriginAdapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        this.mOriginAdapter.onDetachedFromRecyclerView(recyclerView);
    }

    @Override
    public void onDataSetChanged() {
        this.mOriginAdapter.notifyDataSetChanged();
    }

    public class NativeVideoVH
    extends RecyclerView.ViewHolder {
        private RelativeLayout adView;

        public NativeVideoVH(View view) {
            super(view);
            this.adView = (RelativeLayout)view;
        }
    }
}

