/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.loopme.AdController;
import com.loopme.AdUtils;
import com.loopme.BaseAd;
import com.loopme.LoopMeAdHolder;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.Utils;
import com.loopme.debugging.ErrorLog;
import com.loopme.debugging.LiveDebug;

public final class LoopMeInterstitialGeneral
extends BaseAd {
    private static final String LOG_TAG = LoopMeInterstitialGeneral.class.getSimpleName();
    public static final String TEST_PORT_INTERSTITIAL = "test_interstitial_p";
    public static final String TEST_LAND_INTERSTITIAL = "test_interstitial_l";
    private Listener mAdListener;

    LoopMeInterstitialGeneral(Activity activity, String appKey) {
        super(activity, appKey);
        Logging.out(LOG_TAG, "Start creating interstitial with app key: " + appKey);
        this.mAdController = new AdController(this);
        Utils.init((Context)activity);
        LiveDebug.init((Context)activity);
    }

    public static LoopMeInterstitialGeneral getInstance(String appKey, Activity activity) {
        return LoopMeAdHolder.createInterstitial(appKey, activity);
    }

    @Override
    public void destroy() {
        this.broadcastDestroyIntent();
        super.destroy();
    }

    @Override
    public void dismiss() {
        if (this.mAdState == 202) {
            Logging.out(LOG_TAG, "Dismiss ad");
            this.broadcastDestroyIntent();
            this.stopExpirationTimer();
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
            }
        } else {
            Logging.out(LOG_TAG, "Can't dismiss ad, it's not displaying");
        }
    }

    private void broadcastDestroyIntent() {
        Intent intent = new Intent();
        intent.putExtra("adid", this.getAdId());
        intent.setAction("com.loopme.DESTROY_INTENT");
        this.getContext().sendBroadcast(intent);
    }

    public void setListener(Listener listener) {
        this.mAdListener = listener;
    }

    public Listener getListener() {
        return this.mAdListener;
    }

    public void removeListener() {
        this.mAdListener = null;
    }

    public void show() {
        Logging.out(LOG_TAG, "Interstitial will present fullscreen ad. App key: " + this.getAppKey());
        if (this.isReady()) {
            if (this.mAdState != 202) {
                this.mAdState = 202;
                this.stopExpirationTimer();
                if (!this.getAdParams().isMraid()) {
                    AdUtils.startAdActivity(this);
                } else {
                    AdUtils.startMraidActivity(this, this.getAdParams().isOwnCloseButton());
                }
            } else {
                Logging.out(LOG_TAG, "Interstitial is already presented on the screen");
            }
        } else {
            ++this.mShowWhenAdNotReadyCounter;
            Logging.out(LOG_TAG, "Interstitial is not ready (" + this.mShowWhenAdNotReadyCounter + " time(s))");
            ErrorLog.post("Interstitial is not ready");
        }
    }

    @Override
    public int getAdFormat() {
        return 1001;
    }

    @Override
    public AdController getAdController() {
        return this.mAdController;
    }

    public void onLoopMeInterstitialLoadSuccess(LoopMeInterstitialGeneral interstitial) {
        long currentTime = System.currentTimeMillis();
        long loadingTime = currentTime - this.mAdLoadingTimer;
        Logging.out(LOG_TAG, "Ad successfully loaded (" + loadingTime + "ms)");
        this.mIsReady = true;
        this.mAdState = 200;
        this.stopFetcherTimer();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialLoadSuccess(this);
            Logging.logEvent(this.getAppKey(), "Ad loaded successfully.");
        } else {
            Logging.out(LOG_TAG, "Warning: empty listener");
        }
    }

    void onLoopMeInterstitialLoadFail(LoopMeInterstitialGeneral interstitial, LoopMeError error) {
        Logging.out(LOG_TAG, "Ad fails to load: " + error.getMessage());
        this.mIsReady = false;
        this.mAdState = 200;
        this.stopFetcherTimer();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialLoadFail(this, error);
            Logging.logEvent(this.getAppKey(), "Ad failed to load. " + error.getMessage());
        } else {
            Logging.out(LOG_TAG, "Warning: empty listener");
        }
    }

    void onLoopMeInterstitialShow(LoopMeInterstitialGeneral interstitial) {
        if (this.mAdListener != null) {
            Logging.out(LOG_TAG, "Ad appeared on screen");
            this.mAdListener.onLoopMeInterstitialShow(this);
            Logging.logEvent("Ad appeared on the screen.");
        }
    }

    void onLoopMeInterstitialHide(LoopMeInterstitialGeneral interstitial) {
        Logging.out(LOG_TAG, "Ad disappeared from screen");
        this.mIsReady = false;
        this.mAdState = 200;
        this.releaseViewController();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialHide(this);
            Logging.logEvent("Ad closed.");
        }
    }

    void onLoopMeInterstitialClicked(LoopMeInterstitialGeneral interstitial) {
        Logging.out(LOG_TAG, "Ad received tap event");
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialClicked(this);
            Logging.logEvent("User interacts with Ad.");
        }
    }

    void onLoopMeInterstitialLeaveApp(LoopMeInterstitialGeneral interstitial) {
        Logging.out(LOG_TAG, "Leaving application");
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialLeaveApp(this);
        }
    }

    void onLoopMeInterstitialExpired(LoopMeInterstitialGeneral interstitial) {
        Logging.out(LOG_TAG, "Ads content expired");
        this.mExpirationTimer = null;
        this.mIsReady = false;
        this.mAdState = 200;
        this.releaseViewController();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialExpired(this);
        }
    }

    void onLoopMeInterstitialVideoDidReachEnd(LoopMeInterstitialGeneral interstitial) {
        Logging.out(LOG_TAG, "Video reach end");
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialVideoDidReachEnd(this);
        }
    }

    @Override
    void onAdExpired() {
        this.onLoopMeInterstitialExpired(this);
    }

    @Override
    void onAdLoadSuccess() {
        this.onLoopMeInterstitialLoadSuccess(this);
    }

    @Override
    void onAdLoadFail(final LoopMeError error) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                LoopMeInterstitialGeneral.this.onLoopMeInterstitialLoadFail(LoopMeInterstitialGeneral.this, error);
            }
        });
    }

    @Override
    void onAdLeaveApp() {
        this.onLoopMeInterstitialLeaveApp(this);
    }

    @Override
    void onAdClicked() {
        this.onLoopMeInterstitialClicked(this);
    }

    @Override
    void onAdVideoDidReachEnd() {
        this.onLoopMeInterstitialVideoDidReachEnd(this);
    }

    @Override
    int detectWidth() {
        return Utils.getScreenWidth();
    }

    @Override
    int detectHeight() {
        return Utils.getScreenHeight();
    }

    public static interface Listener {
        public void onLoopMeInterstitialLoadSuccess(LoopMeInterstitialGeneral var1);

        public void onLoopMeInterstitialLoadFail(LoopMeInterstitialGeneral var1, LoopMeError var2);

        public void onLoopMeInterstitialShow(LoopMeInterstitialGeneral var1);

        public void onLoopMeInterstitialHide(LoopMeInterstitialGeneral var1);

        public void onLoopMeInterstitialClicked(LoopMeInterstitialGeneral var1);

        public void onLoopMeInterstitialLeaveApp(LoopMeInterstitialGeneral var1);

        public void onLoopMeInterstitialExpired(LoopMeInterstitialGeneral var1);

        public void onLoopMeInterstitialVideoDidReachEnd(LoopMeInterstitialGeneral var1);
    }
}

