/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public final class AdvertisingIdClient {
    public static AdInfo getAdvertisingIdInfo(Context context) throws Exception {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot be called from the main thread");
        }
        try {
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException e2) {
            e2.printStackTrace();
        }
        AdvertisingConnection connection = new AdvertisingConnection();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (context.bindService(intent, (ServiceConnection)connection, 1)) {
            try {
                AdInfo adInfo;
                AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                AdInfo adInfo2 = adInfo = new AdInfo(adInterface.getId(), adInterface.isLimitAdTrackingEnabled(true));
                return adInfo2;
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                context.unbindService((ServiceConnection)connection);
            }
        }
        throw new IOException("Google Play connection failed");
    }

    private static final class AdvertisingInterface
    implements IInterface {
        private IBinder mBinder;

        public AdvertisingInterface(IBinder binder) {
            this.mBinder = binder;
        }

        public IBinder asBinder() {
            return this.mBinder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getId() throws RemoteException {
            String id;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.mBinder.transact(1, data, reply, 0);
                reply.readException();
                id = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLimitAdTrackingEnabled(boolean paramBoolean) throws RemoteException {
            boolean limitAdTracking;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                this.mBinder.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return limitAdTracking;
        }
    }

    private static final class AdvertisingConnection
    implements ServiceConnection {
        boolean mRetrieved = false;
        private final LinkedBlockingQueue<IBinder> mQueue = new LinkedBlockingQueue(1);

        private AdvertisingConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.mQueue.put(service);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder getBinder() throws InterruptedException {
            if (this.mRetrieved) {
                throw new IllegalStateException();
            }
            this.mRetrieved = true;
            return this.mQueue.take();
        }
    }

    public static final class AdInfo {
        private final String mAdvertisingId;
        private final boolean mLimitAdTrackingEnabled;

        AdInfo(String advertisingId, boolean limitAdTrackingEnabled) {
            this.mAdvertisingId = advertisingId;
            this.mLimitAdTrackingEnabled = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.mAdvertisingId;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.mLimitAdTrackingEnabled;
        }
    }
}

