/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.video360;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.view.MotionEvent;
import android.view.Surface;
import android.widget.Toast;
import com.loopme.View360Controller;
import com.loopme.video360.MD360Director;
import com.loopme.video360.MD360DirectorFactory;
import com.loopme.video360.MD360Renderer;
import com.loopme.video360.MDStatusManager;
import com.loopme.video360.common.GLUtil;
import com.loopme.video360.common.VRUtil;
import com.loopme.video360.strategy.display.DisplayModeManager;
import com.loopme.video360.strategy.interactive.InteractiveModeManager;
import com.loopme.video360.texture.MD360Texture;
import com.loopme.video360.texture.MD360VideoTexture;
import java.util.LinkedList;
import java.util.List;

public class MDVRLibrary {
    private static final String LOG_TAG = MDVRLibrary.class.getSimpleName();
    private InteractiveModeManager mInteractiveModeManager;
    private DisplayModeManager mDisplayModeManager;
    private List<MD360Director> mDirectorList;
    private List<GLSurfaceView> mGLSurfaceViewList;
    private MD360Texture mSurface;
    private MDStatusManager mMDStatusManager;
    private int mContentType;
    private boolean mIsPaused = true;

    private MDVRLibrary(Builder builder) {
        this.mContentType = builder.contentType;
        this.mSurface = builder.texture;
        this.mDirectorList = new LinkedList<MD360Director>();
        this.mGLSurfaceViewList = new LinkedList<GLSurfaceView>();
        this.mMDStatusManager = new MDStatusManager();
        this.initWithGLSurfaceView(builder.context, builder.glSurfaceView);
        this.mDisplayModeManager = new DisplayModeManager(this.mGLSurfaceViewList);
        this.mInteractiveModeManager = new InteractiveModeManager(this.mDirectorList);
        this.mDisplayModeManager.prepare(builder.context);
        this.mInteractiveModeManager.prepare(builder.context);
        this.mMDStatusManager.reset(this.mDisplayModeManager.getVisibleSize());
    }

    private void initWithGLSurfaceView(Context context, GLSurfaceView glSurfaceView) {
        this.initOpenGL(context, glSurfaceView, this.mSurface);
    }

    public void setEventCallback(View360Controller.Callback callback) {
        for (MD360Director director : this.mDirectorList) {
            director.setEventCallback(callback);
        }
    }

    private void initOpenGL(Context context, GLSurfaceView glSurfaceView, MD360Texture texture) {
        if (GLUtil.supportsEs2(context)) {
            glSurfaceView.setEGLContextClientVersion(2);
            MD360Director director = MD360DirectorFactory.createDirector();
            MD360Renderer renderer = MD360Renderer.with(context).setTexture(texture).setDirector(director).setContentType(this.mContentType).build();
            renderer.setStatus(this.mMDStatusManager.newChild());
            glSurfaceView.setRenderer((GLSurfaceView.Renderer)renderer);
            this.mDirectorList.add(director);
            this.mGLSurfaceViewList.add(glSurfaceView);
        } else {
            glSurfaceView.setVisibility(8);
            Toast.makeText((Context)context, (CharSequence)"OpenGLES2 not supported.", (int)0).show();
        }
    }

    public void onResume(Context context) {
        this.mIsPaused = false;
        this.mInteractiveModeManager.onResume(context);
        for (GLSurfaceView glSurfaceView : this.mGLSurfaceViewList) {
            glSurfaceView.onResume();
        }
    }

    public void onPause(Context context) {
        this.mIsPaused = true;
        this.mInteractiveModeManager.onPause(context);
        for (GLSurfaceView glSurfaceView : this.mGLSurfaceViewList) {
            glSurfaceView.onPause();
        }
    }

    public void setGyroSupported(boolean b) {
        for (MD360Director director : this.mDirectorList) {
            director.setGyroSupported(b);
        }
    }

    public void setAccelSupported(boolean b) {
        for (MD360Director director : this.mDirectorList) {
            director.setAccelSupported(b);
        }
    }

    public boolean isPaused() {
        return this.mIsPaused;
    }

    public void onDestroy() {
        if (this.mSurface != null) {
            this.mSurface.release();
        }
    }

    public boolean handleTouchEvent(MotionEvent event) {
        return this.mInteractiveModeManager.handleTouchEvent(event);
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    static interface ContentType {
        public static final int VIDEO = 0;
    }

    public static class Builder {
        private GLSurfaceView glSurfaceView;
        private Context context;
        private int contentType = 0;
        private MD360Texture texture;

        private Builder(Context context) {
            this.context = context;
        }

        public Builder video(IOnSurfaceReadyCallback callback) {
            this.texture = new MD360VideoTexture(callback);
            this.contentType = 0;
            return this;
        }

        public MDVRLibrary build(GLSurfaceView glSurfaceView) {
            VRUtil.notNull(this.texture, "You must call video/bitmap function in before build");
            this.glSurfaceView = glSurfaceView;
            return new MDVRLibrary(this);
        }
    }

    public static interface IOnSurfaceReadyCallback {
        public void onSurfaceReady(Surface var1);
    }
}

