/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.tasks;

import android.content.Context;
import com.loopme.AdvertisingIdClient;
import com.loopme.common.Logging;

public class AdvIdFetcher
implements Runnable {
    private static final String LOG_TAG = AdvIdFetcher.class.getSimpleName();
    private final Context mContext;
    private final Listener mListener;
    private String mAdvertisingId;

    public AdvIdFetcher(Context context, Listener listener) {
        this.mContext = context;
        this.mListener = listener;
    }

    @Override
    public void run() {
        this.mAdvertisingId = "";
        boolean isLimited = false;
        try {
            AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(this.mContext);
            this.mAdvertisingId = adInfo.getId();
            isLimited = adInfo.isLimitAdTrackingEnabled();
        }
        catch (Exception e) {
            Logging.out(LOG_TAG, "Exception: " + e.getMessage());
        }
        if (this.mListener != null) {
            this.mListener.onComplete(this.mAdvertisingId, isLimited);
        }
    }

    public static interface Listener {
        public void onComplete(String var1, boolean var2);
    }
}

