/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.tasks;

import com.loopme.common.AdParams;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.ResponseParser;
import com.loopme.common.Utils;
import com.loopme.debugging.ErrorLog;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;

public class AdFetcher
implements Runnable {
    private static final String LOG_TAG = AdFetcher.class.getSimpleName();
    private final String mRequestUrl;
    private Listener mListener;
    private int mFormat;
    static int TIMEOUT = 20000;
    private static final String USER_AGENT = "User-Agent";
    private static final String AGENT_PROPERTY = "http.agent";
    private static final String INVALID_APPKEY_MESS = "Missing or invalid app key";
    private static final String PAGE_NOT_FOUND = "Page not found";
    private LoopMeError mLoopMeError;

    public AdFetcher(String requestUrl, Listener listener, int format) {
        this.mRequestUrl = requestUrl;
        this.mListener = listener;
        this.mFormat = format;
    }

    @Override
    public void run() {
        String result = this.getResponse(this.mRequestUrl);
        if (result == null) {
            this.complete(null, this.mLoopMeError);
        } else {
            ResponseParser parser = new ResponseParser(new ResponseParser.Listener(){

                @Override
                public void onParseError(LoopMeError error) {
                    AdFetcher.this.complete(null, error);
                }
            }, this.mFormat);
            AdParams adParams = parser.getAdParams(result);
            if (adParams != null) {
                this.complete(adParams, null);
            }
        }
    }

    private void complete(AdParams params, LoopMeError error) {
        if (this.mListener != null) {
            this.mListener.onComplete(params, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse(String url) {
        String result = null;
        HttpURLConnection urlConnection = null;
        try {
            URL request = new URL(url);
            urlConnection = (HttpURLConnection)request.openConnection();
            urlConnection.setRequestProperty(USER_AGENT, System.getProperty(AGENT_PROPERTY));
            urlConnection.setReadTimeout(TIMEOUT);
            urlConnection.setConnectTimeout(TIMEOUT);
            String type = this.mFormat == 1001 ? "interstitial" : "banner";
            Logging.out(LOG_TAG, type + " loads ad with URL: " + url);
            int status = urlConnection.getResponseCode();
            Logging.out(LOG_TAG, "status code: " + status);
            this.handleStatusCode(status);
            if (status == 404) {
                InputStream errorStream = urlConnection.getErrorStream();
                String errorString = Utils.getStringFromStream(errorStream);
                this.mLoopMeError = errorString.contains(INVALID_APPKEY_MESS) ? new LoopMeError(INVALID_APPKEY_MESS) : new LoopMeError(PAGE_NOT_FOUND);
                String string = null;
                return string;
            }
            if (status == 200) {
                BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
                result = Utils.getStringFromStream(in);
            }
        }
        catch (SocketTimeoutException e) {
            this.mLoopMeError = new LoopMeError("Request timeout");
            ErrorLog.post("timeout[ad_request]", "server");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mLoopMeError = new LoopMeError("Error during establish connection");
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return result;
    }

    private void handleStatusCode(int statusCode) {
        switch (statusCode) {
            case 200: {
                break;
            }
            case 204: {
                this.mLoopMeError = new LoopMeError("No ads found");
                break;
            }
            default: {
                this.mLoopMeError = new LoopMeError("Server status code: " + statusCode);
                ErrorLog.post("Server status code: " + statusCode, "server");
            }
        }
    }

    public static interface Listener {
        public void onComplete(AdParams var1, LoopMeError var2);
    }
}

