/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.location.Location;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.loopme.common.Logging;
import com.loopme.common.VideoUtils;
import com.loopme.constants.StretchOption;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class Utils {
    private static final String LOG_TAG = Utils.class.getSimpleName();
    private static WindowManager sWindowManager;
    private static Resources sResources;
    private static LocationManager sLocationManager;
    private static PackageManager sPackageManager;
    private static AudioManager sAudioManager;

    public static boolean isOnline(Context context) {
        try {
            ConnectivityManager conMgr = (ConnectivityManager)context.getSystemService("connectivity");
            if (conMgr == null) {
                return false;
            }
            NetworkInfo activeNetwork = conMgr.getActiveNetworkInfo();
            return activeNetwork != null && activeNetwork.isConnected() && activeNetwork.isAvailable();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean isOnline = false;
            return isOnline;
        }
    }

    public static int convertDpToPixel(float dp) {
        if (sResources != null) {
            return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)sResources.getDisplayMetrics());
        }
        return 0;
    }

    public static void init(Context context) {
        if (context != null) {
            sWindowManager = (WindowManager)context.getSystemService("window");
            sResources = context.getResources();
            sLocationManager = (LocationManager)context.getSystemService("location");
            sPackageManager = context.getPackageManager();
            sAudioManager = (AudioManager)context.getSystemService("audio");
        }
    }

    public static String getStringFromStream(InputStream inputStream) {
        int numberBytesRead = 0;
        StringBuilder out = new StringBuilder();
        byte[] bytes = new byte[4096];
        try {
            while ((numberBytesRead = inputStream.read(bytes)) != -1) {
                out.append(new String(bytes, 0, numberBytesRead));
            }
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    public static Location getLastKnownLocation() {
        if (sLocationManager == null) {
            return null;
        }
        Location gpsLocation = null;
        try {
            gpsLocation = sLocationManager.getLastKnownLocation("gps");
        }
        catch (SecurityException e) {
            Logging.out(LOG_TAG, "Failed to retrieve GPS location: access appears to be disabled.");
        }
        catch (IllegalArgumentException e) {
            Logging.out(LOG_TAG, "Failed to retrieve GPS location: device has no GPS provider.");
        }
        Location networkLocation = null;
        try {
            networkLocation = sLocationManager.getLastKnownLocation("network");
        }
        catch (SecurityException e) {
            Logging.out(LOG_TAG, "Failed to retrieve network location: access appears to be disabled.");
        }
        catch (IllegalArgumentException e) {
            Logging.out(LOG_TAG, "Failed to retrieve network location: device has no network provider.");
        }
        if (gpsLocation == null && networkLocation == null) {
            return null;
        }
        Location result = gpsLocation != null && networkLocation != null ? (gpsLocation.getTime() > networkLocation.getTime() ? gpsLocation : networkLocation) : (gpsLocation != null ? gpsLocation : networkLocation);
        return result;
    }

    public static DisplayMetrics getDisplayMetrics() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        if (sWindowManager == null) {
            return displayMetrics;
        }
        sWindowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static boolean isPackageInstalled(List<String> packadeId) {
        if (sPackageManager == null) {
            return false;
        }
        List packages = sPackageManager.getInstalledPackages(0);
        for (PackageInfo packageInfo : packages) {
            for (int i = 0; i < packadeId.size(); ++i) {
                if (!packadeId.get(i).equalsIgnoreCase(packageInfo.packageName)) continue;
                return true;
            }
        }
        return false;
    }

    public static void animateAppear(View view) {
        view.animate().setDuration(500L).alpha(1.0f);
    }

    public static float getSystemVolume() {
        if (sAudioManager != null) {
            int volume_level = sAudioManager.getStreamVolume(2);
            int max = sAudioManager.getStreamMaxVolume(2);
            int percent = Math.round(volume_level * 100 / max);
            return (float)percent / 100.0f;
        }
        return 1.0f;
    }

    public static int getScreenOrientation() {
        int orientation;
        if (sWindowManager == null) {
            return 0;
        }
        int rotation = sWindowManager.getDefaultDisplay().getRotation();
        DisplayMetrics dm = new DisplayMetrics();
        sWindowManager.getDefaultDisplay().getMetrics(dm);
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        if ((rotation == 0 || rotation == 2) && height > width || (rotation == 1 || rotation == 3) && width > height) {
            switch (rotation) {
                case 0: {
                    orientation = 1;
                    break;
                }
                case 1: {
                    orientation = 0;
                    break;
                }
                case 2: {
                    orientation = 9;
                    break;
                }
                case 3: {
                    orientation = 8;
                    break;
                }
                default: {
                    orientation = 1;
                    break;
                }
            }
        } else {
            switch (rotation) {
                case 0: {
                    orientation = 0;
                    break;
                }
                case 1: {
                    orientation = 1;
                    break;
                }
                case 2: {
                    orientation = 8;
                    break;
                }
                case 3: {
                    orientation = 9;
                    break;
                }
                default: {
                    orientation = 0;
                }
            }
        }
        return orientation;
    }

    public static int getScreenWidth() {
        if (sWindowManager == null) {
            return 0;
        }
        Display display = sWindowManager.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        return size.x;
    }

    public static int getScreenHeight() {
        if (sWindowManager == null) {
            return 0;
        }
        Display display = sWindowManager.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        return size.y;
    }

    public static BitmapDrawable decodeImage(String base64drawable) {
        byte[] rawImageData = Base64.decode((String)base64drawable, (int)0);
        return new BitmapDrawable(null, (InputStream)new ByteArrayInputStream(rawImageData));
    }

    public static FrameLayout.LayoutParams calculateNewLayoutParams(FrameLayout.LayoutParams lp, int mVideoWidth, int mVideoHeight, int mResizeWidth, int mResizeHeight, StretchOption mStretch) {
        lp.gravity = 17;
        float percent = 0.0f;
        if (mVideoWidth > mVideoHeight) {
            lp.width = mResizeWidth;
            lp.height = (int)((float)mVideoHeight / (float)mVideoWidth * (float)mResizeWidth);
            int blackLines = mResizeHeight - lp.height;
            if (lp.height != 0) {
                percent = blackLines * 100 / lp.height;
            }
        } else {
            lp.height = mResizeHeight;
            lp.width = (int)((float)mVideoWidth / (float)mVideoHeight * (float)mResizeHeight);
            int blackLines = mResizeWidth - lp.width;
            if (lp.width != 0) {
                percent = blackLines * 100 / lp.width;
            }
        }
        switch (mStretch) {
            case NONE: {
                if (!(percent < 11.0f)) break;
                lp.width = mResizeWidth;
                lp.height = mResizeHeight;
                break;
            }
            case STRECH: {
                lp.width = mResizeWidth;
                lp.height = mResizeHeight;
                break;
            }
        }
        return lp;
    }

    public static String getViewVisibility(View view) {
        String visibilityStr = null;
        switch (view.getVisibility()) {
            case 0: {
                visibilityStr = "VISIBLE";
                break;
            }
            case 4: {
                visibilityStr = "INVISIBLE";
                break;
            }
            case 8: {
                visibilityStr = "GONE";
            }
        }
        return visibilityStr;
    }

    public static void clearCache(Context context) {
        VideoUtils.clearCache(context);
    }

    public static boolean isEmulator() {
        return Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK") || Build.MANUFACTURER.contains("Genymotion");
    }
}

