/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.loopme.IViewController;
import com.loopme.adview.AdView;
import com.loopme.common.Logging;
import com.loopme.common.Utils;
import com.loopme.constants.StretchOption;

public class ViewController
implements TextureView.SurfaceTextureListener,
IViewController {
    private static final String LOG_TAG = ViewController.class.getSimpleName();
    private TextureView mTextureView;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mResizeWidth;
    private int mResizeHeight;
    private Callback mCallback;
    private StretchOption mStretch = StretchOption.NONE;

    public ViewController(Callback callback) {
        this.mCallback = callback;
    }

    @Override
    public void buildVideoAdView(Context context, ViewGroup bannerView, AdView adView) {
        this.mTextureView = new TextureView(context);
        if (Build.VERSION.SDK_INT < 23) {
            this.mTextureView.setBackgroundColor(0);
        }
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        adView.setBackgroundColor(0);
        adView.setLayerType(1, null);
        bannerView.setBackgroundColor(-16777216);
        bannerView.addView((View)this.mTextureView, 0);
        if (adView.getParent() != null) {
            ((ViewGroup)adView.getParent()).removeView((View)adView);
        }
        bannerView.addView((View)adView, 1);
    }

    @Override
    public void rebuildView(ViewGroup bannerView, AdView adView) {
        Logging.out(LOG_TAG, "rebuildView");
        if (bannerView == null || adView == null || this.mTextureView == null) {
            return;
        }
        bannerView.setBackgroundColor(-16777216);
        if (this.mTextureView.getParent() != null) {
            ((ViewGroup)this.mTextureView.getParent()).removeView((View)this.mTextureView);
        }
        if (adView.getParent() != null) {
            ((ViewGroup)adView.getParent()).removeView((View)adView);
        }
        bannerView.addView((View)this.mTextureView, 0);
        bannerView.addView((View)adView, 1);
    }

    private void resizeVideo() {
        Logging.out(LOG_TAG, "resizeVideo()");
        if (this.mTextureView == null || this.mResizeWidth == 0 || this.mResizeHeight == 0 || this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            return;
        }
        FrameLayout.LayoutParams oldParams = (FrameLayout.LayoutParams)this.mTextureView.getLayoutParams();
        FrameLayout.LayoutParams params = Utils.calculateNewLayoutParams(oldParams, this.mVideoWidth, this.mVideoHeight, this.mResizeWidth, this.mResizeHeight, this.mStretch);
        this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void setViewSize(int width, int height) {
        Logging.out(LOG_TAG, "setViewSize " + width + " : " + height);
        this.mResizeWidth = width;
        this.mResizeHeight = height;
    }

    @Override
    public void setVideoSize(int width, int height) {
        Logging.out(LOG_TAG, "setVideoSize " + width + " : " + height);
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    @Override
    public void setStretchParam(StretchOption stretchParam) {
        Logging.out(LOG_TAG, "setStretchParam");
        this.mStretch = stretchParam;
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public boolean handleTouchEvent(MotionEvent event) {
        return false;
    }

    @Override
    public void initVRLibrary(Context context) {
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (this.mCallback != null) {
            this.mCallback.onSurfaceTextureAvailable(surface);
        }
        this.resizeVideo();
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (this.mCallback != null) {
            this.mCallback.onSurfaceTextureDestroyed();
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public static interface Callback {
        public void onSurfaceTextureAvailable(SurfaceTexture var1);

        public void onSurfaceTextureDestroyed();
    }
}

