/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.loopme.AdController;
import com.loopme.AdUtils;
import com.loopme.BaseAd;
import com.loopme.LoopMeAdHolder;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.Utils;
import com.loopme.debugging.ErrorLog;
import com.loopme.debugging.LiveDebug;

public final class LoopMeInterstitial
extends BaseAd {
    private static final String LOG_TAG = LoopMeInterstitial.class.getSimpleName();
    public static final String TEST_PORT_INTERSTITIAL = "test_interstitial_p";
    public static final String TEST_LAND_INTERSTITIAL = "test_interstitial_l";
    private Listener mAdListener;

    public LoopMeInterstitial(Context context, String appKey) {
        super(context, appKey);
        Logging.out(LOG_TAG, "Start creating interstitial with app key: " + appKey);
        this.mAdController = new AdController(this);
        Utils.init(context);
        LiveDebug.init(context);
    }

    public static LoopMeInterstitial getInstance(String appKey, Context context) {
        if (Build.VERSION.SDK_INT >= 14) {
            return LoopMeAdHolder.getInterstitial(appKey, context);
        }
        Logging.out(LOG_TAG, "Not supported Android version. Expected Android 4.0+");
        return null;
    }

    @Override
    public void destroy() {
        this.broadcastDestroyIntent();
        super.destroy();
    }

    @Override
    public void dismiss() {
        if (this.mAdState == 202) {
            Logging.out(LOG_TAG, "Dismiss ad");
            this.broadcastDestroyIntent();
            this.stopExpirationTimer();
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
            }
        } else {
            Logging.out(LOG_TAG, "Can't dismiss ad, it's not displaying");
        }
    }

    private void broadcastDestroyIntent() {
        Intent intent = new Intent();
        intent.setAction("com.loopme.DESTROY_INTENT");
        this.getContext().sendBroadcast(intent);
    }

    public void setListener(Listener listener) {
        this.mAdListener = listener;
    }

    public Listener getListener() {
        return this.mAdListener;
    }

    public void removeListener() {
        this.mAdListener = null;
    }

    public void show() {
        Logging.out(LOG_TAG, "Interstitial will present fullscreen ad. App key: " + this.getAppKey());
        if (this.isReady()) {
            if (this.mAdState != 202) {
                this.mAdState = 202;
                this.stopExpirationTimer();
                AdUtils.startAdActivity(this);
            } else {
                Logging.out(LOG_TAG, "Interstitial is already presented on the screen");
            }
        } else {
            ++this.mShowWhenAdNotReadyCounter;
            Logging.out(LOG_TAG, "Interstitial is not ready (" + this.mShowWhenAdNotReadyCounter + " time(s))");
            ErrorLog.post("Interstitial is not ready");
        }
    }

    @Override
    public int getAdFormat() {
        return 1001;
    }

    @Override
    AdController getAdController() {
        return this.mAdController;
    }

    public void onLoopMeInterstitialLoadSuccess(LoopMeInterstitial interstitial) {
        long currentTime = System.currentTimeMillis();
        long loadingTime = currentTime - this.mAdLoadingTimer;
        Logging.out(LOG_TAG, "Ad successfully loaded (" + loadingTime + "ms)");
        this.mIsReady = true;
        this.mAdState = 200;
        this.stopFetcherTimer();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialLoadSuccess(this);
        } else {
            Logging.out(LOG_TAG, "Warning: empty listener");
        }
    }

    void onLoopMeInterstitialLoadFail(LoopMeInterstitial interstitial, LoopMeError error) {
        Logging.out(LOG_TAG, "Ad fails to load: " + error.getMessage());
        this.mIsReady = false;
        this.mAdState = 200;
        this.stopFetcherTimer();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialLoadFail(this, error);
        } else {
            Logging.out(LOG_TAG, "Warning: empty listener");
        }
    }

    void onLoopMeInterstitialShow(LoopMeInterstitial interstitial) {
        if (this.mAdListener != null) {
            Logging.out(LOG_TAG, "Ad appeared on screen");
            this.mAdListener.onLoopMeInterstitialShow(this);
        }
    }

    void onLoopMeInterstitialHide(LoopMeInterstitial interstitial) {
        Logging.out(LOG_TAG, "Ad disappeared from screen");
        this.mIsReady = false;
        this.mAdState = 200;
        this.releaseViewController();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialHide(this);
        }
    }

    void onLoopMeInterstitialClicked(LoopMeInterstitial interstitial) {
        Logging.out(LOG_TAG, "Ad received tap event");
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialClicked(this);
        }
    }

    void onLoopMeInterstitialLeaveApp(LoopMeInterstitial interstitial) {
        Logging.out(LOG_TAG, "Leaving application");
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialLeaveApp(this);
        }
    }

    void onLoopMeInterstitialExpired(LoopMeInterstitial interstitial) {
        Logging.out(LOG_TAG, "Ads content expired");
        this.mExpirationTimer = null;
        this.mIsReady = false;
        this.mAdState = 200;
        this.releaseViewController();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialExpired(this);
        }
    }

    void onLoopMeInterstitialVideoDidReachEnd(LoopMeInterstitial interstitial) {
        Logging.out(LOG_TAG, "Video reach end");
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeInterstitialVideoDidReachEnd(this);
        }
    }

    @Override
    void onAdExpired() {
        this.onLoopMeInterstitialExpired(this);
    }

    @Override
    void onAdLoadSuccess() {
        this.onLoopMeInterstitialLoadSuccess(this);
    }

    @Override
    void onAdLoadFail(final LoopMeError error) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                LoopMeInterstitial.this.onLoopMeInterstitialLoadFail(LoopMeInterstitial.this, error);
            }
        });
    }

    @Override
    void onAdLeaveApp() {
        this.onLoopMeInterstitialLeaveApp(this);
    }

    @Override
    void onAdClicked() {
        this.onLoopMeInterstitialClicked(this);
    }

    @Override
    void onAdVideoDidReachEnd() {
        this.onLoopMeInterstitialVideoDidReachEnd(this);
    }

    @Override
    int detectWidth() {
        return Utils.getScreenWidth();
    }

    @Override
    int detectHeight() {
        return Utils.getScreenHeight();
    }

    public void clearCache() {
        if (this.getContext() != null) {
            Utils.clearCache(this.getContext());
        }
    }

    public static interface Listener {
        public void onLoopMeInterstitialLoadSuccess(LoopMeInterstitial var1);

        public void onLoopMeInterstitialLoadFail(LoopMeInterstitial var1, LoopMeError var2);

        public void onLoopMeInterstitialShow(LoopMeInterstitial var1);

        public void onLoopMeInterstitialHide(LoopMeInterstitial var1);

        public void onLoopMeInterstitialClicked(LoopMeInterstitial var1);

        public void onLoopMeInterstitialLeaveApp(LoopMeInterstitial var1);

        public void onLoopMeInterstitialExpired(LoopMeInterstitial var1);

        public void onLoopMeInterstitialVideoDidReachEnd(LoopMeInterstitial var1);
    }
}

