/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.WebView;
import android.widget.Button;
import com.loopme.BaseAd;
import com.loopme.LoopMeAdHolder;
import com.loopme.adbrowser.AdBrowserLayout;
import com.loopme.adbrowser.AdBrowserWebViewClient;
import com.loopme.adbrowser.BrowserWebView;
import com.loopme.common.Base64Drawables;
import com.loopme.common.Logging;
import com.loopme.common.Utils;

public final class AdBrowserActivity
extends Activity {
    private static final String LOG_TAG = AdBrowserActivity.class.getSimpleName();
    private static final String KEY_URL = "url";
    private BrowserWebView mAdBrowserWebview;
    private AdBrowserLayout mLayout;
    private BaseAd mBaseAd;
    private boolean mIsBackFromMarket = false;
    private View mProgress;
    private Button mBackButton;
    private String mUrl;
    private AdBrowserWebViewClient.Listener mWebClientListener;
    private Base64Drawables mBase64Drawables = new Base64Drawables();

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (this.isValidExtras()) {
            this.requestWindowFeature(1);
            this.getWindow().setFlags(1024, 1024);
            this.mLayout = new AdBrowserLayout(this.getApplicationContext());
            this.setContentView((View)this.mLayout);
            this.mProgress = this.mLayout.getProgressBar();
            this.mBackButton = this.mLayout.getBackButton();
            this.mAdBrowserWebview = this.mLayout.getWebView();
            this.initWebView(this.mAdBrowserWebview);
            if (bundle != null) {
                this.mAdBrowserWebview.restoreState(bundle);
            } else {
                this.mAdBrowserWebview.loadUrl(this.mUrl);
            }
            this.initButtonListeners(this.mAdBrowserWebview);
        } else {
            this.finish();
        }
    }

    private boolean isValidExtras() {
        String appKey = this.getIntent().getStringExtra("appkey");
        int format = this.getIntent().getIntExtra("format", 0);
        Bundle extras = this.getIntent().getExtras();
        if (extras != null) {
            this.mUrl = extras.getString(KEY_URL);
        }
        if (format == 1000) {
            this.mBaseAd = LoopMeAdHolder.getBanner(appKey, null);
        } else if (format == 1001) {
            this.mBaseAd = LoopMeAdHolder.getInterstitial(appKey, null);
        }
        return this.mBaseAd != null && !TextUtils.isEmpty((CharSequence)this.mUrl);
    }

    protected final void onPause() {
        super.onPause();
        Logging.out(LOG_TAG, "onPause");
        if (this.mAdBrowserWebview != null) {
            this.mAdBrowserWebview.onPause();
        }
    }

    protected void onDestroy() {
        Logging.out(LOG_TAG, " onDestroy");
        if (this.mAdBrowserWebview != null) {
            this.mAdBrowserWebview.clearCache(true);
        }
        super.onDestroy();
    }

    protected void onResume() {
        super.onResume();
        Logging.out(LOG_TAG, "onResume");
        if (this.mIsBackFromMarket) {
            this.finish();
        }
        this.mIsBackFromMarket = true;
        this.mLayout.getProgressBar().setVisibility(4);
    }

    private void initWebView(BrowserWebView webView) {
        this.mWebClientListener = this.initAdBrowserClientListener();
        AdBrowserWebViewClient client = new AdBrowserWebViewClient(this.mWebClientListener);
        webView.setWebViewClient(client);
        webView.getSettings().setBuiltInZoomControls(false);
    }

    private AdBrowserWebViewClient.Listener initAdBrowserClientListener() {
        return new AdBrowserWebViewClient.Listener(){

            @Override
            public void onReceiveError() {
                AdBrowserActivity.this.finish();
            }

            @Override
            public void onPageStarted() {
                AdBrowserActivity.this.mProgress.setVisibility(0);
            }

            @Override
            @SuppressLint(value={"NewApi"})
            public void onPageFinished(boolean canGoBack) {
                AdBrowserActivity.this.mProgress.setVisibility(4);
                if (canGoBack) {
                    AdBrowserActivity.this.setImage(AdBrowserActivity.this.mBackButton, AdBrowserActivity.this.mBase64Drawables.getBackActive());
                } else {
                    AdBrowserActivity.this.setImage(AdBrowserActivity.this.mBackButton, AdBrowserActivity.this.mBase64Drawables.getBackInactive());
                }
            }

            @Override
            public void onLeaveApp() {
                AdBrowserActivity.this.mBaseAd.onAdLeaveApp();
            }
        };
    }

    @SuppressLint(value={"NewApi"})
    private void setImage(Button button, String imageString) {
        if (Build.VERSION.SDK_INT < 16) {
            button.setBackgroundDrawable((Drawable)Utils.decodeImage(imageString));
        } else {
            button.setBackground((Drawable)Utils.decodeImage(imageString));
        }
    }

    private void initButtonListeners(final WebView webView) {
        this.mLayout.getBackButton().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (webView.canGoBack()) {
                    AdBrowserActivity.this.mLayout.getProgressBar().setVisibility(0);
                    webView.goBack();
                }
            }
        });
        this.mLayout.getCloseButton().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AdBrowserActivity.this.finish();
            }
        });
        this.mLayout.getRefreshButton().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AdBrowserActivity.this.mLayout.getProgressBar().setVisibility(0);
                webView.reload();
            }
        });
        this.mLayout.getNativeButton().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String uriString = webView.getUrl();
                if (uriString != null) {
                    boolean isActivityResolved;
                    Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)uriString));
                    boolean bl = isActivityResolved = AdBrowserActivity.this.getPackageManager().resolveActivity(browserIntent, 65536) != null;
                    if (isActivityResolved) {
                        AdBrowserActivity.this.startActivity(browserIntent);
                        AdBrowserActivity.this.mBaseAd.onAdLeaveApp();
                    }
                }
            }
        });
    }

    public final boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.mAdBrowserWebview.canGoBack()) {
                this.mAdBrowserWebview.goBack();
                return true;
            }
            this.finish();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        this.mIsBackFromMarket = false;
        super.onRestoreInstanceState(savedInstanceState);
    }

    protected void onSaveInstanceState(Bundle outState) {
        this.mAdBrowserWebview.saveState(outState);
        super.onSaveInstanceState(outState);
    }
}

