/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.video360.strategy.interactive;

import android.content.Context;
import android.view.MotionEvent;
import com.loopme.video360.MD360Director;
import com.loopme.video360.strategy.ModeManager;
import com.loopme.video360.strategy.interactive.AbsInteractiveStrategy;
import com.loopme.video360.strategy.interactive.IInteractiveMode;
import com.loopme.video360.strategy.interactive.MotionStrategy;
import java.util.List;

public class InteractiveModeManager
extends ModeManager<AbsInteractiveStrategy>
implements IInteractiveMode {
    private List<MD360Director> mDirectorList;
    private boolean mIsResumed;

    public InteractiveModeManager(List<MD360Director> directorList) {
        this.mDirectorList = directorList;
    }

    @Override
    public void switchMode(Context context) {
        this.switchMode(context);
        if (this.mIsResumed) {
            this.onResume(context);
        }
    }

    @Override
    protected AbsInteractiveStrategy createStrategy() {
        return new MotionStrategy(this.mDirectorList);
    }

    @Override
    public void onResume(Context context) {
        this.mIsResumed = true;
        ((AbsInteractiveStrategy)this.getStrategy()).onResume(context);
    }

    @Override
    public void onPause(Context context) {
        this.mIsResumed = false;
        ((AbsInteractiveStrategy)this.getStrategy()).onPause(context);
    }

    @Override
    public boolean handleTouchEvent(MotionEvent event) {
        return ((AbsInteractiveStrategy)this.getStrategy()).handleTouchEvent(event);
    }
}

