/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.request;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.loopme.IntegrationType;
import com.loopme.common.Logging;
import com.loopme.common.StaticParams;
import com.loopme.request.AdRequestParametersProvider;
import com.loopme.request.AdTargetingData;
import com.loopme.request.CustomRequestParameter;
import java.util.Arrays;
import java.util.List;

public class AdRequestUrlBuilder {
    private static final String LOG_TAG = AdRequestUrlBuilder.class.getSimpleName();
    private static final String PARAM_APPKEY = "ak";
    private static final String PARAM_CONNECTION_TYPE = "ct";
    private static final String PARAM_LANGUAGE = "lng";
    private static final String PARAM_SDK_VERSION = "sv";
    private static final String PARAM_APP_VERSION = "av";
    private static final String PARAM_MRAID = "mr";
    private static final String PARAM_ORIENTATION = "or";
    private static final String PARAM_VIEWER_TOKEN = "vt";
    private static final String PARAM_DNT = "dnt";
    private static final String PARAM_LATITUDE = "lat";
    private static final String PARAM_LONGITUDE = "lon";
    private static final String PARAM_CARRIER = "carrier";
    private static final String PARAM_BUNDLE_ID = "bundleid";
    private static final String PARAM_WIFI_NAME = "wn";
    private static final String PARAM_CHARGE_LEVEL = "chl";
    private static final String PARAM_PLUGGED = "plg";
    private static final String PARAM_WEBVIEW_VERSION = "webview";
    private static final String PARAM_INTEGRATION_TYPE = "it";
    private static final String PARAM_KEYWORDS = "keywords";
    private static final String PARAM_YEAR_OF_BIRTH = "yob";
    private static final String PARAM_GENDER = "gender";
    private static final String PARAM_V360 = "v360";
    private final Context mContext;
    private IntegrationType mIntegrationType;

    public AdRequestUrlBuilder(Context context) {
        this.mContext = context;
        if (context == null) {
            Logging.out(LOG_TAG, "Context should not be null. Can't build request url");
        }
    }

    public String buildRequestUrl(String appKey, AdTargetingData metadata, IntegrationType integrationType) {
        this.mIntegrationType = integrationType != null ? integrationType : IntegrationType.NORMAL;
        return this.buildRequestUrl(appKey, metadata);
    }

    public String buildRequestUrl(String appKey, AdTargetingData metadata) {
        Object wifiName;
        String carrier;
        String longitude;
        Logging.out(LOG_TAG, "Start build request url");
        if (this.mContext == null) {
            return null;
        }
        AdRequestParametersProvider provider = AdRequestParametersProvider.getInstance();
        String str = StaticParams.BASE_URL;
        List<String> list = Arrays.asList(str.split("/"));
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https");
        for (String s : list) {
            if (list.indexOf(s) == 0) {
                builder.authority(s);
                continue;
            }
            builder.appendPath(s);
        }
        builder.appendQueryParameter(PARAM_APPKEY, appKey).appendQueryParameter(PARAM_CONNECTION_TYPE, String.valueOf(provider.getConnectionType(this.mContext))).appendQueryParameter(PARAM_LANGUAGE, provider.getLanguage()).appendQueryParameter(PARAM_SDK_VERSION, "5.1.3").appendQueryParameter(PARAM_V360, "1").appendQueryParameter(PARAM_APP_VERSION, provider.getAppVersion(this.mContext)).appendQueryParameter(PARAM_MRAID, provider.getMraidSupport()).appendQueryParameter(PARAM_ORIENTATION, provider.getOrientation(this.mContext)).appendQueryParameter(PARAM_VIEWER_TOKEN, provider.getViewerToken()).appendQueryParameter(PARAM_BUNDLE_ID, this.mContext.getPackageName()).appendQueryParameter(PARAM_WEBVIEW_VERSION, provider.getWebViewVersion(this.mContext)).appendQueryParameter(PARAM_INTEGRATION_TYPE, this.mIntegrationType.getType());
        String latitude = provider.getLatitude();
        if (latitude != null) {
            builder.appendQueryParameter(PARAM_LATITUDE, latitude);
        }
        if ((longitude = provider.getLongitude()) != null) {
            builder.appendQueryParameter(PARAM_LONGITUDE, longitude);
        }
        if ((carrier = provider.getCarrier(this.mContext)) != null) {
            builder.appendQueryParameter(PARAM_CARRIER, carrier);
        }
        String dntValue = provider.isDntPresent() ? "1" : "0";
        builder.appendQueryParameter(PARAM_DNT, dntValue);
        if (provider.isWifiInfoAvailable(this.mContext) && !TextUtils.isEmpty((CharSequence)(wifiName = provider.getWifiName(this.mContext)))) {
            builder.appendQueryParameter(PARAM_WIFI_NAME, (String)wifiName);
        }
        if (metadata != null && metadata.getKeywords() != null) {
            builder.appendQueryParameter(PARAM_KEYWORDS, metadata.getKeywords());
        }
        if (metadata != null && metadata.getGender() != null) {
            builder.appendQueryParameter(PARAM_GENDER, metadata.getGender());
        }
        if (metadata != null && metadata.getYob() != 0) {
            builder.appendQueryParameter(PARAM_YEAR_OF_BIRTH, String.valueOf(metadata.getYob()));
        }
        if (metadata != null && !metadata.getCustomParameters().isEmpty()) {
            for (CustomRequestParameter crp : metadata.getCustomParameters()) {
                builder.appendQueryParameter(crp.getParamName(), crp.getParamValue());
            }
        }
        String[] batteryInfo = provider.getBatteryInfo(this.mContext);
        builder.appendQueryParameter(PARAM_CHARGE_LEVEL, batteryInfo[0]);
        builder.appendQueryParameter(PARAM_PLUGGED, batteryInfo[1]);
        String url = builder.build().toString();
        Logging.out(LOG_TAG, "Finish build request url");
        return url;
    }
}

