/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.request;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.loopme.adview.AdView;
import com.loopme.common.Logging;
import com.loopme.common.Utils;
import java.util.Locale;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AdRequestParametersProvider {
    private static final String LOG_TAG = AdRequestParametersProvider.class.getSimpleName();
    private static AdRequestParametersProvider sProvider;
    private volatile String mAdvertisingId;
    private volatile boolean mDntPresent;
    private String mLoopMeId;
    private String mAppVersion;
    private String mMraid;
    private String mCarrier;
    private boolean mCarrierInited;
    private String mAppKey;
    private String mPackageId;

    private AdRequestParametersProvider() {
    }

    public static AdRequestParametersProvider getInstance() {
        if (sProvider == null) {
            sProvider = new AdRequestParametersProvider();
        }
        return sProvider;
    }

    public void detectPackage(Context context) {
        this.mPackageId = context.getPackageName();
    }

    public String getPackage() {
        return this.mPackageId;
    }

    public void setAppKey(String appKey) {
        this.mAppKey = appKey;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public void reset() {
        sProvider = null;
    }

    public void setGoogleAdvertisingId(String advId, boolean isLimited) {
        Logging.out(LOG_TAG, "Advertising Id = " + advId + " Limited: " + isLimited);
        this.mAdvertisingId = advId;
        this.mDntPresent = isLimited;
    }

    public String getGoogleAdvertisingId() {
        return this.mAdvertisingId;
    }

    public int getConnectionType(Context context) {
        if (context == null) {
            return 0;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return 0;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni == null) {
            return 0;
        }
        int type = ni.getType();
        if (type == 1) {
            return 2;
        }
        if (type == 9) {
            return 1;
        }
        if (type == 0) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager == null) {
                return 0;
            }
            int networkType = telephonyManager.getNetworkType();
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return 4;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return 5;
                }
                case 13: {
                    return 6;
                }
            }
            return 3;
        }
        return 0;
    }

    public String getLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getAppVersion(Context context) {
        if (this.mAppVersion == null) {
            this.initAppVersion(context);
        }
        return this.mAppVersion;
    }

    private void initAppVersion(Context context) {
        if (context == null) {
            this.mAppVersion = "0.0";
            return;
        }
        try {
            this.mAppVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Logging.out(LOG_TAG, "Can't get app version. Exception: " + e.getMessage());
            this.mAppVersion = "0.0";
        }
    }

    public String getMraidSupport() {
        if (this.mMraid == null) {
            this.initMraidSupport();
        }
        return this.mMraid;
    }

    private void initMraidSupport() {
        this.mMraid = "1";
        try {
            Class.forName("com.loopme.MraidView");
        }
        catch (ClassNotFoundException e) {
            this.mMraid = "0";
        }
    }

    public String getOrientation(Context context) {
        if (context == null || context.getResources() == null) {
            return "";
        }
        int orientation = context.getResources().getConfiguration().orientation;
        if (2 == orientation) {
            return "l";
        }
        return "p";
    }

    public String getViewerToken() {
        String advId = this.mAdvertisingId;
        if (TextUtils.isEmpty((CharSequence)advId)) {
            if (this.mLoopMeId == null) {
                String loopmeId = Long.toHexString(Double.doubleToLongBits(Math.random()));
                Logging.out(LOG_TAG, "LoopMe Id = " + loopmeId);
                this.mLoopMeId = loopmeId;
            }
            return this.mLoopMeId;
        }
        return advId;
    }

    public String getLatitude() {
        Location location = Utils.getLastKnownLocation();
        if (location != null) {
            return String.valueOf(location.getLatitude());
        }
        return null;
    }

    public String getLongitude() {
        Location location = Utils.getLastKnownLocation();
        if (location != null) {
            return String.valueOf(location.getLongitude());
        }
        return null;
    }

    public String getCarrier(Context context) {
        if (!this.mCarrierInited) {
            this.initCarrier(context);
        }
        return this.mCarrier;
    }

    private void initCarrier(Context context) {
        if (context == null) {
            this.mCarrierInited = true;
            return;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            this.mCarrierInited = true;
            return;
        }
        this.mCarrier = telephonyManager.getNetworkOperator();
        if (this.mCarrier.isEmpty()) {
            this.mCarrier = null;
        }
        this.mCarrierInited = true;
    }

    public boolean isDntPresent() {
        return this.mDntPresent;
    }

    public boolean isWifiInfoAvailable(Context context) {
        String permission2 = "android.permission.ACCESS_WIFI_STATE";
        int res = context.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }

    public String getWifiName(Context context) {
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (!wifiManager.isWifiEnabled()) {
                return null;
            }
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            String ssid = wifiInfo.getSSID();
            if (ssid.startsWith("\"") && ssid.endsWith("\"")) {
                ssid = ssid.substring(1, ssid.length() - 1);
            }
            if (TextUtils.isEmpty((CharSequence)ssid)) {
                return null;
            }
            if (ssid.contains("unknown ssid")) {
                return null;
            }
            if (ssid.equals("0x")) {
                return null;
            }
            return ssid;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDeviceId(Context context) {
        int permissionCheck;
        TelephonyManager telephonyManager;
        String imei = null;
        if (context != null && (telephonyManager = (TelephonyManager)context.getSystemService("phone")) != null && (permissionCheck = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE")) == 0) {
            imei = telephonyManager.getDeviceId();
        }
        return imei;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBatteryInfo(Context context) {
        final Object monitor = new Object();
        final String[] result = new String[2];
        BroadcastReceiver batteryReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                Object object = monitor;
                synchronized (object) {
                    int level = intent.getIntExtra("level", -1);
                    int scale = intent.getIntExtra("scale", -1);
                    float batteryPct = (float)level / (float)scale;
                    result[0] = String.valueOf(batteryPct);
                    int status = intent.getIntExtra("plugged", -1);
                    switch (status) {
                        case 0: {
                            result[1] = "NCHRG";
                            break;
                        }
                        case 1: {
                            result[1] = "AC";
                            break;
                        }
                        case 2: {
                            result[1] = "USB";
                            break;
                        }
                        case 4: {
                            result[1] = "WL";
                            break;
                        }
                        default: {
                            result[1] = "CHRG";
                        }
                    }
                    monitor.notifyAll();
                }
            }
        };
        IntentFilter batteryLevelFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        context.registerReceiver(batteryReceiver, batteryLevelFilter);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = monitor;
                synchronized (object) {
                    if (result[0] == null) {
                        result[0] = "-1.0";
                        result[1] = "UNKNOWN";
                    }
                    monitor.notifyAll();
                }
            }
        }, 2L, TimeUnit.SECONDS);
        Object object = monitor;
        synchronized (object) {
            try {
                if (result[0] == null) {
                    monitor.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                context.unregisterReceiver(batteryReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    public String getWebViewVersion(Context context) {
        String result = "unknown";
        if (context == null) {
            return result;
        }
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo("com.google.android.webview", 0);
            result = pi.versionName;
            Logging.out(LOG_TAG, "WebView version: " + result);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logging.out(LOG_TAG, "Android System WebView is not found. Trying to get it from user agent");
            String[] s = AdView.CHROME_USER_AGENT.split(" ");
            for (int i = 0; i < s.length; ++i) {
                if (!s[i].startsWith("Chrome")) continue;
                String[] s2 = s[i].split("/");
                result = s2[1];
            }
        }
        return result;
    }
}

