/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.adview;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Vibrator;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.loopme.adview.AdView;
import com.loopme.common.Logging;
import com.loopme.debugging.ErrorLog;
import java.net.URI;
import java.net.URISyntaxException;

public class Bridge
extends WebViewClient {
    private static final String LOG_TAG = Bridge.class.getSimpleName();
    private static final String LOOPME = "loopme";
    private static final String WEBVIEW = "webview";
    private static final String VIDEO = "video";
    private static final String WEBVIEW_CLOSE = "/close";
    private static final String WEBVIEW_FAIL = "/fail";
    private static final String WEBVIEW_SUCCESS = "/success";
    private static final String WEBVIEW_VIBRATE = "/vibrate";
    private static final String WEBVIEW_FULLSCREEN = "/fullscreenMode";
    private static final String VIDEO_LOAD = "/load";
    private static final String VIDEO_MUTE = "/mute";
    private static final String VIDEO_PLAY = "/play";
    private static final String VIDEO_PAUSE = "/pause";
    private static final String VIDEO_ENABLE_STRETCH = "/enableStretching";
    private static final String VIDEO_DISABLE_STRETCH = "/disableStretching";
    private static final String QUERY_PARAM_SRC = "src";
    private static final String QUERY_PARAM_CURRENT_TIME = "currentTime";
    private static final String QUERY_PARAM_MUTE = "mute";
    private static final String QUERY_PARAM_FULLSCREEN_MODE = "mode";
    private Listener mListener;

    public Bridge(Listener listener) {
        if (listener != null) {
            this.mListener = listener;
        } else {
            Logging.out(LOG_TAG, "VideoBridgeListener should not be null");
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Logging.out(LOG_TAG, "shouldOverrideUrlLoading " + url);
        if (TextUtils.isEmpty((CharSequence)url)) {
            ErrorLog.post("Broken redirect in bridge: " + url, "js");
            return false;
        }
        Context context = view.getContext();
        URI redirect = null;
        try {
            redirect = new URI(url);
        }
        catch (URISyntaxException e) {
            Logging.out(LOG_TAG, e.getMessage());
            e.printStackTrace();
            ErrorLog.post("Broken redirect in bridge: " + url, "js");
            return false;
        }
        String protocol = redirect.getScheme();
        if (TextUtils.isEmpty((CharSequence)protocol)) {
            return false;
        }
        if (protocol.equalsIgnoreCase(LOOPME)) {
            ((AdView)view).sendNativeCallFinished();
            String host = redirect.getHost();
            String path = redirect.getPath();
            if (TextUtils.isEmpty((CharSequence)host) || TextUtils.isEmpty((CharSequence)path)) {
                return false;
            }
            if (host.equalsIgnoreCase(WEBVIEW)) {
                this.handleWebviewCommands(path, url, context);
            } else if (host.equalsIgnoreCase(VIDEO)) {
                this.handleVideoCommands(path, url);
            }
        } else if (this.mListener != null) {
            this.mListener.onNonLoopMe(url);
        }
        return true;
    }

    private void handleWebviewCommands(String command, String url, Context context) {
        if (command == null || this.mListener == null) {
            return;
        }
        switch (command) {
            case "/close": {
                this.mListener.onJsClose();
                break;
            }
            case "/vibrate": {
                this.handleVibrate(context);
                break;
            }
            case "/fail": {
                this.mListener.onJsLoadFail("Ad received specific URL loopme://webview/fail");
                break;
            }
            case "/success": {
                this.mListener.onJsLoadSuccess();
                break;
            }
            case "/fullscreenMode": {
                this.handleFullscreenMode(url);
                break;
            }
        }
    }

    private void handleFullscreenMode(String url) {
        try {
            Uri uri = Uri.parse((String)url);
            String modeStr = this.detectQueryParameter(uri, QUERY_PARAM_FULLSCREEN_MODE);
            if (!this.isValidBooleanParameter(modeStr)) {
                ErrorLog.post("Empty parameter in js command: fullscreen mode", "js");
            } else {
                this.mListener.onJsFullscreenMode(Boolean.parseBoolean(modeStr));
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }

    private boolean isValidBooleanParameter(String modeStr) {
        if (TextUtils.isEmpty((CharSequence)modeStr)) {
            return false;
        }
        return modeStr.equalsIgnoreCase("true") || modeStr.equalsIgnoreCase("false");
    }

    private void handleVibrate(Context context) {
        try {
            Vibrator v = (Vibrator)context.getSystemService("vibrator");
            if (v != null) {
                v.vibrate(500L);
            }
        }
        catch (Exception e) {
            Logging.out(LOG_TAG, "Missing permission for vibrate");
        }
    }

    private void handleVideoCommands(String command, String url) {
        Uri uri;
        if (command == null || this.mListener == null) {
            return;
        }
        try {
            uri = Uri.parse((String)url);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return;
        }
        switch (command) {
            case "/load": {
                String videoUrl = this.detectQueryParameter(uri, QUERY_PARAM_SRC);
                if (!TextUtils.isEmpty((CharSequence)videoUrl)) {
                    this.mListener.onJsVideoLoad(videoUrl);
                    break;
                }
                ErrorLog.post("Empty parameter in js command: src", "js");
                break;
            }
            case "/mute": {
                String muteStr = this.detectQueryParameter(uri, QUERY_PARAM_MUTE);
                if (this.isValidBooleanParameter(muteStr)) {
                    this.mListener.onJsVideoMute(Boolean.parseBoolean(muteStr));
                    break;
                }
                ErrorLog.post("Empty parameter in js command: mute", "js");
                break;
            }
            case "/play": {
                String playStr = this.detectQueryParameter(uri, QUERY_PARAM_CURRENT_TIME);
                int time = 0;
                if (playStr != null) {
                    time = Integer.parseInt(playStr);
                }
                this.mListener.onJsVideoPlay(time);
                break;
            }
            case "/pause": {
                String pauseStr = this.detectQueryParameter(uri, QUERY_PARAM_CURRENT_TIME);
                int pause_time = 0;
                if (pauseStr != null) {
                    pause_time = Integer.parseInt(pauseStr);
                }
                this.mListener.onJsVideoPause(pause_time);
                break;
            }
            case "/enableStretching": {
                this.mListener.onJsVideoStretch(true);
                break;
            }
            case "/disableStretching": {
                this.mListener.onJsVideoStretch(false);
                break;
            }
        }
    }

    private String detectQueryParameter(Uri uri, String parameter) {
        String result = null;
        try {
            result = uri.getQueryParameter(parameter);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        if (this.mListener != null) {
            this.mListener.onJsLoadFail("onReceivedError " + description);
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        Logging.out(LOG_TAG, "onPageStarted");
        super.onPageStarted(view, url, favicon);
    }

    public static interface Listener {
        public void onJsClose();

        public void onJsLoadSuccess();

        public void onJsLoadFail(String var1);

        public void onJsFullscreenMode(boolean var1);

        public void onJsVideoLoad(String var1);

        public void onJsVideoMute(boolean var1);

        public void onJsVideoPlay(int var1);

        public void onJsVideoPause(int var1);

        public void onJsVideoStretch(boolean var1);

        public void onNonLoopMe(String var1);
    }
}

