/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.adbrowser;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.loopme.adbrowser.BrowserWebView;
import com.loopme.common.Base64Drawables;
import com.loopme.common.Utils;

public final class AdBrowserLayout
extends RelativeLayout {
    private static final int HEADER_HEIGHT_DP = 30;
    private final RelativeLayout mFooterView;
    private final ProgressBar mProgressBar;
    private final Button mBackBtn;
    private final Button mRefreshBtn;
    private final Button mCloseBtn;
    private final Button mNativeBtn;
    private final BrowserWebView mAdBrowserWebview;
    private Base64Drawables mBase64Drawables = new Base64Drawables();

    public AdBrowserLayout(Context context) {
        super(context);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mAdBrowserWebview = new BrowserWebView(context);
        this.mAdBrowserWebview.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.mAdBrowserWebview);
        this.mFooterView = new RelativeLayout(context);
        this.configFooterView();
        LinearLayout buttonsContainer = new LinearLayout(context);
        this.configButtonsContainer(buttonsContainer);
        int buttonWidth = Utils.getDisplayMetrics().widthPixels / 5;
        RelativeLayout.LayoutParams buttons_params = new RelativeLayout.LayoutParams(buttonWidth, -1);
        int size = Utils.convertDpToPixel(30.0f) / 2;
        RelativeLayout.LayoutParams pb_params = new RelativeLayout.LayoutParams(size, size);
        pb_params.addRule(13);
        this.mProgressBar = new ProgressBar(context);
        this.configProgressButton(context, buttonsContainer, buttons_params, pb_params);
        this.mBackBtn = new Button(context);
        this.configBackButton(context, buttonsContainer, buttons_params, pb_params);
        this.mRefreshBtn = new Button(context);
        this.configRefreshButton(context, buttonsContainer, buttons_params, pb_params);
        this.mNativeBtn = new Button(context);
        this.configNativeButton(context, buttonsContainer, buttons_params, pb_params);
        this.mCloseBtn = new Button(context);
        this.configCloseButton(context, buttonsContainer, buttons_params, pb_params);
        this.mFooterView.addView(this.initBottomWhiteLineView(context));
    }

    private void configProgressButton(Context context, LinearLayout buttonsContainer, RelativeLayout.LayoutParams buttons_params, RelativeLayout.LayoutParams pb_params) {
        RelativeLayout progressLayout = new RelativeLayout(context);
        progressLayout.setLayoutParams((ViewGroup.LayoutParams)buttons_params);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)pb_params);
        progressLayout.addView((View)this.mProgressBar);
        buttonsContainer.addView((View)progressLayout);
    }

    private void configButtonsContainer(LinearLayout buttonsContainer) {
        LinearLayout.LayoutParams buttonsContainerParams = new LinearLayout.LayoutParams(-1, -1);
        buttonsContainer.setLayoutParams((ViewGroup.LayoutParams)buttonsContainerParams);
        buttonsContainer.setBackgroundColor(-16777216);
        this.mFooterView.addView((View)buttonsContainer);
    }

    private void configFooterView() {
        RelativeLayout.LayoutParams footer_params = new RelativeLayout.LayoutParams(-1, Utils.convertDpToPixel(30.0f));
        footer_params.addRule(12);
        this.mFooterView.setLayoutParams((ViewGroup.LayoutParams)footer_params);
        this.addView((View)this.mFooterView);
    }

    private View initBottomWhiteLineView(Context context) {
        View whiteLine = new View(context);
        RelativeLayout.LayoutParams whiteLineParams = new RelativeLayout.LayoutParams(-1, 1);
        whiteLineParams.addRule(12);
        whiteLine.setLayoutParams((ViewGroup.LayoutParams)whiteLineParams);
        whiteLine.setBackgroundColor(-1);
        return whiteLine;
    }

    @SuppressLint(value={"NewApi"})
    private void configBackButton(Context context, LinearLayout buttonsContainer, RelativeLayout.LayoutParams buttons_params, RelativeLayout.LayoutParams pb_params) {
        RelativeLayout backLayout = new RelativeLayout(context);
        backLayout.setLayoutParams((ViewGroup.LayoutParams)buttons_params);
        if (Build.VERSION.SDK_INT < 16) {
            this.mBackBtn.setBackgroundDrawable((Drawable)Utils.decodeImage(this.mBase64Drawables.getBackInactive()));
        } else {
            this.mBackBtn.setBackground((Drawable)Utils.decodeImage(this.mBase64Drawables.getBackInactive()));
        }
        this.mBackBtn.setLayoutParams((ViewGroup.LayoutParams)pb_params);
        backLayout.addView((View)this.mBackBtn);
        buttonsContainer.addView((View)backLayout);
    }

    @SuppressLint(value={"NewApi"})
    private void configRefreshButton(Context context, LinearLayout buttonsContainer, RelativeLayout.LayoutParams buttons_params, RelativeLayout.LayoutParams pb_params) {
        RelativeLayout refreshLayout = new RelativeLayout(context);
        refreshLayout.setLayoutParams((ViewGroup.LayoutParams)buttons_params);
        if (Build.VERSION.SDK_INT < 16) {
            this.mRefreshBtn.setBackgroundDrawable((Drawable)Utils.decodeImage(this.mBase64Drawables.getRefresh()));
        } else {
            this.mRefreshBtn.setBackground((Drawable)Utils.decodeImage(this.mBase64Drawables.getRefresh()));
        }
        this.mRefreshBtn.setLayoutParams((ViewGroup.LayoutParams)pb_params);
        refreshLayout.addView((View)this.mRefreshBtn);
        buttonsContainer.addView((View)refreshLayout);
    }

    @SuppressLint(value={"NewApi"})
    private void configNativeButton(Context context, LinearLayout buttonsContainer, RelativeLayout.LayoutParams buttons_params, RelativeLayout.LayoutParams pb_params) {
        RelativeLayout nativeLayout = new RelativeLayout(context);
        nativeLayout.setLayoutParams((ViewGroup.LayoutParams)buttons_params);
        if (Build.VERSION.SDK_INT < 16) {
            this.mNativeBtn.setBackgroundDrawable((Drawable)Utils.decodeImage(this.mBase64Drawables.getNativeBrowser()));
        } else {
            this.mNativeBtn.setBackground((Drawable)Utils.decodeImage(this.mBase64Drawables.getNativeBrowser()));
        }
        this.mNativeBtn.setLayoutParams((ViewGroup.LayoutParams)pb_params);
        nativeLayout.addView((View)this.mNativeBtn);
        buttonsContainer.addView((View)nativeLayout);
    }

    @SuppressLint(value={"NewApi"})
    private void configCloseButton(Context context, LinearLayout buttonsContainer, RelativeLayout.LayoutParams buttons_params, RelativeLayout.LayoutParams pb_params) {
        RelativeLayout closeLayout = new RelativeLayout(context);
        closeLayout.setLayoutParams((ViewGroup.LayoutParams)buttons_params);
        if (Build.VERSION.SDK_INT < 16) {
            this.mCloseBtn.setBackgroundDrawable((Drawable)Utils.decodeImage(this.mBase64Drawables.getClose()));
        } else {
            this.mCloseBtn.setBackground((Drawable)Utils.decodeImage(this.mBase64Drawables.getClose()));
        }
        this.mCloseBtn.setLayoutParams((ViewGroup.LayoutParams)pb_params);
        closeLayout.addView((View)this.mCloseBtn);
        buttonsContainer.addView((View)closeLayout);
    }

    public ProgressBar getProgressBar() {
        return this.mProgressBar;
    }

    public Button getBackButton() {
        return this.mBackBtn;
    }

    public Button getRefreshButton() {
        return this.mRefreshBtn;
    }

    public Button getCloseButton() {
        return this.mCloseBtn;
    }

    public Button getNativeButton() {
        return this.mNativeBtn;
    }

    public BrowserWebView getWebView() {
        return this.mAdBrowserWebview;
    }
}

