/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzck;
import com.google.android.gms.internal.zzcl;
import com.google.android.gms.internal.zzcn;
import com.google.android.gms.internal.zzcq;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzlt;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public abstract class zzcj
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    protected final Object zzakd = new Object();
    private final WeakReference<zzke> zzasg;
    private WeakReference<ViewTreeObserver> zzash;
    private final zzcq zzasi;
    protected final zzcl zzasj;
    private final Context zzask;
    private final WindowManager zzasl;
    private final PowerManager zzasm;
    private final KeyguardManager zzasn;
    @Nullable
    private zzcn zzaso;
    private boolean zzasp;
    private boolean zzaoy = false;
    private boolean zzasq = false;
    private boolean zzasr;
    private boolean zzass;
    private boolean zzast;
    @Nullable
    BroadcastReceiver zzasu;
    private final HashSet<zzck> zzasv = new HashSet();
    private zzlc zzasa;
    private final zzev zzasw = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            if (!zzcj.this.zzb(map)) {
                return;
            }
            zzcj.this.zza(zzlt2.getView(), map);
        }
    };
    private final zzev zzasx = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            if (!zzcj.this.zzb(map)) {
                return;
            }
            String string2 = String.valueOf(zzcj.this.zzasj.zzia());
            zzkn.zzdd((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
            zzcj.this.destroy();
        }
    };
    private final zzev zzasy = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            if (!zzcj.this.zzb(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzcj.this.zzj(bl);
        }
    };

    public zzcj(Context context, AdSizeParcel adSizeParcel, zzke zzke2, VersionInfoParcel versionInfoParcel, zzcq zzcq2) {
        this.zzasg = new WeakReference<zzke>(zzke2);
        this.zzasi = zzcq2;
        this.zzash = new WeakReference<Object>(null);
        this.zzasr = true;
        this.zzast = false;
        this.zzasa = new zzlc(200L);
        this.zzasj = new zzcl(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zzaxi, zzke2.zzcod, zzke2.zzib(), adSizeParcel.zzaxl);
        this.zzasl = (WindowManager)context.getSystemService("window");
        this.zzasm = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzasn = (KeyguardManager)context.getSystemService("keyguard");
        this.zzask = context;
    }

    public void zza(zzck zzck2) {
        this.zzasv.add(zzck2);
    }

    protected void zzj(boolean bl) {
        for (zzck zzck2 : this.zzasv) {
            zzck2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzhj() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzasu != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzasu = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzcj.this.zzk(3);
                }
            };
            this.zzask.registerReceiver(this.zzasu, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzhk() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzasu != null) {
                try {
                    this.zzask.unregisterReceiver(this.zzasu);
                }
                catch (IllegalStateException illegalStateException) {
                    zzkn.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                }
                catch (Exception exception) {
                    zzu.zzgd().zza(exception, "AbstractActiveViewUnit.stopScreenStatusMonitoring");
                }
                this.zzasu = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzhp();
            this.zzhk();
            this.zzasr = false;
            this.zzhm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzhl() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzasr) {
                this.zzass = true;
                try {
                    JSONObject jSONObject = this.zzht();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    zzkn.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzkn.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzasj.zzia());
                zzkn.zzdd((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzk(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzk(int n2) {
        Object object = this.zzakd;
        synchronized (object) {
            boolean bl;
            if (!this.zzhr() || !this.zzasr) {
                return;
            }
            View view = this.zzasi.zzhu();
            boolean bl2 = view != null && zzu.zzfz().zza(view, this.zzasm, this.zzasn) && view.getGlobalVisibleRect(new Rect(), null);
            boolean bl3 = this.zzasi.zzhv();
            if (bl3) {
                this.zzhl();
                return;
            }
            boolean bl4 = bl = n2 == 1;
            if (bl && !this.zzasa.tryAcquire() && bl2 == this.zzast) {
                return;
            }
            if (!bl2 && !this.zzast && n2 == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
                this.zzast = bl2;
            }
            catch (RuntimeException | JSONException throwable) {
                zzkn.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            this.zzho();
            this.zzhm();
        }
    }

    protected void zzhm() {
        if (this.zzaso != null) {
            this.zzaso.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzhn() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzasr;
        }
    }

    protected int zza(int n2, DisplayMetrics displayMetrics) {
        float f2 = displayMetrics.density;
        return (int)((float)n2 / f2);
    }

    protected void zzho() {
        zzcq zzcq2 = this.zzasi.zzhw();
        View view = zzcq2.zzhu();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzash.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzhp();
        if (!this.zzasp || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzasp = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzash = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    protected boolean zzb(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzasj.zzia());
    }

    protected void zzc(zzfz zzfz2) {
        zzfz2.zza("/updateActiveView", this.zzasw);
        zzfz2.zza("/untrackActiveViewUnit", this.zzasx);
        zzfz2.zza("/visibilityChanged", this.zzasy);
    }

    protected void zzd(zzfz zzfz2) {
        zzfz2.zzb("/visibilityChanged", this.zzasy);
        zzfz2.zzb("/untrackActiveViewUnit", this.zzasx);
        zzfz2.zzb("/updateActiveView", this.zzasw);
    }

    protected void zzhp() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzash.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzhq() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzasj.zzhy()).put("activeViewJSON", (Object)this.zzasj.zzhz()).put("timestamp", zzu.zzgf().elapsedRealtime()).put("adFormat", (Object)this.zzasj.zzhx()).put("hashCode", (Object)this.zzasj.zzia()).put("isMraid", this.zzasj.zzib()).put("isStopped", this.zzasq).put("isPaused", this.zzaoy).put("isScreenOn", this.isScreenOn()).put("isNative", this.zzasj.zzic()).put("appMuted", zzu.zzfz().zzfg()).put("appVolume", (double)zzu.zzfz().zzfe()).put("deviceVolume", (double)zzu.zzfz().zzal(this.zzask));
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzb(jSONObject2);
        }
        catch (Throwable throwable) {
            zzkn.zzb((String)"Skipping active view message.", (Throwable)throwable);
        }
    }

    protected abstract void zzb(JSONObject var1);

    protected abstract boolean zzhr();

    protected JSONObject zzhs() throws JSONException {
        return this.zzhq().put("isAttachedToWindow", false).put("isScreenOn", this.isScreenOn()).put("isVisible", false);
    }

    protected JSONObject zzd(@Nullable View view) throws JSONException {
        if (view == null) {
            return this.zzhs();
        }
        boolean bl = zzu.zzgb().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzkn.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzasl.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzasl.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzhq();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", zzu.zzfz().zza(view, this.zzasm, this.zzasn));
        return jSONObject;
    }

    boolean isScreenOn() {
        return this.zzasm.isScreenOn();
    }

    protected JSONObject zzht() throws JSONException {
        JSONObject jSONObject = this.zzhq();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzk(1);
    }

    public void onGlobalLayout() {
        this.zzk(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzcn zzcn2) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzaso = zzcn2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzasq = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzaoy = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzaoy = false;
            this.zzk(3);
        }
    }

    public static class zzb
    implements zzcq {
        private zzi zzatb;

        public zzb(zzi zzi2) {
            this.zzatb = zzi2;
        }

        @Override
        public View zzhu() {
            return this.zzatb != null ? this.zzatb.zzly() : null;
        }

        @Override
        public boolean zzhv() {
            return this.zzatb == null;
        }

        @Override
        public zzcq zzhw() {
            return this;
        }
    }

    public static class zza
    implements zzcq {
        private WeakReference<zzi> zzata;

        public zza(zzi zzi2) {
            this.zzata = new WeakReference<zzi>(zzi2);
        }

        @Override
        @Nullable
        public View zzhu() {
            zzi zzi2 = (zzi)this.zzata.get();
            return zzi2 != null ? zzi2.zzly() : null;
        }

        @Override
        public boolean zzhv() {
            return this.zzata.get() == null;
        }

        @Override
        public zzcq zzhw() {
            return new zzb((zzi)this.zzata.get());
        }
    }

    public static class zzc
    implements zzcq {
        @Nullable
        private final View mView;
        @Nullable
        private final zzke zzatc;

        public zzc(View view, zzke zzke2) {
            this.mView = view;
            this.zzatc = zzke2;
        }

        @Override
        public View zzhu() {
            return this.mView;
        }

        @Override
        public boolean zzhv() {
            return this.zzatc == null || this.mView == null;
        }

        @Override
        public zzcq zzhw() {
            return this;
        }
    }

    public static class zzd
    implements zzcq {
        private final WeakReference<View> zzatd;
        private final WeakReference<zzke> zzate;

        public zzd(View view, zzke zzke2) {
            this.zzatd = new WeakReference<View>(view);
            this.zzate = new WeakReference<zzke>(zzke2);
        }

        @Override
        public View zzhu() {
            return (View)this.zzatd.get();
        }

        @Override
        public boolean zzhv() {
            return this.zzatd.get() == null || this.zzate.get() == null;
        }

        @Override
        public zzcq zzhw() {
            return new zzc((View)this.zzatd.get(), (zzke)this.zzate.get());
        }
    }
}

