/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;

@zziy
class zzv
implements SensorEventListener {
    private final SensorManager zzbzb;
    private final Object zzbzc;
    private final Display zzbzd;
    private final float[] zzbze;
    private final float[] zzbzf;
    private float[] zzbzg;
    private Handler zzbzh;
    private zza zzbzi;

    zzv(Context context) {
        this.zzbzb = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzbzd = windowManager.getDefaultDisplay();
        this.zzbze = new float[9];
        this.zzbzf = new float[9];
        this.zzbzc = new Object();
    }

    int getRotation() {
        return this.zzbzd.getRotation();
    }

    void start() {
        if (this.zzbzh != null) {
            return;
        }
        Sensor sensor = this.zzbzb.getDefaultSensor(11);
        if (sensor == null) {
            zzkn.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzbzh = new Handler(handlerThread.getLooper());
        boolean bl = this.zzbzb.registerListener((SensorEventListener)this, sensor, 0, this.zzbzh);
        if (!bl) {
            zzkn.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    void stop() {
        if (this.zzbzh == null) {
            return;
        }
        this.zzbzb.unregisterListener((SensorEventListener)this);
        this.zzbzh.post(new Runnable(){

            @Override
            public void run() {
                Looper.myLooper().quit();
            }
        });
        this.zzbzh = null;
    }

    void zza(zza zza2) {
        this.zzbzi = zza2;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        this.zza(sensorEvent.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zza(float[] fArray) {
        if (fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            return;
        }
        Object object = this.zzbzc;
        synchronized (object) {
            if (this.zzbzg == null) {
                this.zzbzg = new float[9];
            }
        }
        SensorManager.getRotationMatrixFromVector((float[])this.zzbze, (float[])fArray);
        int n2 = this.getRotation();
        switch (n2) {
            case 1: {
                SensorManager.remapCoordinateSystem((float[])this.zzbze, (int)2, (int)129, (float[])this.zzbzf);
                break;
            }
            case 2: {
                SensorManager.remapCoordinateSystem((float[])this.zzbze, (int)129, (int)130, (float[])this.zzbzf);
                break;
            }
            case 3: {
                SensorManager.remapCoordinateSystem((float[])this.zzbze, (int)130, (int)1, (float[])this.zzbzf);
                break;
            }
            default: {
                System.arraycopy(this.zzbze, 0, this.zzbzf, 0, 9);
            }
        }
        this.zzf(1, 3);
        this.zzf(2, 6);
        this.zzf(5, 7);
        Object object2 = this.zzbzc;
        synchronized (object2) {
            System.arraycopy(this.zzbzf, 0, this.zzbzg, 0, 9);
        }
        if (this.zzbzi != null) {
            this.zzbzi.zzoy();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzb(float[] fArray) {
        Object object = this.zzbzc;
        synchronized (object) {
            if (this.zzbzg == null) {
                return false;
            }
            System.arraycopy(this.zzbzg, 0, fArray, 0, this.zzbzg.length);
            return true;
        }
    }

    private void zzf(int n2, int n3) {
        float f2 = this.zzbzf[n2];
        this.zzbzf[n2] = this.zzbzf[n3];
        this.zzbzf[n3] = f2;
    }

    static interface zza {
        public void zzoy();
    }
}

