/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.cache;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.cache.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import java.util.List;

@zziy
public class CacheOffering
extends AbstractSafeParcelable {
    public static final zzd CREATOR = new zzd();
    public final int version;
    @Nullable
    public final String url;
    public final long zzavv;
    public final String zzavw;
    public final String zzavx;
    public final String zzavy;
    public final Bundle zzavz;
    public final boolean zzawa;

    @Nullable
    public static CacheOffering zzag(String string) {
        return CacheOffering.zze(Uri.parse((String)string));
    }

    @Nullable
    public static CacheOffering zze(Uri uri) {
        try {
            if (!"gcache".equals(uri.getScheme())) {
                return null;
            }
            List list = uri.getPathSegments();
            if (list.size() != 2) {
                int n2 = list.size();
                zzkn.zzdf((String)new StringBuilder(62).append("Expected 2 path parts for namespace and id, found :").append(n2).toString());
                return null;
            }
            String string = (String)list.get(0);
            String string2 = (String)list.get(1);
            String string3 = uri.getHost();
            String string4 = uri.getQueryParameter("url");
            boolean bl = "1".equals(uri.getQueryParameter("read_only"));
            String string5 = uri.getQueryParameter("expiration");
            long l2 = string5 == null ? 0L : Long.parseLong(string5);
            Bundle bundle = new Bundle();
            for (String string6 : zzu.zzgb().zzh(uri)) {
                if (!string6.startsWith("tag.")) continue;
                String string7 = string6.substring("tag.".length());
                String string8 = uri.getQueryParameter(string6);
                bundle.putString(string7, string8);
            }
            return new CacheOffering(1, string4, l2, string3, string, string2, bundle, bl);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            zzkn.zzd((String)"Unable to parse Uri into cache offering.", (Throwable)runtimeException);
            return null;
        }
    }

    CacheOffering(int n2, @Nullable String string, long l2, String string2, String string3, String string4, Bundle bundle, boolean bl) {
        this.version = n2;
        this.url = string;
        this.zzavv = l2;
        this.zzavw = string2 != null ? string2 : "";
        this.zzavx = string3 != null ? string3 : "";
        this.zzavy = string4 != null ? string4 : "";
        this.zzavz = bundle != null ? bundle : new Bundle();
        this.zzawa = bl;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        zzd.zza(this, parcel, n2);
    }
}

