/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.common;

import android.text.TextUtils;
import com.loopme.common.Logging;
import com.loopme.debugging.ErrorLog;
import java.util.ArrayList;
import java.util.List;

public class AdParams {
    private static final String LOG_TAG = AdParams.class.getSimpleName();
    private final String mHtml;
    private final String mFormat;
    private final String mOrientation;
    private final int mExpiredDate;
    private List<String> mPackageIds = new ArrayList<String>();
    private List<String> mTrackers = new ArrayList<String>();
    private String mToken;
    private boolean mPartPreload;
    private boolean mVideo360;
    private boolean mMraid;
    private boolean mOwnCloseButton;

    private AdParams(AdParamsBuilder builder) {
        this.mFormat = builder.mBuilderFormat;
        this.mHtml = builder.mBuilderHtml;
        this.mOrientation = builder.mBuilderOrientation;
        this.mExpiredDate = builder.mBuilderExpiredDate == 0 ? 600000 : builder.mBuilderExpiredDate;
        this.mPackageIds = builder.mPackageIds;
        this.mTrackers = builder.mTrackers;
        this.mToken = builder.mToken;
        this.mPartPreload = builder.mPartPreload;
        this.mVideo360 = builder.mVideo360;
        this.mMraid = builder.mMraid;
        Logging.out(LOG_TAG, "Server response indicates  ad params: format: " + this.mFormat + ", orientation: " + this.mOrientation + ", mraid: " + this.mMraid + ", expire in: " + this.mExpiredDate);
    }

    public boolean getPartPreload() {
        return this.mPartPreload;
    }

    public boolean isVideo360() {
        return this.mVideo360;
    }

    public boolean isMraid() {
        return this.mMraid;
    }

    public String getHtml() {
        return this.mHtml;
    }

    public String getAdFormat() {
        return this.mFormat;
    }

    public String getAdOrientation() {
        return this.mOrientation;
    }

    public int getExpiredTime() {
        return this.mExpiredDate;
    }

    public List<String> getPackageIds() {
        return this.mPackageIds;
    }

    public List<String> getTrackers() {
        return this.mTrackers;
    }

    public String getToken() {
        return this.mToken;
    }

    public boolean isOwnCloseButton() {
        return this.mOwnCloseButton;
    }

    public void setOwnCloseButton(boolean hasOwnCloseButton) {
        this.mOwnCloseButton = hasOwnCloseButton;
    }

    static class AdParamsBuilder {
        private final String mBuilderFormat;
        private String mBuilderHtml;
        private String mBuilderOrientation;
        private int mBuilderExpiredDate;
        private List<String> mPackageIds = new ArrayList<String>();
        private String mToken;
        private boolean mPartPreload;
        private boolean mVideo360;
        private boolean mMraid;
        private List<String> mTrackers = new ArrayList<String>();

        public AdParamsBuilder(String format) {
            this.mBuilderFormat = format;
        }

        public AdParamsBuilder packageIds(List<String> installPacakage) {
            this.mPackageIds = installPacakage;
            return this;
        }

        public AdParamsBuilder trackers(List<String> trackers) {
            this.mTrackers = trackers;
            return this;
        }

        public AdParamsBuilder partPreload(boolean preload) {
            this.mPartPreload = preload;
            return this;
        }

        public AdParamsBuilder video360(boolean b2) {
            this.mVideo360 = b2;
            return this;
        }

        public AdParamsBuilder mraid(boolean isMraid) {
            this.mMraid = isMraid;
            return this;
        }

        public AdParamsBuilder token(String token) {
            this.mToken = token;
            return this;
        }

        public AdParamsBuilder html(String html) {
            if (TextUtils.isEmpty((CharSequence)html)) {
                ErrorLog.post("Broken response [empty html]", "server");
            }
            this.mBuilderHtml = html;
            return this;
        }

        public AdParamsBuilder orientation(String orientation) {
            if (this.isValidOrientationValue(orientation)) {
                this.mBuilderOrientation = orientation;
            } else if (!TextUtils.isEmpty((CharSequence)this.mBuilderFormat) && this.mBuilderFormat.equalsIgnoreCase("interstitial")) {
                ErrorLog.post("Broken response [invalid orientation: " + orientation + "]", "server");
            }
            return this;
        }

        public AdParamsBuilder expiredTime(int time) {
            int timeSec = time * 1000;
            this.mBuilderExpiredDate = Math.max(600000, timeSec);
            return this;
        }

        public AdParams build() {
            if (this.isValidFormatValue()) {
                return new AdParams(this);
            }
            Logging.out(LOG_TAG, "Wrong ad format value");
            return null;
        }

        private boolean isValidFormatValue() {
            return this.mBuilderFormat != null && (this.mBuilderFormat.equalsIgnoreCase("banner") || this.mBuilderFormat.equalsIgnoreCase("interstitial"));
        }

        private boolean isValidOrientationValue(String orientation) {
            return orientation != null && (orientation.equalsIgnoreCase("portrait") || orientation.equalsIgnoreCase("landscape"));
        }
    }
}

