/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.adbrowser;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.loopme.common.Logging;
import com.loopme.debugging.ErrorLog;
import java.net.URISyntaxException;

public class AdBrowserWebViewClient
extends WebViewClient {
    private static final String LOG_TAG = AdBrowserWebViewClient.class.getSimpleName();
    public static final String PLAY_STORE_URL = "https://play.google.com/store/apps/details?id=";
    private static final String HEADER_PLAIN_TEXT = "plain/text";
    private static final String TEL_SCHEME = "tel";
    private static final String MAILTO_SCHEME = "mailto";
    private static final String GEO_SCHEME = "geo";
    private static final String MARKET_SCHEME = "market";
    private static final String YOUTUBE_SCHEME = "vnd.youtube";
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final String INTENT_SCHEME = "intent";
    private static final String GEO_HOST = "maps.google.com";
    private static final String MARKET_HOST = "play.google.com";
    private static final String YOUTUBE_HOST1 = "www.youtube.com";
    private static final String YOUTUBE_HOST2 = "m.youtube.com";
    private Listener mListener;
    private Listener mEmptyListener = new Listener(){

        @Override
        public void onPageStarted() {
        }

        @Override
        public void onPageFinished(boolean canGoBack) {
        }

        @Override
        public void onReceiveError() {
        }

        @Override
        public void onLeaveApp() {
        }
    };

    public AdBrowserWebViewClient(Listener listener) {
        if (listener == null) {
            Logging.out(LOG_TAG, "Error: Wrong listener");
            this.mListener = this.mEmptyListener;
        } else {
            this.mListener = listener;
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Uri uri;
        Logging.out(LOG_TAG, "shouldOverrideUrlLoading url=" + url);
        Context context = view.getContext();
        try {
            uri = Uri.parse((String)url);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            ErrorLog.post("Wrong redirect (" + url + ")", "js");
            return false;
        }
        if (uri == null) {
            return false;
        }
        String scheme = uri.getScheme();
        String host = uri.getHost();
        if (TextUtils.isEmpty((CharSequence)scheme)) {
            ErrorLog.post("Wrong redirect (" + url + ")", "js");
            return false;
        }
        if (scheme.equalsIgnoreCase(TEL_SCHEME)) {
            Intent intent = new Intent("android.intent.action.DIAL", uri);
            this.resolveAndStartActivity(intent, context);
        } else if (scheme.equalsIgnoreCase(MAILTO_SCHEME)) {
            url = url.replaceFirst("mailto:", "");
            url = url.trim();
            Intent intent = new Intent("android.intent.action.SEND", uri);
            intent.setType(HEADER_PLAIN_TEXT).putExtra("android.intent.extra.EMAIL", new String[]{url});
            this.resolveAndStartActivity(intent, context);
        } else if (scheme.equalsIgnoreCase(GEO_SCHEME)) {
            Intent searchAddress = new Intent("android.intent.action.VIEW", uri);
            this.resolveAndStartActivity(searchAddress, context);
        } else if (scheme.equalsIgnoreCase(YOUTUBE_SCHEME)) {
            this.leaveApp(url, context);
        } else {
            if (scheme.equalsIgnoreCase(HTTP_SCHEME) || scheme.equalsIgnoreCase(HTTPS_SCHEME)) {
                return this.checkHost(url, host, context);
            }
            if (scheme.equalsIgnoreCase(INTENT_SCHEME)) {
                this.handleIntentScheme(url, context);
            } else if (scheme.equalsIgnoreCase(MARKET_SCHEME)) {
                this.handleMarketScheme(url, context);
            } else {
                return true;
            }
        }
        return true;
    }

    private boolean checkHost(String url, String host, Context context) {
        if (host.equalsIgnoreCase(GEO_HOST)) {
            Intent searchAddress = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.resolveAndStartActivity(searchAddress, context);
        } else if (host.equalsIgnoreCase(MARKET_HOST) || host.equalsIgnoreCase(YOUTUBE_HOST1) || host.equalsIgnoreCase(YOUTUBE_HOST2)) {
            this.leaveApp(url, context);
        } else {
            return false;
        }
        return true;
    }

    private void handleMarketScheme(String url, Context context) {
        try {
            Intent intent = Intent.parseUri((String)url, (int)0);
            intent.addFlags(0x10000000);
            if (this.isActivityResolved(intent, context)) {
                context.startActivity(intent);
            } else {
                Uri uri = Uri.parse((String)url);
                String id2 = uri.getQueryParameter("id");
                url = PLAY_STORE_URL + id2;
                this.leaveApp(url, context);
            }
        }
        catch (Exception e2) {
            this.mListener.onReceiveError();
            ErrorLog.post("Wrong redirect (" + url + ")", "js");
        }
    }

    private void handleIntentScheme(String url, Context context) {
        try {
            Intent intent = Intent.parseUri((String)url, (int)1);
            intent.addFlags(0x10000000);
            if (this.isActivityResolved(intent, context)) {
                context.startActivity(intent);
            } else {
                url = PLAY_STORE_URL + intent.getPackage();
                this.leaveApp(url, context);
            }
        }
        catch (URISyntaxException e2) {
            this.mListener.onReceiveError();
            ErrorLog.post("Wrong redirect (" + url + ")", "js");
        }
    }

    private void leaveApp(String url, Context context) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.resolveAndStartActivity(intent, context);
        this.mListener.onLeaveApp();
    }

    private void resolveAndStartActivity(Intent intent, Context context) {
        if (this.isActivityResolved(intent, context)) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        } else {
            this.mListener.onReceiveError();
        }
    }

    private boolean isActivityResolved(Intent intent, Context context) {
        return context.getPackageManager().resolveActivity(intent, 65536) != null;
    }

    public final void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.mListener.onPageStarted();
    }

    public final void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.mListener.onPageFinished(view.canGoBack());
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        String mess = "onReceivedError: " + description;
        Logging.out(LOG_TAG, mess);
        this.mListener.onReceiveError();
        ErrorLog.post("Wrong redirect " + failingUrl + " (" + description + ")", "js");
    }

    public static interface Listener {
        public void onPageStarted();

        public void onPageFinished(boolean var1);

        public void onReceiveError();

        public void onLeaveApp();
    }
}

