/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.reward.client.RewardedVideoAdRequestParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzgg;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkr;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public class zzjr
extends zzb
implements zzjv {
    private static final zzgp zzcmu = new zzgp();
    private final Map<String, zzjz> zzcmv = new HashMap<String, zzjz>();
    private boolean zzcmw;

    public zzjr(Context context, zzd zzd2, AdSizeParcel adSizeParcel, zzgq zzgq2, VersionInfoParcel versionInfoParcel) {
        super(context, adSizeParcel, null, zzgq2, versionInfoParcel, zzd2);
    }

    public void zza(RewardedVideoAdRequestParcel rewardedVideoAdRequestParcel) {
        zzac.zzhq((String)"loadAd must be called on the main UI thread.");
        if (TextUtils.isEmpty((CharSequence)rewardedVideoAdRequestParcel.zzaqt)) {
            zzkn.zzdf((String)"Invalid ad unit id. Aborting.");
            zzkr.zzcrf.post(new Runnable(){

                @Override
                public void run() {
                    zzjr.this.zzh(1);
                }
            });
            return;
        }
        this.zzcmw = false;
        this.zzall.zzaqt = rewardedVideoAdRequestParcel.zzaqt;
        super.zzb(rewardedVideoAdRequestParcel.zzcfu);
    }

    @Override
    public void zza(final zzke.zza zza2, zzdq zzdq2) {
        if (zza2.errorCode != -2) {
            zzkr.zzcrf.post(new Runnable(){

                @Override
                public void run() {
                    zzjr.this.zzb(new zzke(zza2, null, null, null, null, null, null, null));
                }
            });
            return;
        }
        this.zzall.zzarb = zza2;
        if (zza2.zzcof == null) {
            this.zzall.zzarb = this.zzd(zza2);
        }
        this.zzall.zzarv = 0;
        this.zzall.zzaqy = zzu.zzfy().zza(this.zzall.zzahn, this.zzall.zzarb, this);
    }

    @Nullable
    public zzjz zzcl(String string2) {
        zzjz zzjz2 = this.zzcmv.get(string2);
        if (zzjz2 == null) {
            try {
                zzgq zzgq2 = this.zzals;
                if ("com.google.ads.mediation.admob.AdMobAdapter".equals(string2)) {
                    zzgq2 = zzcmu;
                }
                zzjz2 = new zzjz(zzgq2.zzbq(string2), this);
                this.zzcmv.put(string2, zzjz2);
            }
            catch (Exception exception) {
                String string3 = String.valueOf(string2);
                zzkn.zzd((String)(string3.length() != 0 ? "Fail to instantiate adapter ".concat(string3) : new String("Fail to instantiate adapter ")), (Throwable)exception);
            }
        }
        return zzjz2;
    }

    @Override
    public boolean zza(zzke zzke2, zzke zzke3) {
        return true;
    }

    @Override
    protected boolean zza(AdRequestParcel adRequestParcel, zzke zzke2, boolean bl) {
        return false;
    }

    @Override
    public void pause() {
        zzac.zzhq((String)"pause must be called on the main UI thread.");
        for (String string2 : this.zzcmv.keySet()) {
            try {
                zzjz zzjz2 = this.zzcmv.get(string2);
                if (zzjz2 == null || zzjz2.zzsv() == null) continue;
                zzjz2.zzsv().pause();
            }
            catch (RemoteException remoteException) {
                String string3 = String.valueOf(string2);
                zzkn.zzdf((String)(string3.length() != 0 ? "Fail to pause adapter: ".concat(string3) : new String("Fail to pause adapter: ")));
            }
        }
    }

    @Override
    public void resume() {
        zzac.zzhq((String)"resume must be called on the main UI thread.");
        for (String string2 : this.zzcmv.keySet()) {
            try {
                zzjz zzjz2 = this.zzcmv.get(string2);
                if (zzjz2 == null || zzjz2.zzsv() == null) continue;
                zzjz2.zzsv().resume();
            }
            catch (RemoteException remoteException) {
                String string3 = String.valueOf(string2);
                zzkn.zzdf((String)(string3.length() != 0 ? "Fail to resume adapter: ".concat(string3) : new String("Fail to resume adapter: ")));
            }
        }
    }

    @Override
    public void destroy() {
        zzac.zzhq((String)"destroy must be called on the main UI thread.");
        for (String string2 : this.zzcmv.keySet()) {
            try {
                zzjz zzjz2 = this.zzcmv.get(string2);
                if (zzjz2 == null || zzjz2.zzsv() == null) continue;
                zzjz2.zzsv().destroy();
            }
            catch (RemoteException remoteException) {
                String string3 = String.valueOf(string2);
                zzkn.zzdf((String)(string3.length() != 0 ? "Fail to destroy adapter: ".concat(string3) : new String("Fail to destroy adapter: ")));
            }
        }
    }

    public void zzsn() {
        zzac.zzhq((String)"showAd must be called on the main UI thread.");
        if (!this.isLoaded()) {
            zzkn.zzdf((String)"The reward video has not loaded.");
            return;
        }
        this.zzcmw = true;
        zzjz zzjz2 = this.zzcl(this.zzall.zzara.zzbtg);
        if (zzjz2 != null && zzjz2.zzsv() != null) {
            try {
                zzjz2.zzsv().showVideo();
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call showVideo.", (Throwable)remoteException);
            }
        }
    }

    public boolean isLoaded() {
        zzac.zzhq((String)"isLoaded must be called on the main UI thread.");
        return this.zzall.zzaqx == null && this.zzall.zzaqy == null && this.zzall.zzara != null && !this.zzcmw;
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.zza(this.zzall.zzara, false);
        this.zzdz();
    }

    @Override
    public void onRewardedVideoStarted() {
        if (this.zzall.zzara != null && this.zzall.zzara.zzbte != null) {
            zzu.zzgs().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, this.zzall.zzara, this.zzall.zzaqt, false, this.zzall.zzara.zzbte.zzbru);
        }
        this.zzeb();
    }

    @Override
    public void onRewardedVideoAdClosed() {
        this.zzdx();
    }

    @Override
    public void zzc(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzall.zzara != null && this.zzall.zzara.zzbte != null) {
            zzu.zzgs().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, this.zzall.zzara, this.zzall.zzaqt, false, this.zzall.zzara.zzbte.zzbrv);
        }
        if (this.zzall.zzara != null && this.zzall.zzara.zzcof != null && !TextUtils.isEmpty((CharSequence)this.zzall.zzara.zzcof.zzbsk)) {
            rewardItemParcel = new RewardItemParcel(this.zzall.zzara.zzcof.zzbsk, this.zzall.zzara.zzcof.zzbsl);
        }
        this.zza(rewardItemParcel);
    }

    @Override
    public void zzso() {
        this.onAdClicked();
    }

    @Override
    public void onRewardedVideoAdLeftApplication() {
        this.zzdy();
    }

    public void onContextChanged(@NonNull Context context) {
        for (zzjz zzjz2 : this.zzcmv.values()) {
            try {
                zzjz2.zzsv().zzj(zze.zzac((Object)context));
            }
            catch (RemoteException remoteException) {
                zzkn.zzb((String)"Unable to call Adapter.onContextChanged.", (Throwable)remoteException);
            }
        }
    }

    private zzke.zza zzd(zzke.zza zza2) {
        Object object;
        zzkn.v("Creating mediation ad response for non-mediated rewarded ad.");
        String string2 = null;
        String string3 = null;
        try {
            string2 = zzjc.zzc(zza2.zzcop).toString();
            object = new JSONObject();
            object.put("pubid", (Object)zza2.zzcix.zzaqt);
            string3 = object.toString();
        }
        catch (JSONException jSONException) {
            zzkn.zzb((String)"Unable to generate ad state for non-mediated rewarded video.", (Throwable)jSONException);
            return this.zze(zza2);
        }
        object = new zzgg(string2, null, Arrays.asList("com.google.ads.mediation.admob.AdMobAdapter"), null, null, Collections.emptyList(), Collections.emptyList(), string3, null, Collections.emptyList(), Collections.emptyList(), null, null, null, null, null, Collections.emptyList());
        zzgh zzgh2 = new zzgh(Arrays.asList(object), -1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, "", -1L, 0, 1, null, 0, -1, -1L, false);
        return new zzke.zza(zza2.zzcix, zza2.zzcop, zzgh2, zza2.zzaqz, zza2.errorCode, zza2.zzcoj, zza2.zzcok, zza2.zzcod);
    }

    private zzke.zza zze(zzke.zza zza2) {
        return new zzke.zza(zza2.zzcix, zza2.zzcop, null, zza2.zzaqz, 0, zza2.zzcoj, zza2.zzcok, zza2.zzcod);
    }
}

