/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.formats.zzc;
import com.google.android.gms.ads.internal.formats.zzf;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.formats.zzj;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzej;
import com.google.android.gms.internal.zzek;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzlj;
import com.google.android.gms.internal.zzlt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public class zzis
implements Callable<zzke> {
    private static final long zzcdo = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zzky zzcdx;
    private final zzq zzcdy;
    private final zzau zzbkp;
    private final zzir zzbkn;
    private final Object zzakd = new Object();
    private final zzke.zza zzcck;
    private final zzdq zzalg;
    private boolean zzcdz;
    private int zzcdb;
    private List<String> zzcea;
    private JSONObject zzceb;

    public zzis(Context context, zzq zzq2, zzky zzky2, zzau zzau2, zzke.zza zza2, zzdq zzdq2) {
        this.mContext = context;
        this.zzcdy = zzq2;
        this.zzcdx = zzky2;
        this.zzcck = zza2;
        this.zzbkp = zzau2;
        this.zzalg = zzdq2;
        this.zzbkn = this.zza(context, zza2, zzq2, zzau2);
        this.zzbkn.zzre();
        this.zzcdz = false;
        this.zzcdb = -2;
        this.zzcea = null;
    }

    public zzke zzrp() {
        try {
            this.zzbkn.zzrf();
            String string2 = UUID.randomUUID().toString();
            JSONObject jSONObject = this.zzcf(string2);
            zza zza2 = this.zzf(jSONObject);
            zzi.zza zza3 = this.zza(zza2, jSONObject, string2);
            this.zza(zza3);
            zzke zzke2 = this.zzb(zza3);
            return zzke2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            zzkn.zzd((String)"Malformed native JSON response.", (Throwable)jSONException);
        }
        catch (TimeoutException timeoutException) {
            zzkn.zzd((String)"Timeout when loading native ad.", (Throwable)timeoutException);
        }
        if (!this.zzcdz) {
            this.zzap(0);
        }
        return this.zzb(null);
    }

    private JSONObject zzcf(final String string2) throws ExecutionException, InterruptedException, TimeoutException, JSONException {
        if (this.zzrq()) {
            return null;
        }
        final zzlg zzlg2 = new zzlg();
        final zzb zzb2 = new zzb();
        zzir.zza zza2 = new zzir.zza(){

            @Override
            public void zze(final zzfz zzfz2) {
                zzev zzev2;
                zzb2.zzcev = zzev2 = new zzev(){

                    @Override
                    public void zza(zzlt zzlt2, Map<String, String> map) {
                        zzfz2.zzb("/nativeAdPreProcess", zzb2.zzcev);
                        try {
                            String string2 = map.get("success");
                            if (!TextUtils.isEmpty((CharSequence)string2)) {
                                zzlg2.zzh(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                                return;
                            }
                        }
                        catch (JSONException jSONException) {
                            zzkn.zzb((String)"Malformed native JSON response.", (Throwable)jSONException);
                        }
                        zzis.this.zzap(0);
                        zzac.zza((boolean)zzis.this.zzrq(), (Object)"Unable to set the ad state error!");
                        zzlg2.zzh(null);
                    }
                };
                zzfz2.zza("/nativeAdPreProcess", zzev2);
                try {
                    JSONObject jSONObject = new JSONObject(((zzis)zzis.this).zzcck.zzcop.body);
                    jSONObject.put("ads_id", (Object)string2);
                    zzfz2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
                }
                catch (JSONException jSONException) {
                    zzkn.zzd((String)"Exception occurred while invoking javascript", (Throwable)jSONException);
                    zzlg2.zzh(null);
                }
            }

            @Override
            public void zzro() {
                zzlg2.zzh(null);
            }
        };
        this.zzbkn.zza(zza2);
        return (JSONObject)zzlg2.get(zzcdo, TimeUnit.MILLISECONDS);
    }

    protected zza zzf(JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException, TimeoutException {
        boolean bl;
        if (this.zzrq() || jSONObject == null) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzcck.zzcix.zzarn != null ? this.zzcck.zzcix.zzarn.zzblb : false;
        boolean bl3 = bl = this.zzcck.zzcix.zzarn != null ? this.zzcck.zzcix.zzarn.zzbld : false;
        if ("2".equals(string2)) {
            return new zziu(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zziv(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzlg zzlg2 = new zzlg();
            zzkr.zzcrf.post(new Runnable(){

                @Override
                public void run() {
                    zzlg2.zzh((zzek)zzis.this.zzcdy.zzfi().get((Object)string3));
                }
            });
            if (zzlg2.get(zzcdo, TimeUnit.MILLISECONDS) != null) {
                return new zziw(bl2);
            }
            String string4 = String.valueOf(jSONObject.getString("custom_template_id"));
            zzkn.e((String)(string4.length() != 0 ? "No handler for custom template: ".concat(string4) : new String("No handler for custom template: ")));
        } else {
            this.zzap(0);
        }
        return null;
    }

    private void zza(zzi.zza zza2) {
        zzev zzev2;
        if (!(zza2 instanceof zzf)) {
            return;
        }
        final zzf zzf2 = (zzf)zza2;
        zzb zzb2 = new zzb();
        zzb2.zzcev = zzev2 = new zzev(){

            @Override
            public void zza(zzlt zzlt2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzis.this.zzb((zzef)zzf2, string2);
            }
        };
        this.zzbkn.zza(new zzir.zza(){

            @Override
            public void zze(zzfz zzfz2) {
                zzfz2.zza("/nativeAdCustomClick", zzev2);
            }
        });
    }

    private void zzb(zzef zzef2, String string2) {
        try {
            zzej zzej2 = this.zzcdy.zzx(zzef2.getCustomTemplateId());
            if (zzej2 != null) {
                zzej2.zza(zzef2, string2);
            }
        }
        catch (RemoteException remoteException) {
            zzkn.zzd((String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to call onCustomClick for asset ").append(string2).append(".").toString(), (Throwable)remoteException);
        }
    }

    private zzi.zza zza(zza zza2, JSONObject jSONObject, String string2) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzrq() || zza2 == null || jSONObject == null) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzd(jSONObject2, "impression_tracking_urls");
        this.zzcea = stringArray == null ? null : Arrays.asList(stringArray);
        this.zzceb = jSONObject2.optJSONObject("active_view");
        Object t2 = zza2.zza(this, jSONObject);
        if (t2 == null) {
            zzkn.e((String)"Failed to retrieve ad assets.");
            return null;
        }
        t2.zzb((zzi)new zzj(this.mContext, this.zzcdy, this.zzbkn, this.zzbkp, jSONObject, (zzi.zza)t2, this.zzcck.zzcix.zzaqv, string2));
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzke zzb(zzi.zza zza2) {
        int n2;
        Object object = this.zzakd;
        synchronized (object) {
            n2 = this.zzcdb;
            if (zza2 == null && this.zzcdb == -2) {
                n2 = 0;
            }
        }
        if (n2 != -2) {
            zza2 = null;
        }
        return new zzke(this.zzcck.zzcix.zzcfu, null, this.zzcck.zzcop.zzbsd, n2, this.zzcck.zzcop.zzbse, this.zzcea, this.zzcck.zzcop.orientation, this.zzcck.zzcop.zzbsj, this.zzcck.zzcix.zzcfx, false, null, null, null, null, null, 0L, this.zzcck.zzaqz, this.zzcck.zzcop.zzchb, this.zzcck.zzcoj, this.zzcck.zzcok, this.zzcck.zzcop.zzchh, this.zzceb, zza2, null, null, null, this.zzcck.zzcop.zzchu, this.zzcck.zzcop.zzchv, null, this.zzcck.zzcop.zzbsg, this.zzcck.zzcop.zzchy);
    }

    public zzlj<com.google.android.gms.ads.internal.formats.zza> zzg(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzlh<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n2 = jSONObject2.optInt("text_size", -1);
        final Integer n3 = this.zzb(jSONObject2, "text_color");
        final Integer n4 = this.zzb(jSONObject2, "bg_color");
        final int n5 = jSONObject2.optInt("animation_ms", 1000);
        final int n6 = jSONObject2.optInt("presentation_ms", 4000);
        final int n7 = this.zzcck.zzcix.zzarn != null && this.zzcck.zzcix.zzarn.versionCode >= 2 ? this.zzcck.zzcix.zzarn.zzble : 1;
        ArrayList arrayList = new ArrayList<zzlj<zzc>>();
        if (jSONObject2.optJSONArray("images") != null) {
            arrayList = this.zza(jSONObject2, "images", false, false, true);
        } else {
            arrayList.add(this.zza(jSONObject2, "image", false, false));
        }
        zzlj zzlj2 = zzli.zzo(arrayList);
        return zzli.zza(zzlj2, new zzli.zza<List<zzc>, com.google.android.gms.ads.internal.formats.zza>(){

            public com.google.android.gms.ads.internal.formats.zza zzj(List<zzc> list) {
                try {
                    return list == null || list.isEmpty() ? null : new com.google.android.gms.ads.internal.formats.zza(string2, zzis.zzh(list), n4, n3, n2 > 0 ? Integer.valueOf(n2) : null, n6 + n5, n7);
                }
                catch (RemoteException remoteException) {
                    zzkn.zzb((String)"Could not get attribution icon", (Throwable)remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object apply(Object object) {
                return this.zzj((List)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n2 = jSONObject2.getInt("r");
            int n3 = jSONObject2.getInt("g");
            int n4 = jSONObject2.getInt("b");
            return Color.rgb((int)n2, (int)n3, (int)n4);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzc> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zzlj<zzc> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zzlj<zzc>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zzlj<zzc>> arrayList = new ArrayList<zzlj<zzc>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n2 = bl3 ? jSONArray.length() : 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zzlj<zzc> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        final String string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        final double d2 = jSONObject.optDouble("scale", 1.0);
        final boolean bl3 = jSONObject.optBoolean("is_transparent", true);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzlh<Object>(null);
        }
        if (bl2) {
            return new zzlh<zzc>(new zzc(null, Uri.parse((String)string2), d2));
        }
        return this.zzcdx.zza(string2, new zzky.zza<zzc>(){

            public zzc zzrr() {
                zzis.this.zza(2, bl);
                return null;
            }

            @TargetApi(value=19)
            public zzc zzg(InputStream inputStream) {
                Bitmap bitmap = null;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inDensity = (int)(160.0 * d2);
                if (!bl3) {
                    options.inPreferredConfig = Bitmap.Config.RGB_565;
                }
                try {
                    bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                }
                catch (Exception exception) {
                    zzkn.zzb((String)"Error grabbing image.", (Throwable)exception);
                }
                if (bitmap == null) {
                    zzis.this.zza(2, bl);
                    return null;
                }
                if (zzs.zzaxr()) {
                    int n2 = bitmap.getWidth();
                    int n3 = bitmap.getHeight();
                    int n4 = bitmap.getAllocationByteCount();
                    zzkn.v(new StringBuilder(61).append("Decoded image w: ").append(n2).append(" h:").append(n3).append(" bytes: ").append(n4).toString());
                }
                return new zzc((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2), d2);
            }

            @Override
            public /* synthetic */ Object zzrs() {
                return this.zzrr();
            }

            @Override
            @TargetApi(value=19)
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    public zzlj<zzlt> zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject(string2);
        if (jSONObject2 == null) {
            return new zzlh<Object>(null);
        }
        String string3 = jSONObject2.optString("vast_xml");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            zzkn.zzdf((String)"Required field 'vast_xml' is missing");
            return new zzlh<Object>(null);
        }
        return this.zza(this.mContext, this.zzbkp, this.zzcck, this.zzalg, this.zzcdy).zzh(jSONObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzrq() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcdz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzap(int n2) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcdz = true;
            this.zzcdb = n2;
        }
    }

    public void zza(int n2, boolean bl) {
        if (bl) {
            this.zzap(n2);
        }
    }

    private String[] zzd(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            stringArray[i2] = jSONArray.getString(i2);
        }
        return stringArray;
    }

    private static List<Drawable> zzh(List<zzc> list) throws RemoteException {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        for (zzc zzc2 : list) {
            arrayList.add((Drawable)zze.zzae((zzd)zzc2.zzln()));
        }
        return arrayList;
    }

    zzir zza(Context context, zzke.zza zza2, zzq zzq2, zzau zzau2) {
        return new zzir(context, zza2, zzq2, zzau2);
    }

    zzit zza(Context context, zzau zzau2, zzke.zza zza2, zzdq zzdq2, zzq zzq2) {
        return new zzit(context, zzau2, zza2, zzdq2, zzq2);
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzrp();
    }

    class zzb {
        public zzev zzcev;

        zzb() {
        }
    }

    public static interface zza<T extends zzi.zza> {
        public T zza(zzis var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

