/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzlt;
import java.util.Map;

@zziy
public class zzhg
extends zzhm {
    private final Map<String, String> zzbiq;
    private final Context mContext;
    private String zzbup;
    private long zzbuq;
    private long zzbur;
    private String zzbus;
    private String zzbut;

    public zzhg(zzlt zzlt2, Map<String, String> map) {
        super(zzlt2, "createCalendarEvent");
        this.zzbiq = map;
        this.mContext = zzlt2.zzvn();
        this.zznr();
    }

    private void zznr() {
        this.zzbup = this.zzbu("description");
        this.zzbus = this.zzbu("summary");
        this.zzbuq = this.zzbv("start_ticks");
        this.zzbur = this.zzbv("end_ticks");
        this.zzbut = this.zzbu("location");
    }

    private String zzbu(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzbiq.get(string2)) ? "" : this.zzbiq.get(string2);
    }

    private long zzbv(String string2) {
        String string3 = this.zzbiq.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzbx("Activity context is not available.");
            return;
        }
        zzda zzda2 = zzu.zzfz().zzag(this.mContext);
        if (!zzda2.zzko()) {
            this.zzbx("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzu.zzfz().zzaf(this.mContext);
        Resources resources = zzu.zzgd().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_title) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_message) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                Intent intent = zzhg.this.createIntent();
                zzu.zzfz().zzb(zzhg.this.mContext, intent);
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                zzhg.this.zzbx("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    @TargetApi(value=14)
    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzbup);
        intent.putExtra("eventLocation", this.zzbut);
        intent.putExtra("description", this.zzbus);
        if (this.zzbuq > -1L) {
            intent.putExtra("beginTime", this.zzbuq);
        }
        if (this.zzbur > -1L) {
            intent.putExtra("endTime", this.zzbur);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

