/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzk;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.internal.zzdb;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkt;
import com.google.android.gms.internal.zzlm;

@zziy
public abstract class zzd
implements zzc.zza,
zzkt<Void> {
    private final zzlm<AdRequestInfoParcel> zzcfm;
    private final zzc.zza zzcfn;
    private final Object zzakd = new Object();

    public zzd(zzlm<AdRequestInfoParcel> zzlm2, zzc.zza zza2) {
        this.zzcfm = zzlm2;
        this.zzcfn = zza2;
    }

    public abstract void zzrv();

    public abstract zzk zzrw();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcfn.zzb(adResponseParcel);
            this.zzrv();
        }
    }

    public Void zzqt() {
        final zzk zzk2 = this.zzrw();
        if (zzk2 == null) {
            this.zzcfn.zzb(new AdResponseParcel(0));
            this.zzrv();
            return null;
        }
        this.zzcfm.zza(new zzlm.zzc<AdRequestInfoParcel>(){

            public void zzc(AdRequestInfoParcel adRequestInfoParcel) {
                if (!zzd.this.zza(zzk2, adRequestInfoParcel)) {
                    zzd.this.zzrv();
                }
            }

            @Override
            public /* synthetic */ void zzd(Object object) {
                this.zzc((AdRequestInfoParcel)((Object)object));
            }
        }, new zzlm.zza(){

            @Override
            public void run() {
                zzd.this.zzrv();
            }
        });
        return null;
    }

    @Override
    public void cancel() {
        this.zzrv();
    }

    boolean zza(zzk zzk2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzk2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            zzkn.zzd((String)"Could not fetch ad response from ad request service.", (Throwable)remoteException);
            zzu.zzgd().zza(remoteException, "AdRequestClientTask.getAdResponseFromService");
        }
        catch (NullPointerException nullPointerException) {
            zzkn.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)nullPointerException);
            zzu.zzgd().zza(nullPointerException, "AdRequestClientTask.getAdResponseFromService");
        }
        catch (SecurityException securityException) {
            zzkn.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)securityException);
            zzu.zzgd().zza(securityException, "AdRequestClientTask.getAdResponseFromService");
        }
        catch (Throwable throwable) {
            zzkn.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)throwable);
            zzu.zzgd().zza(throwable, "AdRequestClientTask.getAdResponseFromService");
        }
        this.zzcfn.zzb(new AdResponseParcel(0));
        return false;
    }

    @Override
    public /* synthetic */ Object zzqw() {
        return this.zzqt();
    }

    @zziy
    public static class zzb
    extends zzd
    implements zze.zzb,
    zze.zzc {
        private Context mContext;
        private VersionInfoParcel zzanh;
        private zzlm<AdRequestInfoParcel> zzcfm;
        private final zzc.zza zzcfn;
        private final Object zzakd = new Object();
        protected zze zzcfq;
        private boolean zzcfr;

        public zzb(Context context, VersionInfoParcel versionInfoParcel, zzlm<AdRequestInfoParcel> zzlm2, zzc.zza zza2) {
            super(zzlm2, zza2);
            Looper looper;
            this.mContext = context;
            this.zzanh = versionInfoParcel;
            this.zzcfm = zzlm2;
            this.zzcfn = zza2;
            if (zzdi.zzbbu.get().booleanValue()) {
                this.zzcfr = true;
                looper = zzu.zzgp().zzuy();
            } else {
                looper = context.getMainLooper();
            }
            this.zzcfq = new zze(context, looper, this, this, this.zzanh.zzctt);
            this.connect();
        }

        protected void connect() {
            this.zzcfq.zzatu();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzk zzrw() {
            Object object = this.zzakd;
            synchronized (object) {
                try {
                    return this.zzcfq.zzry();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzrv() {
            Object object = this.zzakd;
            synchronized (object) {
                if (this.zzcfq.isConnected() || this.zzcfq.isConnecting()) {
                    this.zzcfq.disconnect();
                }
                Binder.flushPendingCommands();
                if (this.zzcfr) {
                    zzu.zzgp().zzuz();
                    this.zzcfr = false;
                }
            }
        }

        zzkt zzrx() {
            return new zza(this.mContext, this.zzcfm, this.zzcfn);
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzkn.zzdd((String)"Cannot connect to remote service, fallback to local instance.");
            zzkt zzkt2 = this.zzrx();
            zzkt2.zzqw();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzu.zzfz().zzb(this.mContext, this.zzanh.zzcs, "gmob-apps", bundle, true);
        }

        public void onConnected(Bundle bundle) {
            Void cfr_ignored_0 = (Void)((zzd)this).zzqw();
        }

        public void onConnectionSuspended(int n2) {
            zzkn.zzdd((String)"Disconnected from remote ad request service.");
        }

        @Override
        public /* synthetic */ Object zzqw() {
            return super.zzqt();
        }
    }

    @zziy
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, zzlm<AdRequestInfoParcel> zzlm2, zzc.zza zza2) {
            super(zzlm2, zza2);
            this.mContext = context;
        }

        @Override
        public zzk zzrw() {
            zzdb zzdb2 = new zzdb(zzdi.zzbao.get());
            return zzjb.zza(this.mContext, zzdb2, zzja.zzsc());
        }

        @Override
        public void zzrv() {
        }

        @Override
        public /* synthetic */ Object zzqw() {
            return super.zzqt();
        }
    }
}

