/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzia;
import com.google.android.gms.internal.zzib;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkm;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zziy
public class zzc
extends zzkm
implements ServiceConnection {
    private final Object zzakd = new Object();
    private boolean zzcbk = false;
    private Context mContext;
    private zzib zzbpt;
    private zzb zzcbl;
    private zzh zzcbm;
    private List<zzf> zzcbn = null;
    private zzk zzcbo;

    public zzc(Context context, zzib zzib2, zzk zzk2) {
        this(context, zzib2, zzk2, new zzb(context), zzh.zzs(context.getApplicationContext()));
    }

    zzc(Context context, zzib zzib2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzbpt = zzib2;
        this.zzcbo = zzk2;
        this.zzcbl = zzb2;
        this.zzcbm = zzh2;
        this.zzcbn = this.zzcbm.zzg(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzfc() {
        Object object = this.zzakd;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            com.google.android.gms.common.stats.zzb.zzawu().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zze(SystemClock.elapsedRealtime());
            com.google.android.gms.common.stats.zzb.zzawu().zza(this.mContext, (ServiceConnection)this);
            this.zzcbl.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzakd;
        synchronized (object) {
            com.google.android.gms.common.stats.zzb.zzawu().zza(this.mContext, (ServiceConnection)this);
            this.zzcbl.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        zzkn.zzde((String)"In-app billing service disconnected.");
        this.zzcbl.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcbl.zzav(iBinder);
            this.zzqo();
            this.zzcbk = true;
            this.zzakd.notify();
        }
    }

    protected void zzqo() {
        int n2;
        Bundle bundle;
        if (this.zzcbn.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzcbn) {
            hashMap.put(object2.zzcca, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzcbl.zzn(this.mContext.getPackageName(), (String)object3)) != null && (n2 = zzu.zzgn().zzd(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                if (!hashMap.containsKey(arrayList.get(i2))) continue;
                String string2 = (String)arrayList.get(i2);
                String string3 = (String)arrayList2.get(i2);
                String string4 = (String)arrayList3.get(i2);
                zzf zzf2 = (zzf)hashMap.get(string2);
                String string5 = zzu.zzgn().zzcc(string3);
                if (!zzf2.zzcbz.equals(string5)) continue;
                this.zza(zzf2, string3, string4);
                hashMap.remove(string2);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string6 : hashMap.keySet()) {
            this.zzcbm.zza((zzf)hashMap.get(string6));
        }
    }

    protected void zza(final zzf zzf2, String string2, String string3) {
        final Intent intent = new Intent();
        zzu.zzgn();
        intent.putExtra("RESPONSE_CODE", 0);
        zzu.zzgn();
        intent.putExtra("INAPP_PURCHASE_DATA", string2);
        zzu.zzgn();
        intent.putExtra("INAPP_DATA_SIGNATURE", string3);
        zzkr.zzcrf.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzcbo.zza(zzf2.zzcbz, -1, intent)) {
                        zzc.this.zzbpt.zza((zzia)new zzg(zzc.this.mContext, zzf2.zzcca, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzbpt.zza((zzia)new zzg(zzc.this.mContext, zzf2.zzcca, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    zzkn.zzdf((String)"Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zze(long l2) {
        do {
            if (this.zzf(l2)) continue;
            zzkn.v("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzcbk);
    }

    private boolean zzf(long l2) {
        long l3 = 60000L - (SystemClock.elapsedRealtime() - l2);
        if (l3 <= 0L) {
            return false;
        }
        try {
            this.zzakd.wait(l3);
        }
        catch (InterruptedException interruptedException) {
            zzkn.zzdf((String)"waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

