/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.tasks;

import com.loopme.common.Logging;

public class RequestTimer
implements Runnable {
    private static final String LOG_TAG = RequestTimer.class.getSimpleName();
    private int mTimeout;
    private Listener mListener;
    private Thread mThread;

    public void start() {
        this.mThread.start();
    }

    public void stop() {
        try {
            this.mThread.interrupt();
        }
        catch (SecurityException e2) {
            Logging.out(LOG_TAG, e2.getMessage());
        }
        Logging.out(LOG_TAG, LOG_TAG + " is successfully stopped.");
    }

    public RequestTimer(int timeout, Listener listener) {
        this.mTimeout = timeout;
        this.mListener = listener;
        this.mThread = new Thread(this);
    }

    @Override
    public void run() {
        long timeNow = System.currentTimeMillis();
        long timeInFuture = timeNow + (long)this.mTimeout;
        while (timeNow != timeInFuture) {
            timeNow = System.currentTimeMillis();
        }
        if (this.mListener != null && !this.mThread.isInterrupted()) {
            this.mListener.onTimeout();
        }
    }

    public static interface Listener {
        public void onTimeout();
    }
}

