/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.common;

import android.util.DisplayMetrics;
import android.view.ViewGroup;
import com.loopme.common.Logging;
import com.loopme.common.Utils;

public class MinimizedMode {
    private static final String LOG_TAG = MinimizedMode.class.getSimpleName();
    private int mWidth = 100;
    private int mHeight = 100;
    private int mMarginRight = 10;
    private int mMarginBottom = 10;
    private ViewGroup mRoot;

    public MinimizedMode(ViewGroup root) {
        if (root == null) {
            Logging.out(LOG_TAG, "Error: Root view should be not null. Minimized mode will not work");
            return;
        }
        this.mRoot = root;
        DisplayMetrics dm = Utils.getDisplayMetrics();
        this.mWidth = dm.heightPixels > dm.widthPixels ? dm.widthPixels / 2 : dm.widthPixels / 3;
        this.mHeight = this.mWidth * 2 / 3;
        this.mWidth -= 6;
    }

    public void setViewSize(int width, int height) {
        this.mWidth = Utils.convertDpToPixel(width);
        this.mHeight = Utils.convertDpToPixel(height);
    }

    public void setMarginRight(int margin) {
        this.mMarginRight = Utils.convertDpToPixel(margin);
    }

    public void setMarginBottom(int margin) {
        this.mMarginBottom = Utils.convertDpToPixel(margin);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public ViewGroup getRootView() {
        return this.mRoot;
    }

    public int getMarginRight() {
        return this.mMarginRight;
    }

    public int getMarginBottom() {
        return this.mMarginBottom;
    }
}

