/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.common;

import android.text.TextUtils;
import android.util.Log;
import com.loopme.common.FileUtils;
import com.loopme.common.StaticParams;
import com.loopme.common.Utils;
import com.loopme.debugging.LiveDebug;

public class Logging {
    private static final String PREFIX = "Debug.LoopMe.";

    private Logging() {
    }

    public static void out(String tag, String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        String logTag = PREFIX + tag;
        if (StaticParams.DEBUG_MODE) {
            Log.i((String)logTag, (String)text);
        }
        LiveDebug.handle(logTag, text);
    }

    public static void logEvent(String appKey, String event) {
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            return;
        }
        FileUtils.logToFile("AppKey: " + appKey, true);
        Logging.logEvent(event);
    }

    public static void logEvent(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        String message = Utils.getCurrentDate() + ": " + text;
        FileUtils.logToFile(message, true);
    }
}

