/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.Context;
import android.content.Intent;
import com.loopme.AdBrowserActivity;
import com.loopme.AdUtils;
import com.loopme.BaseAd;
import com.loopme.LoopMeBanner;
import com.loopme.common.Logging;
import com.loopme.common.Utils;
import com.loopme.mraid.MraidBridge;
import com.loopme.mraid.MraidVideoActivity;
import com.loopme.mraid.MraidView;

public class MraidController
implements MraidBridge.OnMraidBridgeListener {
    private static final String LOG_TAG = MraidController.class.getSimpleName();
    private static final String EXTRAS_URL = "url";
    private static final String EXTRAS_VIDEO_URL = "videoUrl";
    private BaseAd mBaseAd;
    private MraidView mMraidView;

    public MraidController(BaseAd ad) {
        this.mBaseAd = ad;
    }

    public void setMraidView(MraidView mv) {
        this.mMraidView = mv;
    }

    @Override
    public void close() {
        Logging.out(LOG_TAG, "close");
        this.mBaseAd.dismiss();
    }

    @Override
    public void open(String url) {
        Logging.out(LOG_TAG, "open " + url);
        Context context = this.mMraidView.getContext();
        if (Utils.isOnline(context)) {
            Intent intent = new Intent(context, AdBrowserActivity.class);
            intent.putExtra(EXTRAS_URL, url);
            intent.putExtra("appkey", this.mBaseAd.getAppKey());
            intent.putExtra("format", this.mBaseAd.getAdFormat());
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        } else {
            Logging.out(LOG_TAG, "No internet connection");
        }
    }

    @Override
    public void resize(int w2, int h2) {
        Logging.out(LOG_TAG, "resize");
        if (this.mBaseAd.getAdFormat() == 1000) {
            LoopMeBanner banner = (LoopMeBanner)this.mBaseAd;
            banner.getBannerView().setViewSize(w2, h2);
            this.mMraidView.resize();
            this.mMraidView.setState("resized");
            this.mMraidView.notifySizeChangeEvent(w2, h2);
            this.mMraidView.setIsViewable(true);
        }
    }

    @Override
    public void playVideo(String url) {
        Logging.out(LOG_TAG, "playVideo");
        Intent i2 = new Intent(this.mMraidView.getContext(), MraidVideoActivity.class);
        i2.putExtra(EXTRAS_VIDEO_URL, url);
        i2.addFlags(0x20000000);
        i2.addFlags(0x10000000);
        this.mMraidView.getContext().startActivity(i2);
        this.mMraidView.setIsViewable(true);
    }

    @Override
    public void expand(boolean isExpand) {
        Logging.out(LOG_TAG, "expand " + isExpand);
        AdUtils.startMraidActivity(this.mBaseAd, isExpand);
    }

    @Override
    public void onLoadSuccess() {
        this.mBaseAd.onAdLoadSuccess();
    }

    @Override
    public void onChangeCloseButtonVisibility(boolean hasOwnCloseButton) {
        this.mBaseAd.getAdParams().setOwnCloseButton(hasOwnCloseButton);
        this.broadcastCloseButtonIntent(hasOwnCloseButton);
    }

    private void broadcastCloseButtonIntent(boolean hasOwnCloseButton) {
        Intent intent = new Intent();
        intent.setAction("com.loopme.MRAID_NEED_CLOSE_BUTTON");
        intent.putExtra("customClose", hasOwnCloseButton);
        this.mBaseAd.getContext().sendBroadcast(intent);
    }
}

