/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.view.View;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzlt;

@zziy
@TargetApi(value=11)
public class zzma
extends WebChromeClient {
    private final zzlt zzbkr;

    protected boolean zza(Context context, String string2, String string3, String string4, JsResult jsResult, JsPromptResult jsPromptResult, boolean bl) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle((CharSequence)string2);
            if (bl) {
                zzma.zza(context, builder, string3, string4, jsPromptResult);
            } else {
                zzma.zza(builder, string3, jsResult);
            }
        }
        catch (WindowManager.BadTokenException badTokenException) {
            zzkn.zzd((String)"Fail to display Dialog.", (Throwable)badTokenException);
        }
        return true;
    }

    private static void zza(AlertDialog.Builder builder, String string2, final JsResult jsResult) {
        builder.setMessage((CharSequence)string2).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                jsResult.confirm();
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                jsResult.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                jsResult.cancel();
            }
        }).create().show();
    }

    private static void zza(Context context, AlertDialog.Builder builder, String string2, String string3, final JsPromptResult jsPromptResult) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        TextView textView = new TextView(context);
        textView.setText((CharSequence)string2);
        final EditText editText = new EditText(context);
        editText.setText((CharSequence)string3);
        linearLayout.addView((View)textView);
        linearLayout.addView((View)editText);
        builder.setView((View)linearLayout).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                jsPromptResult.confirm(editText.getText().toString());
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                jsPromptResult.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                jsPromptResult.cancel();
            }
        }).create().show();
    }

    public zzma(zzlt zzlt2) {
        this.zzbkr = zzlt2;
    }

    public final boolean onCreateWindow(WebView webView, boolean bl, boolean bl2, Message message) {
        WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)message.obj;
        WebView webView2 = new WebView(webView.getContext());
        webView2.setWebViewClient((WebViewClient)this.zzbkr.zzvr());
        webViewTransport.setWebView(webView2);
        message.sendToTarget();
        return true;
    }

    public final void onCloseWindow(WebView webView) {
        if (!(webView instanceof zzlt)) {
            zzkn.zzdf((String)"Tried to close a WebView that wasn't an AdWebView.");
            return;
        }
        zzd zzd2 = ((zzlt)webView).zzvp();
        if (zzd2 == null) {
            zzkn.zzdf((String)"Tried to close an AdWebView not associated with an overlay.");
            return;
        }
        zzd2.close();
    }

    public final boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String string2 = String.valueOf(consoleMessage.message());
        String string3 = String.valueOf(consoleMessage.sourceId());
        int n2 = consoleMessage.lineNumber();
        String string4 = new StringBuilder(19 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("JS: ").append(string2).append(" (").append(string3).append(":").append(n2).append(")").toString();
        if (string4.contains("Application Cache")) {
            return super.onConsoleMessage(consoleMessage);
        }
        switch (consoleMessage.messageLevel()) {
            case ERROR: {
                zzkn.e((String)string4);
                break;
            }
            case WARNING: {
                zzkn.zzdf((String)string4);
                break;
            }
            case LOG: 
            case TIP: {
                zzkn.zzde((String)string4);
                break;
            }
            case DEBUG: {
                zzkn.zzdd((String)string4);
                break;
            }
            default: {
                zzkn.zzde((String)string4);
            }
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public final void onExceededDatabaseQuota(String string2, String string3, long l2, long l3, long l4, WebStorage.QuotaUpdater quotaUpdater) {
        long l5;
        long l6 = 0x500000L - l4;
        if (l6 <= 0L) {
            quotaUpdater.updateQuota(l2);
            return;
        }
        if (l2 == 0L) {
            l5 = l3 <= l6 && l3 <= 0x100000L ? l3 : 0L;
        } else if (l3 == 0L) {
            long l7 = Math.min(131072L, l6);
            l5 = Math.min(l2 + l7, 0x100000L);
        } else {
            long l8 = Math.min(0x100000L - l2, l6);
            l5 = l3 <= l8 ? l2 + l3 : l2;
        }
        quotaUpdater.updateQuota(l5);
    }

    public final void onHideCustomView() {
        zzd zzd2 = this.zzbkr.zzvp();
        if (zzd2 == null) {
            zzkn.zzdf((String)"Could not get ad overlay when hiding custom view.");
            return;
        }
        zzd2.zzos();
    }

    private final Context zza(WebView webView) {
        if (!(webView instanceof zzlt)) {
            return webView.getContext();
        }
        zzlt zzlt2 = (zzlt)webView;
        Activity activity = zzlt2.zzvn();
        return activity != null ? activity : zzlt2.getContext();
    }

    public final boolean onJsAlert(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(this.zza(webView), string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsBeforeUnload(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(this.zza(webView), string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsConfirm(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(this.zza(webView), string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsPrompt(WebView webView, String string2, String string3, String string4, JsPromptResult jsPromptResult) {
        return this.zza(this.zza(webView), string2, string3, string4, null, jsPromptResult, true);
    }

    public final void onReachedMaxAppCacheSize(long l2, long l3, WebStorage.QuotaUpdater quotaUpdater) {
        long l4 = 0x500000L - l3;
        long l5 = l2 + 131072L;
        if (l4 < l5) {
            quotaUpdater.updateQuota(0L);
        } else {
            quotaUpdater.updateQuota(l5);
        }
    }

    public final void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zza(view, -1, customViewCallback);
    }

    public final void onGeolocationPermissionsShowPrompt(String string2, GeolocationPermissions.Callback callback) {
        if (callback != null) {
            callback.invoke(string2, this.zzxf(), true);
        }
    }

    private final boolean zzxf() {
        return zzu.zzfz().zza(this.zzbkr.getContext().getPackageManager(), this.zzbkr.getContext().getPackageName(), "android.permission.ACCESS_FINE_LOCATION") || zzu.zzfz().zza(this.zzbkr.getContext().getPackageManager(), this.zzbkr.getContext().getPackageName(), "android.permission.ACCESS_COARSE_LOCATION");
    }

    protected final void zza(View view, int n2, WebChromeClient.CustomViewCallback customViewCallback) {
        zzd zzd2 = this.zzbkr.zzvp();
        if (zzd2 == null) {
            zzkn.zzdf((String)"Could not get ad overlay when showing custom view.");
            customViewCallback.onCustomViewHidden();
            return;
        }
        zzd2.zza(view, customViewCallback);
        zzd2.setRequestedOrientation(n2);
    }
}

