/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Debug;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.ThinAdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzcr;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzdu;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzib;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkj;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzkn;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

@zziy
public abstract class zza
extends zzu.zza
implements com.google.android.gms.ads.internal.client.zza,
zzp,
zza.zza,
zzer,
zzil.zza,
zzkj {
    protected zzdq zzalg;
    protected zzdo zzalh;
    protected zzdo zzali;
    protected boolean zzalj = false;
    protected final zzr zzalk;
    protected final zzv zzall;
    @Nullable
    protected transient AdRequestParcel zzalm;
    protected final zzcm zzaln;
    protected final zzd zzalo;

    public zzd zzdp() {
        return this.zzalo;
    }

    zza(zzv zzv2, @Nullable zzr zzr2, zzd zzd2) {
        this.zzall = zzv2;
        this.zzalk = zzr2 != null ? zzr2 : new zzr(this);
        this.zzalo = zzd2;
        zzu.zzfz().zzad(this.zzall.zzahn);
        zzu.zzgd().zzb(this.zzall.zzahn, this.zzall.zzaqv);
        zzu.zzge().initialize(this.zzall.zzahn);
        this.zzaln = zzu.zzgd().zztx();
        zzu.zzgc().initialize(this.zzall.zzahn);
        this.zzdq();
    }

    private void zzdq() {
        if (zzdi.zzbgg.get().booleanValue()) {
            Timer timer = new Timer();
            CountDownLatch countDownLatch = new CountDownLatch(zzdi.zzbgi.get());
            TimerTask timerTask = this.zza(timer, countDownLatch);
            timer.schedule(timerTask, 0L, (long)zzdi.zzbgh.get());
        }
    }

    private TimerTask zza(final Timer timer, final CountDownLatch countDownLatch) {
        return new TimerTask(){

            @Override
            public void run() {
                if ((long)zzdi.zzbgi.get().intValue() != countDownLatch.getCount()) {
                    zzkn.zzdd((String)"Stopping method tracing");
                    Debug.stopMethodTracing();
                    if (countDownLatch.getCount() == 0L) {
                        timer.cancel();
                        return;
                    }
                }
                String string2 = String.valueOf(zza.this.zzall.zzahn.getPackageName()).concat("_adsTrace_");
                try {
                    zzkn.zzdd((String)"Starting method tracing");
                    countDownLatch.countDown();
                    long l2 = zzu.zzgf().currentTimeMillis();
                    Debug.startMethodTracing((String)new StringBuilder(20 + String.valueOf(string2).length()).append(string2).append(l2).toString(), (int)zzdi.zzbgj.get());
                }
                catch (Exception exception) {
                    zzkn.zzd((String)"Exception occurred while starting method tracing.", (Throwable)exception);
                    return;
                }
            }
        };
    }

    public void zzdr() {
        this.zzalg = new zzdq(zzdi.zzbca.get(), "load_ad", this.zzall.zzaqz.zzaxi);
        this.zzalh = new zzdo(-1L, null, null);
        this.zzali = new zzdo(-1L, null, null);
    }

    public void destroy() {
        zzac.zzhq((String)"destroy must be called on the main UI thread.");
        this.zzalk.cancel();
        this.zzaln.zzk(this.zzall.zzara);
        this.zzall.destroy();
    }

    public com.google.android.gms.dynamic.zzd zzds() {
        zzac.zzhq((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzac((Object)((Object)this.zzall.zzaqw));
    }

    @Nullable
    public AdSizeParcel zzdt() {
        zzac.zzhq((String)"getAdSize must be called on the main UI thread.");
        return this.zzall.zzaqz == null ? null : new ThinAdSizeParcel(this.zzall.zzaqz);
    }

    public boolean isReady() {
        zzac.zzhq((String)"isLoaded must be called on the main UI thread.");
        return this.zzall.zzaqx == null && this.zzall.zzaqy == null && this.zzall.zzara != null;
    }

    public void setManualImpressionsEnabled(boolean bl) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    private AdRequestParcel zza(AdRequestParcel adRequestParcel) {
        if (zzi.zzcm((Context)this.zzall.zzahn) && adRequestParcel.zzawl != null) {
            return new zzf(adRequestParcel).zza(null).zzja();
        }
        return adRequestParcel;
    }

    public boolean zzb(AdRequestParcel adRequestParcel) {
        zzac.zzhq((String)"loadAd must be called on the main UI thread.");
        zzu.zzge().zzit();
        if (zzdi.zzbdg.get().booleanValue()) {
            AdRequestParcel.zzj((AdRequestParcel)adRequestParcel);
        }
        adRequestParcel = this.zza(adRequestParcel);
        if (this.zzall.zzaqx != null || this.zzall.zzaqy != null) {
            if (this.zzalm != null) {
                zzkn.zzdf((String)"Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzkn.zzdf((String)"Loading already in progress, saving this object for future refreshes.");
            }
            this.zzalm = adRequestParcel;
            return false;
        }
        zzkn.zzde((String)"Starting ad request.");
        this.zzdr();
        this.zzalh = this.zzalg.zzla();
        if (!adRequestParcel.zzawg) {
            String string2 = String.valueOf(zzm.zzjr().zzar(this.zzall.zzahn));
            zzkn.zzde((String)new StringBuilder(71 + String.valueOf(string2).length()).append("Use AdRequest.Builder.addTestDevice(\"").append(string2).append("\") to get test ads on this device.").toString());
        }
        this.zzalk.zzg(adRequestParcel);
        this.zzalj = this.zza(adRequestParcel, this.zzalg);
        return this.zzalj;
    }

    protected abstract boolean zza(AdRequestParcel var1, zzdq var2);

    @Override
    public void zza(zzke.zza zza2) {
        long l2;
        if (zza2.zzcop.zzchg != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzcop.zzchp) && (l2 = this.zzu(zza2.zzcop.zzchp)) != -1L) {
            zzdo zzdo2 = this.zzalg.zzc(zza2.zzcop.zzchg + l2);
            this.zzalg.zza(zzdo2, "stc");
        }
        this.zzalg.zzav(zza2.zzcop.zzchp);
        this.zzalg.zza(this.zzalh, "arf");
        this.zzali = this.zzalg.zzla();
        this.zzalg.zzh("gqi", zza2.zzcop.zzchq);
        this.zzall.zzaqx = null;
        this.zzall.zzarb = zza2;
        this.zza(zza2, this.zzalg);
    }

    protected abstract void zza(zzke.zza var1, zzdq var2);

    boolean zza(zzke zzke2) {
        return false;
    }

    @Override
    public void zzb(zzke zzke2) {
        this.zzalg.zza(this.zzali, "awr");
        this.zzall.zzaqy = null;
        if (zzke2.errorCode != -2 && zzke2.errorCode != 3) {
            zzu.zzgd().zzb(this.zzall.zzgy());
        }
        if (zzke2.errorCode == -1) {
            this.zzalj = false;
            return;
        }
        if (this.zza(zzke2)) {
            zzkn.zzdd((String)"Ad refresh scheduled.");
        }
        if (zzke2.errorCode != -2) {
            this.zzh(zzke2.errorCode);
            return;
        }
        if (this.zzall.zzart == null) {
            this.zzall.zzart = new zzkk(this.zzall.zzaqt);
        }
        this.zzaln.zzj(this.zzall.zzara);
        if (this.zza(this.zzall.zzara, zzke2)) {
            this.zzall.zzara = zzke2;
            this.zzall.zzhh();
            this.zzalg.zzh("is_mraid", this.zzall.zzara.zzib() ? "1" : "0");
            this.zzalg.zzh("is_mediation", this.zzall.zzara.zzchc ? "1" : "0");
            if (this.zzall.zzara.zzbyh != null && this.zzall.zzara.zzbyh.zzvr() != null) {
                this.zzalg.zzh("is_delay_pl", this.zzall.zzara.zzbyh.zzvr().zzwm() ? "1" : "0");
            }
            this.zzalg.zza(this.zzalh, "ttc");
            if (zzu.zzgd().zztm() != null) {
                zzu.zzgd().zztm().zza(this.zzalg);
            }
            if (this.zzall.zzhc()) {
                this.zzea();
            }
        }
        if (zzke2.zzbsg != null) {
            zzu.zzfz().zza(this.zzall.zzahn, zzke2.zzbsg);
        }
    }

    protected abstract boolean zza(@Nullable zzke var1, zzke var2);

    public void onAdClicked() {
        if (this.zzall.zzara == null) {
            zzkn.zzdf((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        zzkn.zzdd((String)"Pinging click URLs.");
        if (this.zzall.zzarc != null) {
            this.zzall.zzarc.zzta();
        }
        if (this.zzall.zzara.zzbsd != null) {
            zzu.zzfz().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, this.zzall.zzara.zzbsd);
        }
        if (this.zzall.zzard != null) {
            try {
                this.zzall.zzard.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not notify onAdClicked event.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public void zzdu() {
        this.zzdy();
    }

    @Override
    public void onAppEvent(String string2, @Nullable String string3) {
        if (this.zzall.zzarf != null) {
            try {
                this.zzall.zzarf.onAppEvent(string2, string3);
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call the AppEventListener.", (Throwable)remoteException);
            }
        }
    }

    public void zzdv() {
        zzac.zzhq((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzall.zzara == null) {
            zzkn.zzdf((String)"Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzkn.zzdd((String)"Pinging manual tracking URLs.");
        if (this.zzall.zzara.zzche != null && !this.zzall.zzara.zzcon) {
            zzu.zzfz().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, this.zzall.zzara.zzche);
            this.zzall.zzara.zzcon = true;
            this.zzd(this.zzall.zzara);
        }
    }

    public void pause() {
        zzac.zzhq((String)"pause must be called on the main UI thread.");
    }

    public void resume() {
        zzac.zzhq((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(AdRequestParcel adRequestParcel) {
        if (this.zzall.zzaqw == null) {
            return false;
        }
        ViewParent viewParent = this.zzall.zzaqw.getParent();
        if (!(viewParent instanceof View)) {
            return false;
        }
        View view = (View)viewParent;
        return zzu.zzfz().zza(view, view.getContext());
    }

    public void zzd(AdRequestParcel adRequestParcel) {
        if (this.zzc(adRequestParcel)) {
            this.zzb(adRequestParcel);
        } else {
            zzkn.zzde((String)"Ad is not visible. Not refreshing ad.");
            this.zzalk.zzh(adRequestParcel);
        }
    }

    public void zza(zzq zzq2) {
        zzac.zzhq((String)"setAdListener must be called on the main UI thread.");
        this.zzall.zzare = zzq2;
    }

    public void zza(com.google.android.gms.ads.internal.reward.client.zzd zzd2) {
        zzac.zzhq((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzall.zzarq = zzd2;
    }

    public void setUserId(String string2) {
        zzkn.zzdf((String)"RewardedVideoAd.setUserId() is deprecated. Please do not call this method.");
    }

    public void zza(com.google.android.gms.ads.internal.client.zzp zzp2) {
        zzac.zzhq((String)"setAdListener must be called on the main UI thread.");
        this.zzall.zzard = zzp2;
    }

    public void zza(AdSizeParcel adSizeParcel) {
        zzac.zzhq((String)"setAdSize must be called on the main UI thread.");
        this.zzall.zzaqz = adSizeParcel;
        if (this.zzall.zzara != null && this.zzall.zzara.zzbyh != null && this.zzall.zzarv == 0) {
            this.zzall.zzara.zzbyh.zza(adSizeParcel);
        }
        if (this.zzall.zzaqw == null) {
            return;
        }
        if (this.zzall.zzaqw.getChildCount() > 1) {
            this.zzall.zzaqw.removeView(this.zzall.zzaqw.getNextView());
        }
        this.zzall.zzaqw.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzall.zzaqw.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzall.zzaqw.requestLayout();
    }

    public void zza(zzw zzw2) {
        zzac.zzhq((String)"setAppEventListener must be called on the main UI thread.");
        this.zzall.zzarf = zzw2;
    }

    public void zza(zzhx zzhx2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    public void zza(zzdu zzdu2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    public void zza(zzib zzib2, String string2) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    public void zza(zzy zzy2) {
        zzac.zzhq((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzall.zzarg = zzy2;
    }

    public void stopLoading() {
        zzac.zzhq((String)"stopLoading must be called on the main UI thread.");
        this.zzalj = false;
        this.zzall.zzi(true);
    }

    public boolean isLoading() {
        return this.zzalj;
    }

    public zzab zzdw() {
        return null;
    }

    public void zza(@Nullable VideoOptionsParcel videoOptionsParcel) {
        zzac.zzhq((String)"setVideoOptions must be called on the main UI thread.");
        this.zzall.zzaro = videoOptionsParcel;
    }

    Bundle zza(@Nullable zzcu zzcu2) {
        if (zzcu2 == null) {
            return null;
        }
        if (zzcu2.zziq()) {
            zzcu2.wakeup();
        }
        zzcr zzcr2 = zzcu2.zzio();
        String string2 = null;
        String string3 = null;
        if (zzcr2 != null) {
            string2 = zzcr2.zzie();
            string3 = zzcr2.zzif();
            String string4 = String.valueOf(zzcr2.toString());
            zzkn.zzdd((String)(string4.length() != 0 ? "In AdManager: loadAd, ".concat(string4) : new String("In AdManager: loadAd, ")));
            if (string2 != null) {
                zzu.zzgd().zzct(string2);
            }
        } else {
            string2 = zzu.zzgd().zztq();
        }
        if (string2 != null) {
            Bundle bundle = new Bundle(1);
            bundle.putString("fingerprint", string2);
            if (!string2.equals(string3)) {
                bundle.putString("v_fp", string3);
            }
            return bundle;
        }
        return null;
    }

    long zzu(String string2) {
        int n2 = string2.indexOf("ufe");
        int n3 = string2.indexOf(44, n2);
        if (n3 == -1) {
            n3 = string2.length();
        }
        try {
            return Long.parseLong(string2.substring(n2 + 4, n3));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzkn.zzdf((String)"Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzkn.zzdf((String)"Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        zzv.zza zza2 = this.zzall.zzaqw;
        if (zza2 != null) {
            zza2.addView(view, zzu.zzgb().zzup());
        }
    }

    protected void zzdx() {
        zzkn.zzde((String)"Ad closing.");
        if (this.zzall.zzare != null) {
            try {
                this.zzall.zzare.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call AdListener.onAdClosed().", (Throwable)remoteException);
            }
        }
        if (this.zzall.zzarq != null) {
            try {
                this.zzall.zzarq.onRewardedVideoAdClosed();
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", (Throwable)remoteException);
            }
        }
    }

    protected void zzdy() {
        zzkn.zzde((String)"Ad leaving application.");
        if (this.zzall.zzare != null) {
            try {
                this.zzall.zzare.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
            }
        }
        if (this.zzall.zzarq != null) {
            try {
                this.zzall.zzarq.onRewardedVideoAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", (Throwable)remoteException);
            }
        }
    }

    protected void zzdz() {
        zzkn.zzde((String)"Ad opening.");
        if (this.zzall.zzare != null) {
            try {
                this.zzall.zzare.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call AdListener.onAdOpened().", (Throwable)remoteException);
            }
        }
        if (this.zzall.zzarq != null) {
            try {
                this.zzall.zzarq.onRewardedVideoAdOpened();
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", (Throwable)remoteException);
            }
        }
    }

    protected void zzea() {
        zzkn.zzde((String)"Ad finished loading.");
        this.zzalj = false;
        if (this.zzall.zzare != null) {
            try {
                this.zzall.zzare.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
            }
        }
        if (this.zzall.zzarq != null) {
            try {
                this.zzall.zzarq.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", (Throwable)remoteException);
            }
        }
    }

    protected void zzh(int n2) {
        zzkn.zzdf((String)new StringBuilder(30).append("Failed to load ad: ").append(n2).toString());
        this.zzalj = false;
        if (this.zzall.zzare != null) {
            try {
                this.zzall.zzare.onAdFailedToLoad(n2);
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
            }
        }
        if (this.zzall.zzarq != null) {
            try {
                this.zzall.zzarq.onRewardedVideoAdFailedToLoad(n2);
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", (Throwable)remoteException);
            }
        }
    }

    protected void zzeb() {
        if (this.zzall.zzarq == null) {
            return;
        }
        try {
            this.zzall.zzarq.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzkn.zzd((String)"Could not call RewardedVideoAdListener.onVideoStarted().", (Throwable)remoteException);
        }
    }

    protected void zza(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzall.zzarq == null) {
            return;
        }
        try {
            String string2 = "";
            int n2 = 0;
            if (rewardItemParcel != null) {
                string2 = rewardItemParcel.type;
                n2 = rewardItemParcel.zzcny;
            }
            this.zzall.zzarq.zza((com.google.android.gms.ads.internal.reward.client.zza)new zzjp(string2, n2));
        }
        catch (RemoteException remoteException) {
            zzkn.zzd((String)"Could not call RewardedVideoAdListener.onRewarded().", (Throwable)remoteException);
        }
    }

    protected void zzc(@Nullable zzke zzke2) {
        if (zzke2 == null) {
            zzkn.zzdf((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzkn.zzdd((String)"Pinging Impression URLs.");
        if (this.zzall.zzarc != null) {
            this.zzall.zzarc.zzsz();
        }
        if (zzke2.zzbse != null && !zzke2.zzcom) {
            zzu.zzfz().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, zzke2.zzbse);
            zzke2.zzcom = true;
            this.zzd(zzke2);
        }
    }

    private void zzd(zzke zzke2) {
        if (!zzu.zzgh().zzuu() || zzke2.zzcoo || TextUtils.isEmpty((CharSequence)zzke2.zzchy)) {
            return;
        }
        zzkn.zzdd((String)"Sending troubleshooting signals to the server.");
        zzu.zzgh().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, zzke2.zzchy, this.zzall.zzaqt);
        zzke2.zzcoo = true;
    }

    @Override
    public void zza(HashSet<zzkf> hashSet) {
        this.zzall.zza(hashSet);
    }
}

