/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzv;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzde;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zziy
@TargetApi(value=14)
public class zzw
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzv.zza {
    private static final float[] zzbzk = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzv zzbzl;
    private final float[] zzbzg;
    private final float[] zzbzm;
    private final float[] zzbzn;
    private final float[] zzbzo;
    private final float[] zzbzp;
    private final float[] zzbzq;
    private final float[] zzbzr;
    private float zzbzs;
    private float zzbzt;
    private float zzbzu;
    private int zzajx;
    private int zzajw;
    private SurfaceTexture zzbzv;
    private SurfaceTexture zzbzw;
    private int zzbzx;
    private int zzbzy;
    private int zzbzz;
    private FloatBuffer zzcaa = ByteBuffer.allocateDirect(zzbzk.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzcab;
    private final Object zzcac;
    private EGL10 zzcad;
    private EGLDisplay zzcae;
    private EGLContext zzcaf;
    private EGLSurface zzcag;
    private volatile boolean zzcah;
    private volatile boolean zzcai;

    public zzw(Context context) {
        super("SphericalVideoProcessor");
        this.zzcaa.put(zzbzk).position(0);
        this.zzbzg = new float[9];
        this.zzbzm = new float[9];
        this.zzbzn = new float[9];
        this.zzbzo = new float[9];
        this.zzbzp = new float[9];
        this.zzbzq = new float[9];
        this.zzbzr = new float[9];
        this.zzbzs = Float.NaN;
        this.zzbzl = new zzv(context);
        this.zzbzl.zza(this);
        this.zzcab = new CountDownLatch(1);
        this.zzcac = new Object();
    }

    public void zza(SurfaceTexture surfaceTexture, int n2, int n3) {
        this.zzajw = n2;
        this.zzajx = n3;
        this.zzbzw = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(int n2, int n3) {
        Object object = this.zzcac;
        synchronized (object) {
            this.zzajw = n2;
            this.zzajx = n3;
            this.zzcah = true;
            this.zzcac.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzpt() {
        Object object = this.zzcac;
        synchronized (object) {
            this.zzcai = true;
            this.zzbzw = null;
            this.zzcac.notifyAll();
        }
    }

    public SurfaceTexture zzpu() {
        if (this.zzbzw == null) {
            return null;
        }
        try {
            this.zzcab.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.zzbzv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzbzz;
        Object object = this.zzcac;
        synchronized (object) {
            this.zzcac.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzoy() {
        Object object = this.zzcac;
        synchronized (object) {
            this.zzcac.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        if (this.zzbzw == null) {
            zzkn.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzcab.countDown();
            return;
        }
        boolean bl2 = this.zzpz();
        int n2 = this.zzpx();
        boolean bl3 = bl = this.zzbzx != 0;
        if (!bl2 || !bl) {
            String string2 = GLUtils.getEGLErrorString((int)this.zzcad.eglGetError());
            String string3 = String.valueOf(string2);
            String string4 = string3.length() != 0 ? "EGL initialization failed: ".concat(string3) : new String("EGL initialization failed: ");
            zzkn.e((String)string4);
            zzu.zzgd().zza(new Throwable(string4), "SphericalVideoProcessor.run.1");
            this.zzqd();
            this.zzcab.countDown();
            return;
        }
        this.zzbzv = new SurfaceTexture(n2);
        this.zzbzv.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzcab.countDown();
        this.zzbzl.start();
        try {
            this.zzcah = true;
            while (!this.zzcai) {
                this.zzpv();
                if (this.zzcah) {
                    this.zzpw();
                    this.zzcah = false;
                }
                try {
                    Object object = this.zzcac;
                    synchronized (object) {
                        if (!this.zzcai && !this.zzcah && this.zzbzz == 0) {
                            this.zzcac.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            zzkn.zzdf((String)"SphericalVideoProcessor halted unexpectedly.");
        }
        catch (Throwable throwable) {
            zzkn.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzu.zzgd().zza(throwable, "SphericalVideoProcessor.run.2");
        }
        finally {
            this.zzbzl.stop();
            this.zzbzv.setOnFrameAvailableListener(null);
            this.zzbzv = null;
            this.zzqd();
        }
    }

    void zzpv() {
        while (this.zzbzz > 0) {
            this.zzbzv.updateTexImage();
            --this.zzbzz;
        }
        if (this.zzbzl.zzb(this.zzbzg)) {
            if (Float.isNaN(this.zzbzs)) {
                this.zzbzs = -this.zzc(this.zzbzg);
            }
            this.zzb(this.zzbzq, this.zzbzs + this.zzbzt);
        } else {
            this.zza(this.zzbzg, -1.5707964f);
            this.zzb(this.zzbzq, this.zzbzt);
        }
        this.zza(this.zzbzm, 1.5707964f);
        this.zza(this.zzbzn, this.zzbzq, this.zzbzm);
        this.zza(this.zzbzo, this.zzbzg, this.zzbzn);
        this.zza(this.zzbzp, this.zzbzu);
        this.zza(this.zzbzr, this.zzbzp, this.zzbzo);
        GLES20.glUniformMatrix3fv((int)this.zzbzy, (int)1, (boolean)false, (float[])this.zzbzr, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.zzcb("drawArrays");
        GLES20.glFinish();
        this.zzcad.eglSwapBuffers(this.zzcae, this.zzcag);
    }

    private float zzc(float[] fArray) {
        float[] fArray2 = this.zza(fArray, new float[]{0.0f, 1.0f, 0.0f});
        return (float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f;
    }

    public void zzb(float f2, float f3) {
        float f4;
        float f5;
        if (this.zzajw > this.zzajx) {
            f5 = 1.7453293f * f2 / (float)this.zzajw;
            f4 = 1.7453293f * f3 / (float)this.zzajw;
        } else {
            f5 = 1.7453293f * f2 / (float)this.zzajx;
            f4 = 1.7453293f * f3 / (float)this.zzajx;
        }
        this.zzbzt -= f5;
        this.zzbzu -= f4;
        if (this.zzbzu < -1.5707964f) {
            this.zzbzu = -1.5707964f;
        }
        if (this.zzbzu > 1.5707964f) {
            this.zzbzu = 1.5707964f;
        }
    }

    private void zzpw() {
        GLES20.glViewport((int)0, (int)0, (int)this.zzajw, (int)this.zzajx);
        this.zzcb("viewport");
        int n2 = GLES20.glGetUniformLocation((int)this.zzbzx, (String)"uFOVx");
        int n3 = GLES20.glGetUniformLocation((int)this.zzbzx, (String)"uFOVy");
        if (this.zzajw > this.zzajx) {
            GLES20.glUniform1f((int)n2, (float)0.87266463f);
            GLES20.glUniform1f((int)n3, (float)(0.87266463f * (float)this.zzajx / (float)this.zzajw));
        } else {
            GLES20.glUniform1f((int)n2, (float)(0.87266463f * (float)this.zzajw / (float)this.zzajx));
            GLES20.glUniform1f((int)n3, (float)0.87266463f);
        }
    }

    private float[] zza(float[] fArray, float[] fArray2) {
        return new float[]{fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2], fArray[3] * fArray2[0] + fArray[4] * fArray2[1] + fArray[5] * fArray2[2], fArray[6] * fArray2[0] + fArray[7] * fArray2[1] + fArray[8] * fArray2[2]};
    }

    private void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private void zza(float[] fArray, float f2) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f2);
        fArray[5] = (float)(-Math.sin(f2));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f2);
        fArray[8] = (float)Math.cos(f2);
    }

    private void zzb(float[] fArray, float f2) {
        fArray[0] = (float)Math.cos(f2);
        fArray[1] = (float)(-Math.sin(f2));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f2);
        fArray[4] = (float)Math.cos(f2);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    int zzpx() {
        this.zzbzx = this.zzpy();
        GLES20.glUseProgram((int)this.zzbzx);
        this.zzcb("useProgram");
        int n2 = GLES20.glGetAttribLocation((int)this.zzbzx, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n2, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.zzcaa);
        this.zzcb("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n2);
        this.zzcb("enableVertexAttribArray");
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        this.zzcb("genTextures");
        int n3 = nArray[0];
        GLES20.glBindTexture((int)36197, (int)n3);
        this.zzcb("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        this.zzcb("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        this.zzcb("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        this.zzcb("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.zzcb("texParameteri");
        this.zzbzy = GLES20.glGetUniformLocation((int)this.zzbzx, (String)"uVMat");
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)this.zzbzy, (int)1, (boolean)false, (float[])fArray, (int)0);
        return n3;
    }

    private int zzpy() {
        int n2 = this.zzc(35633, this.zzqb());
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.zzc(35632, this.zzqc());
        if (n3 == 0) {
            return 0;
        }
        int n4 = GLES20.glCreateProgram();
        this.zzcb("createProgram");
        if (n4 != 0) {
            GLES20.glAttachShader((int)n4, (int)n2);
            this.zzcb("attachShader");
            GLES20.glAttachShader((int)n4, (int)n3);
            this.zzcb("attachShader");
            GLES20.glLinkProgram((int)n4);
            this.zzcb("linkProgram");
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
            this.zzcb("getProgramiv");
            if (nArray[0] != 1) {
                Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                GLES20.glDeleteProgram((int)n4);
                this.zzcb("deleteProgram");
                n4 = 0;
            } else {
                GLES20.glValidateProgram((int)n4);
                this.zzcb("validateProgram");
            }
        }
        return n4;
    }

    private int zzc(int n2, String string2) {
        int n3 = GLES20.glCreateShader((int)n2);
        this.zzcb("createShader");
        if (n3 != 0) {
            GLES20.glShaderSource((int)n3, (String)string2);
            this.zzcb("shaderSource");
            GLES20.glCompileShader((int)n3);
            this.zzcb("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n3, (int)35713, (int[])nArray, (int)0);
            this.zzcb("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n2).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n3));
                GLES20.glDeleteShader((int)n3);
                this.zzcb("deleteShader");
                n3 = 0;
            }
        }
        return n3;
    }

    boolean zzpz() {
        this.zzcad = (EGL10)EGLContext.getEGL();
        this.zzcae = this.zzcad.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.zzcae == EGL10.EGL_NO_DISPLAY) {
            return false;
        }
        int[] nArray = new int[2];
        if (!this.zzcad.eglInitialize(this.zzcae, nArray)) {
            return false;
        }
        EGLConfig eGLConfig = this.zzqa();
        if (eGLConfig == null) {
            return false;
        }
        int[] nArray2 = new int[]{12440, 2, 12344};
        this.zzcaf = this.zzcad.eglCreateContext(this.zzcae, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray2);
        if (this.zzcaf == null || this.zzcaf == EGL10.EGL_NO_CONTEXT) {
            return false;
        }
        this.zzcag = this.zzcad.eglCreateWindowSurface(this.zzcae, eGLConfig, (Object)this.zzbzw, null);
        if (this.zzcag == null || this.zzcag == EGL10.EGL_NO_SURFACE) {
            return false;
        }
        return this.zzcad.eglMakeCurrent(this.zzcae, this.zzcag, this.zzcag, this.zzcaf);
    }

    @Nullable
    private EGLConfig zzqa() {
        int[] nArray = new int[1];
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
        if (!this.zzcad.eglChooseConfig(this.zzcae, nArray2, eGLConfigArray, 1, nArray)) {
            return null;
        }
        if (nArray[0] > 0) {
            return eGLConfigArray[0];
        }
        return null;
    }

    private String zzqb() {
        zzde<String> zzde2 = zzdi.zzbdq;
        if (!zzde2.get().equals(zzde2.zzkq())) {
            return zzde2.get();
        }
        return "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
    }

    private String zzqc() {
        zzde<String> zzde2 = zzdi.zzbdr;
        if (!zzde2.get().equals(zzde2.zzkq())) {
            return zzde2.get();
        }
        return "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
    }

    boolean zzqd() {
        boolean bl = false;
        if (this.zzcag != null && this.zzcag != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzcad.eglMakeCurrent(this.zzcae, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            bl |= this.zzcad.eglDestroySurface(this.zzcae, this.zzcag);
            this.zzcag = null;
        }
        if (this.zzcaf != null) {
            bl |= this.zzcad.eglDestroyContext(this.zzcae, this.zzcaf);
            this.zzcaf = null;
        }
        if (this.zzcae != null) {
            bl |= this.zzcad.eglTerminate(this.zzcae);
            this.zzcae = null;
        }
        return bl;
    }

    private void zzcb(String string2) {
        int n2 = GLES20.glGetError();
        if (n2 != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n2).toString());
        }
    }
}

