/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkr;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zziy
@TargetApi(value=14)
public class zzc
extends zzi
implements AudioManager.OnAudioFocusChangeListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzbwi = new HashMap<Integer, String>();
    private final zzx zzbwj;
    private final boolean zzbwk;
    private int zzbwl = 0;
    private int zzbwm = 0;
    private MediaPlayer zzbwn;
    private Uri zzbwo;
    private int zzbwp;
    private int zzbwq;
    private int zzbwr;
    private int zzbws;
    private int zzbwt;
    private float zzbwu = 1.0f;
    private boolean zzbwv;
    private boolean zzbww;
    private zzw zzbwx;
    private boolean zzbwy;
    private int zzbwz;
    private zzh zzbxa;

    public zzc(Context context, boolean bl, boolean bl2, zzx zzx2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzbwj = zzx2;
        this.zzbwy = bl;
        this.zzbwk = bl2;
        this.zzbwj.zza(this);
    }

    @Override
    public String zzog() {
        String string = String.valueOf(this.zzbwy ? " spherical" : "");
        return string.length() != 0 ? "MediaPlayer".concat(string) : new String("MediaPlayer");
    }

    @Override
    public void zza(zzh zzh2) {
        this.zzbxa = zzh2;
    }

    @Override
    public void setVideoPath(String string) {
        this.setVideoURI(Uri.parse((String)string));
    }

    public void setVideoURI(Uri uri) {
        this.zzbwo = uri;
        this.zzbwz = 0;
        this.zzoh();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzkn.v("AdMediaPlayerView stop");
        if (this.zzbwn != null) {
            this.zzbwn.stop();
            this.zzbwn.release();
            this.zzbwn = null;
            this.zzaf(0);
            this.zzag(0);
            this.zzok();
        }
        this.zzbwj.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n2, int n3) {
        zzkn.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n2).append(" x ").append(n3).toString());
        this.zzbwp = mediaPlayer.getVideoWidth();
        this.zzbwq = mediaPlayer.getVideoHeight();
        if (this.zzbwp != 0 && this.zzbwq != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzkn.v("AdMediaPlayerView prepared");
        this.zzaf(2);
        this.zzbwj.zzpj();
        zzkr.zzcrf.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbxa != null) {
                    zzc.this.zzbxa.zzpj();
                }
            }
        });
        this.zzbwp = mediaPlayer.getVideoWidth();
        this.zzbwq = mediaPlayer.getVideoHeight();
        if (this.zzbwz != 0) {
            this.seekTo(this.zzbwz);
        }
        this.zzoi();
        int n2 = this.zzbwp;
        int n3 = this.zzbwq;
        zzkn.zzde((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n2).append(" x ").append(n3).toString());
        if (this.zzbwm == 3) {
            this.play();
        }
        this.zzoj();
        this.zzoq();
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        zzkn.v("AdMediaPlayerView completion");
        this.zzaf(5);
        this.zzag(5);
        zzkr.zzcrf.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbxa != null) {
                    zzc.this.zzbxa.zzpl();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mediaPlayer, int n2, int n3) {
        String string = zzbwi.get(n2);
        String string2 = zzbwi.get(n3);
        zzkn.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
        final String string = zzbwi.get(n2);
        final String string2 = zzbwi.get(n3);
        zzkn.zzdf((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzaf(-1);
        this.zzag(-1);
        zzkr.zzcrf.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbxa != null) {
                    zzc.this.zzbxa.zzl(string, string2);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n2) {
        this.zzbwr = n2;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
        zzkn.v("AdMediaPlayerView surface created");
        this.zzoh();
        zzkr.zzcrf.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbxa != null) {
                    zzc.this.zzbxa.zzpi();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
        boolean bl;
        zzkn.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzbwm == 3;
        boolean bl3 = bl = this.zzbwp == n2 && this.zzbwq == n3;
        if (this.zzbwn != null && bl2 && bl) {
            if (this.zzbwz != 0) {
                this.seekTo(this.zzbwz);
            }
            this.play();
        }
        if (this.zzbwx != null) {
            this.zzbwx.zzg(n2, n3);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzkn.v("AdMediaPlayerView surface destroyed");
        if (this.zzbwn != null && this.zzbwz == 0) {
            this.zzbwz = this.zzbwn.getCurrentPosition();
        }
        if (this.zzbwx != null) {
            this.zzbwx.zzpt();
        }
        zzkr.zzcrf.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbxa != null) {
                    zzc.this.zzbxa.onPaused();
                    zzc.this.zzbxa.zzpm();
                }
            }
        });
        this.zzz(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzbwj.zzb(this);
    }

    protected void onMeasure(int n2, int n3) {
        int n4 = zzc.getDefaultSize((int)this.zzbwp, (int)n2);
        int n5 = zzc.getDefaultSize((int)this.zzbwq, (int)n3);
        if (this.zzbwp > 0 && this.zzbwq > 0 && this.zzbwx == null) {
            int n6 = View.MeasureSpec.getMode((int)n2);
            int n7 = View.MeasureSpec.getSize((int)n2);
            int n8 = View.MeasureSpec.getMode((int)n3);
            int n9 = View.MeasureSpec.getSize((int)n3);
            if (n6 == 0x40000000 && n8 == 0x40000000) {
                n5 = n9;
                n4 = n7;
                if (this.zzbwp * n5 < n4 * this.zzbwq) {
                    n4 = n5 * this.zzbwp / this.zzbwq;
                } else if (this.zzbwp * n5 > n4 * this.zzbwq) {
                    n5 = n4 * this.zzbwq / this.zzbwp;
                }
            } else if (n6 == 0x40000000) {
                n4 = n7;
                n5 = n4 * this.zzbwq / this.zzbwp;
                if (n8 == Integer.MIN_VALUE && n5 > n9) {
                    n5 = n9;
                }
            } else if (n8 == 0x40000000) {
                n5 = n9;
                n4 = n5 * this.zzbwp / this.zzbwq;
                if (n6 == Integer.MIN_VALUE && n4 > n7) {
                    n4 = n7;
                }
            } else {
                n4 = this.zzbwp;
                n5 = this.zzbwq;
                if (n8 == Integer.MIN_VALUE && n5 > n9) {
                    n5 = n9;
                    n4 = n5 * this.zzbwp / this.zzbwq;
                }
                if (n6 == Integer.MIN_VALUE && n4 > n7) {
                    n4 = n7;
                    n5 = n4 * this.zzbwq / this.zzbwp;
                }
            }
        }
        this.setMeasuredDimension(n4, n5);
        if (this.zzbwx != null) {
            this.zzbwx.zzg(n4, n5);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzbws > 0 && this.zzbws != n4 || this.zzbwt > 0 && this.zzbwt != n5) {
                this.zzoi();
            }
            this.zzbws = n4;
            this.zzbwt = n5;
        }
    }

    public String toString() {
        String string = String.valueOf(((Object)((Object)this)).getClass().getName());
        String string2 = String.valueOf(Integer.toHexString(((Object)((Object)this)).hashCode()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private void zzoh() {
        zzkn.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzbwo == null || surfaceTexture == null) {
            return;
        }
        this.zzz(false);
        try {
            Surface surface;
            this.zzbwn = zzu.zzgq().zzps();
            this.zzbwn.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzbwn.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzbwn.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzbwn.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzbwn.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzbwn.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzbwr = 0;
            if (this.zzbwy) {
                this.zzbwx = new zzw(this.getContext());
                this.zzbwx.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzbwx.start();
                surface = this.zzbwx.zzpu();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzbwx.zzpt();
                    this.zzbwx = null;
                }
            }
            this.zzbwn.setDataSource(this.getContext(), this.zzbwo);
            surface = zzu.zzgr().zza(surfaceTexture);
            this.zzbwn.setSurface(surface);
            this.zzbwn.setAudioStreamType(3);
            this.zzbwn.setScreenOnWhilePlaying(true);
            this.zzbwn.prepareAsync();
            this.zzaf(1);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzbwo);
            zzkn.zzd((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzbwn, 1, 0);
        }
    }

    private void zzoi() {
        if (!this.zzbwk) {
            return;
        }
        if (this.zzol() && this.zzbwn.getCurrentPosition() > 0 && this.zzbwm != 3) {
            long l2;
            zzkn.v("AdMediaPlayerView nudging MediaPlayer");
            this.zzb(0.0f);
            this.zzbwn.start();
            int n2 = this.zzbwn.getCurrentPosition();
            long l3 = zzu.zzgf().currentTimeMillis();
            while (this.zzol() && this.zzbwn.getCurrentPosition() == n2 && (l2 = zzu.zzgf().currentTimeMillis()) - l3 <= 250L) {
            }
            this.zzbwn.pause();
            this.zzoq();
        }
    }

    private void zzoj() {
        AudioManager audioManager = this.zzor();
        if (audioManager != null && !this.zzbww) {
            int n2 = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
            if (n2 == 1) {
                this.zzoo();
            } else {
                zzkn.zzdf((String)"AdMediaPlayerView audio focus request failed");
            }
        }
    }

    private void zzok() {
        zzkn.v("AdMediaPlayerView abandon audio focus");
        AudioManager audioManager = this.zzor();
        if (audioManager != null && this.zzbww) {
            int n2 = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            if (n2 == 1) {
                this.zzbww = false;
            } else {
                zzkn.zzdf((String)"AdMediaPlayerView abandon audio focus failed");
            }
        }
    }

    private void zzz(boolean bl) {
        zzkn.v("AdMediaPlayerView release");
        if (this.zzbwx != null) {
            this.zzbwx.zzpt();
            this.zzbwx = null;
        }
        if (this.zzbwn != null) {
            this.zzbwn.reset();
            this.zzbwn.release();
            this.zzbwn = null;
            this.zzaf(0);
            if (bl) {
                this.zzbwm = 0;
                this.zzag(0);
            }
            this.zzok();
        }
    }

    @Override
    public void play() {
        zzkn.v("AdMediaPlayerView play");
        if (this.zzol()) {
            this.zzbwn.start();
            this.zzaf(3);
            zzkr.zzcrf.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzbxa != null) {
                        zzc.this.zzbxa.zzpk();
                    }
                }
            });
        }
        this.zzag(3);
    }

    @Override
    public void pause() {
        zzkn.v("AdMediaPlayerView pause");
        if (this.zzol() && this.zzbwn.isPlaying()) {
            this.zzbwn.pause();
            this.zzaf(4);
            zzkr.zzcrf.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzbxa != null) {
                        zzc.this.zzbxa.onPaused();
                    }
                }
            });
        }
        this.zzag(4);
    }

    @Override
    public int getDuration() {
        if (this.zzol()) {
            return this.zzbwn.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zzol()) {
            return this.zzbwn.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int n2) {
        zzkn.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n2).toString());
        if (this.zzol()) {
            this.zzbwn.seekTo(n2);
            this.zzbwz = 0;
        } else {
            this.zzbwz = n2;
        }
    }

    private boolean zzol() {
        return this.zzbwn != null && this.zzbwl != -1 && this.zzbwl != 0 && this.zzbwl != 1;
    }

    public void onAudioFocusChange(int n2) {
        if (n2 > 0) {
            this.zzoo();
        } else if (n2 < 0) {
            this.zzop();
        }
    }

    @Override
    public void zzom() {
        this.zzbwv = true;
        this.zzoq();
    }

    @Override
    public void zzon() {
        this.zzbwv = false;
        this.zzoq();
    }

    @Override
    public void zza(float f2) {
        this.zzbwu = f2;
        this.zzoq();
    }

    @Override
    public void zza(float f2, float f3) {
        if (this.zzbwx != null) {
            this.zzbwx.zzb(f2, f3);
        }
    }

    @Override
    public int getVideoWidth() {
        if (this.zzbwn != null) {
            return this.zzbwn.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzbwn != null) {
            return this.zzbwn.getVideoHeight();
        }
        return 0;
    }

    private void zzoo() {
        zzkn.v("AdMediaPlayerView audio focus gained");
        this.zzbww = true;
        this.zzoq();
    }

    private void zzop() {
        zzkn.v("AdMediaPlayerView audio focus lost");
        this.zzbww = false;
        this.zzoq();
    }

    private void zzoq() {
        if (!this.zzbwv && this.zzbww) {
            this.zzb(this.zzbwu);
        } else {
            this.zzb(0.0f);
        }
    }

    private void zzb(float f2) {
        if (this.zzbwn != null) {
            try {
                this.zzbwn.setVolume(f2, f2);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzkn.zzdf((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private AudioManager zzor() {
        Context context = this.getContext();
        return (AudioManager)context.getSystemService("audio");
    }

    private void zzaf(int n2) {
        if (n2 == 3) {
            this.zzbwj.zzqf();
        } else if (this.zzbwl == 3) {
            this.zzbwj.zzqg();
        }
        this.zzbwl = n2;
    }

    private void zzag(int n2) {
        this.zzbwm = n2;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzbwi.put(-1004, "MEDIA_ERROR_IO");
            zzbwi.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzbwi.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzbwi.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzbwi.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzbwi.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzbwi.put(1, "MEDIA_ERROR_UNKNOWN");
        zzbwi.put(1, "MEDIA_INFO_UNKNOWN");
        zzbwi.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzbwi.put(701, "MEDIA_INFO_BUFFERING_START");
        zzbwi.put(702, "MEDIA_INFO_BUFFERING_END");
        zzbwi.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzbwi.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzbwi.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzbwi.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzbwi.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

